/*
 * Decompiled with CFR 0.152.
 */
package treegross.base;

import treegross.base.PlugInCompetition;
import treegross.base.Stand;
import treegross.base.Tree;

public class Competition
implements PlugInCompetition {
    @Override
    public double getc66(Tree t) {
        double h66 = t.h - 2.0 * (t.h - t.cb) / 3.0;
        double cri = t.cw * 0.5;
        double c66 = t.fac * Math.PI * (cri * cri);
        for (int i = 0; i < t.st.ntrees; ++i) {
            if (t.st.tr[i].out >= 0) continue;
            cri = t.st.tr[i].cb >= h66 ? t.st.tr[i].cw * 0.5 : t.st.tr[i].calculateCwAtHeight(h66) * 0.5;
            c66 += t.st.tr[i].fac * Math.PI * cri * cri;
        }
        return c66 /= 10000.0 * t.st.size;
    }

    @Override
    public double getc66c(Tree t) {
        double h66 = t.h - 2.0 * (t.h - t.cb) / 3.0;
        double c66 = 0.0;
        for (int i = 0; i < t.st.ntrees; ++i) {
            if (t.st.tr[i].out < t.st.year || t.st.tr[i].outtype == 1) continue;
            double cri = t.st.tr[i].cb >= h66 ? t.st.tr[i].cw * 0.5 : t.st.tr[i].calculateCwAtHeight(h66) * 0.5;
            c66 += t.st.tr[i].fac * Math.PI * cri * cri;
        }
        double c66max = this.getCritcc(t);
        if ((c66 /= 10000.0 * t.st.size) > c66max - 0.25) {
            c66 = c66max - t.c66;
        }
        if (c66 < 0.0) {
            c66 = 0.0;
        }
        return c66;
    }

    @Override
    public void replaceC66AndC66c(Tree t) {
        t.c66 = 0.0;
        t.c66c = 0.0;
        double h66 = t.h - 2.0 * (t.h - t.cb) / 3.0;
        double cri = t.cw * 0.5;
        double c66 = t.fac * Math.PI * (cri * cri);
        double c66c = 0.0;
        for (int i = 0; i < t.st.ntrees; ++i) {
            if (t.st.tr[i].out < 0) {
                cri = t.st.tr[i].cb >= h66 ? t.st.tr[i].cw * 0.5 : t.st.tr[i].calculateCwAtHeight(h66) * 0.5;
                c66 += t.st.tr[i].fac * Math.PI * cri * cri;
                continue;
            }
            if (t.st.tr[i].out < t.st.year || t.st.tr[i].outtype == 1) continue;
            cri = t.st.tr[i].cb >= h66 ? t.st.tr[i].cw * 0.5 : t.st.tr[i].calculateCwAtHeight(h66) * 0.5;
            c66c += t.st.tr[i].fac * Math.PI * cri * cri;
        }
        c66 /= 10000.0 * t.st.size;
        double c66max = this.getCritcc(t);
        if ((c66c /= 10000.0 * t.st.size) > c66max - 0.25) {
            c66c = c66max - t.c66;
        }
        if (c66c < 0.0) {
            c66c = 0.0;
        }
        t.c66 = c66;
        t.c66c = c66c;
    }

    @Override
    public void replaceC66xyAndC66cxy(Tree t, double influenceZoneRadius) {
        if (influenceZoneRadius < 2.0) {
            influenceZoneRadius = 2.0;
        }
        double h66 = t.cb + (t.h - t.cb) / 3.0;
        t.c66xy = 0.0;
        t.c66cxy = 0.0;
        double perc = this.getPercCircleInStand(influenceZoneRadius, t.x, t.y, t.st);
        for (int i = 0; i < t.st.ntrees; ++i) {
            double percOverlapInStand;
            double overlap;
            double cri;
            double distX = t.x - t.st.tr[i].x;
            double distY = t.y - t.st.tr[i].y;
            double e = distX * distX + distY * distY;
            if (e > 0.0) {
                e = Math.sqrt(e);
            }
            if (!(e < influenceZoneRadius + t.st.tr[i].cw * 0.5) || !(t.st.tr[i].h > h66)) continue;
            if (t.st.tr[i].out < 0) {
                cri = t.st.tr[i].cb >= h66 ? t.st.tr[i].cw * 0.5 : t.st.tr[i].calculateCwAtHeight(h66) * 0.5;
                overlap = Competition.overlap(cri, influenceZoneRadius, e);
                if (!(overlap > 0.0)) continue;
                percOverlapInStand = this.getPercOverlapInStand(influenceZoneRadius, t.x, t.y, cri, t.st.tr[i].x, t.st.tr[i].y, t.st);
                t.c66xy += t.st.tr[i].fac * (overlap * percOverlapInStand);
                continue;
            }
            if (t.st.tr[i].out < t.st.year || t.st.tr[i].outtype == 1 || !((overlap = Competition.overlap(cri = t.st.tr[i].cb >= h66 ? t.st.tr[i].cw * 0.5 : t.st.tr[i].calculateCwAtHeight(h66) * 0.5, influenceZoneRadius, e)) > 0.0)) continue;
            percOverlapInStand = this.getPercOverlapInStand(influenceZoneRadius, t.x, t.y, cri, t.st.tr[i].x, t.st.tr[i].y, t.st);
            t.c66cxy += t.st.tr[i].fac * (overlap * percOverlapInStand);
        }
        double div = perc * Math.PI * (influenceZoneRadius * influenceZoneRadius);
        t.c66xy /= div;
        t.c66cxy /= div;
        double c66max = this.getCritcc(t);
        if (t.c66cxy > c66max - 0.25) {
            t.c66cxy = c66max - t.c66xy;
        }
        if (t.c66cxy < 0.0) {
            t.c66cxy = 0.0;
        }
    }

    private static double overlap(double r1, double r2, double e) {
        double x;
        if (r1 > r2) {
            x = r1;
            r1 = r2;
            r2 = x;
        }
        if (e >= r1 + r2) {
            return 0.0;
        }
        double r1s = r1 * r1;
        if (e + r1 <= r2) {
            return Math.PI * r1s;
        }
        x = e * e;
        double r2s = r2 * r2;
        double y = Math.sqrt((-e + r1 + r2) * (e + r1 - r2) * (e - r1 + r2) * (e + r1 + r2));
        double f = r1s * Math.acos((x + r1s - r2s) / (2.0 * e * r1)) + r2s * Math.acos((x + r2s - r1s) / (2.0 * e * r2)) - 0.5 * y;
        if (f < 0.0) {
            return 0.0;
        }
        if (Double.isNaN(f)) {
            return 0.0;
        }
        return f;
    }

    public double getPercCircleInStand(double radius, double x, double y, Stand st) {
        int pan = 0;
        int pani = 0;
        double xpx = x - radius + radius * 0.05;
        double radiusS = radius * radius;
        for (int k = 0; k < 10; ++k) {
            double ypy = y - radius + radius * 0.05;
            double distXS = (xpx - x) * (xpx - x);
            for (int kk = 0; kk < 10; ++kk) {
                double distYS = (ypy - y) * (ypy - y);
                if (distXS + distYS <= radiusS) {
                    ++pan;
                    int in = this.pnpoly(xpx, ypy, st);
                    if (in != 0) {
                        ++pani;
                    }
                }
                ypy += 0.2 * radius;
            }
            xpx += 0.2 * radius;
        }
        return (double)pani / (double)pan;
    }

    private double getPercOverlapInStand(double radius_cz, double x_cz, double y_cz, double radius_crown, double x_crown, double y_crown, Stand st) {
        int pan = 0;
        int pani = 0;
        double xpx = x_crown - radius_crown + radius_crown * 0.05;
        double radiusCrownS = radius_crown * radius_crown;
        double radiusCzS = radius_cz * radius_cz;
        for (int k = 0; k < 10; ++k) {
            double ypy = y_crown - radius_crown + radius_crown * 0.05;
            double dXC = (xpx - x_crown) * (xpx - x_crown);
            double dXI = (xpx - x_cz) * (xpx - x_cz);
            for (int kk = 0; kk < 10; ++kk) {
                double dYI;
                double dYC = (ypy - y_crown) * (ypy - y_crown);
                if (dXC + dYC <= radiusCrownS && dXI + (dYI = (ypy - y_cz) * (ypy - y_cz)) <= radiusCzS) {
                    ++pan;
                    int in = this.pnpoly(xpx, ypy, st);
                    if (in != 0) {
                        ++pani;
                    }
                }
                ypy += 0.2 * radius_crown;
            }
            xpx += 0.2 * radius_crown;
        }
        if (pan > 0) {
            return (double)pani / (double)pan;
        }
        return 0.0;
    }

    public int pnpoly(double x, double y, Stand st) {
        int c = 0;
        int m = st.ncpnt;
        int j = m - 1;
        int i = 0;
        while (i < m) {
            if ((st.cpnt[i].y <= y && y < st.cpnt[j].y || st.cpnt[j].y <= y && y < st.cpnt[i].y) && x < (st.cpnt[j].x - st.cpnt[i].x) * (y - st.cpnt[i].y) / (st.cpnt[j].y - st.cpnt[i].y) + st.cpnt[i].x) {
                c = c == 0 ? 1 : 0;
            }
            j = i++;
        }
        return c;
    }

    private double getCritcc(Tree t) {
        Tree atree = new Tree();
        atree.sp = t.sp;
        atree.st = t.st;
        atree.code = t.code;
        atree.d = t.d;
        atree.h = t.h;
        atree.age = t.age;
        atree.cb = atree.calculateCb();
        atree.cw = atree.calculateCw();
        double maxBa = atree.calculateMaxBasalArea();
        double dS = atree.d * 0.005 * (atree.d * 0.005);
        double cwS = atree.cw * 0.5 * (atree.cw * 0.5);
        double maxNha = maxBa / (Math.PI * dS);
        double critcc = maxNha * Math.PI * cwS * 1.0E-4;
        return critcc;
    }
}

