/*
 * Decompiled with CFR 0.152.
 */
package treegross.base;

import treegross.base.Stand;

public class GenerateXY {
    boolean skidtrail = false;
    double skidtrailDistance = 0.0;
    double skidtrailWidth = 0.0;
    double groupRadius = 0.0;
    double groupCoverArea = 0.0;
    double oldpositionX = 0.0;
    double oldpositionY = 0.0;

    public GenerateXY() {
    }

    public GenerateXY(boolean skidtrails, double distance, double width) {
        this.skidtrail = skidtrails;
        this.skidtrailDistance = distance;
        this.skidtrailWidth = width;
    }

    public void zufall(Stand st) {
        int i;
        int oldRandom = st.random.getRandomType();
        if (!st.random.randomOn) {
            st.random.setRandomType(11);
        }
        double ymin = Double.POSITIVE_INFINITY;
        double xmin = Double.POSITIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        for (i = 0; i < st.ncpnt; ++i) {
            if (st.cpnt[i].x < xmin) {
                xmin = st.cpnt[i].x;
            }
            if (st.cpnt[i].y < ymin) {
                ymin = st.cpnt[i].y;
            }
            if (st.cpnt[i].x > xmax) {
                xmax = st.cpnt[i].x;
            }
            if (!(st.cpnt[i].y > ymax)) continue;
            ymax = st.cpnt[i].y;
        }
        if (this.groupRadius > 0.0) {
            st = this.shuffleTrees(st);
        }
        double xg = 0.0;
        double yg = 0.0;
        double maxtry = 40.0;
        for (i = 0; i < st.ntrees; ++i) {
            boolean ic;
            if (!(st.tr[i].x <= 0.0) || !(st.tr[i].y <= 0.0)) continue;
            double ntry = 0.0;
            block2: do {
                if (!this.skidtrail || this.skidtrailDistance == 0.0) {
                    if (this.groupRadius == 0.0 || this.groupCoverArea == 0.0) {
                        xg = xmin + st.random.nextUniform() * (xmax - xmin);
                        yg = ymin + st.random.nextUniform() * (ymax - ymin);
                        this.oldpositionX = xg;
                        this.oldpositionY = yg;
                        if (this.groupRadius > 0.0) {
                            this.groupCoverArea = this.getCoverArea(st);
                            if (this.groupCoverArea > 0.85) {
                                this.groupCoverArea = 0.0;
                            }
                        }
                    } else {
                        xg = this.oldpositionX - this.groupRadius + st.random.nextUniform() * (2.0 * this.groupRadius);
                        yg = this.oldpositionY - this.groupRadius + st.random.nextUniform() * (2.0 * this.groupRadius);
                        this.groupCoverArea = this.getCoverArea(st);
                        if (this.groupCoverArea > 0.85) {
                            this.groupCoverArea = 0.0;
                        }
                    }
                } else {
                    if (this.groupRadius == 0.0 || this.groupCoverArea == 0.0) {
                        int xkorr = (int)((xmax - xmin) / this.skidtrailDistance);
                        xg = xmin + st.random.nextUniform() * (xmax - xmin) - (double)xkorr * this.skidtrailWidth;
                        yg = ymin + st.random.nextUniform() * (ymax - ymin);
                        this.oldpositionX = xg;
                        this.oldpositionY = yg;
                        if (this.groupRadius > 0.0) {
                            this.groupCoverArea = this.getCoverArea(st);
                            if (this.groupCoverArea > 0.85) {
                                this.groupCoverArea = 0.0;
                            }
                        }
                    } else {
                        xg = this.oldpositionX - this.groupRadius + st.random.nextUniform() * (2.0 * this.groupRadius);
                        yg = this.oldpositionY - this.groupRadius + st.random.nextUniform() * (2.0 * this.groupRadius);
                        this.groupCoverArea = this.getCoverArea(st);
                        if (this.groupCoverArea > 0.85) {
                            this.groupCoverArea = 0.0;
                        }
                    }
                    double xlow = xmin - this.skidtrailDistance * 0.5;
                    do {
                        if (!(xg > (xlow += this.skidtrailDistance))) continue;
                        xg += this.skidtrailWidth;
                    } while (xlow < xmax);
                }
                ic = false;
                for (int j = 0; j < st.ntrees; ++j) {
                    if (j == i || !(st.tr[j].x > 0.0) || !(st.tr[j].y > 0.0) || st.tr[j].out >= 0) continue;
                    ic = true;
                    double distXS = (xg - st.tr[j].x) * (xg - st.tr[j].x);
                    double distYS = (yg - st.tr[j].y) * (yg - st.tr[j].y);
                    double e = Math.sqrt(distXS + distYS);
                    if (e < (st.tr[i].d + st.tr[j].d) * 0.005) continue block2;
                    if (e > (st.tr[i].cw + st.tr[j].cw) * 0.5) {
                        ic = false;
                    }
                    if (st.tr[j].h < st.tr[i].cb) {
                        ic = false;
                    }
                    if (st.tr[i].h < st.tr[j].cb) {
                        ic = false;
                    }
                    if (ic) {
                        double prob;
                        double cwS;
                        double h66i = st.tr[i].cb + (st.tr[i].h - st.tr[i].cb) / 3.0;
                        double h66j = st.tr[j].cb + (st.tr[j].h - st.tr[j].cb) / 3.0;
                        double eki = st.tr[i].cw * 0.5;
                        double ekj = st.tr[j].cw * 0.5;
                        if (h66i > h66j && h66i < st.tr[j].h) {
                            cwS = st.tr[j].cw * 0.5 * (st.tr[j].cw * 0.5);
                            prob = cwS / ((st.tr[j].h - st.tr[j].cb) * 0.6666666666666666);
                            ekj = Math.sqrt(prob * (st.tr[j].h - h66i));
                        }
                        if (h66j > h66i && h66j < st.tr[i].h) {
                            cwS = st.tr[i].cw * 0.5 * (st.tr[i].cw * 0.5);
                            prob = cwS / ((st.tr[i].h - st.tr[i].cb) * 0.6666666666666666);
                            eki = Math.sqrt(prob * (st.tr[i].h - h66j));
                        }
                        if ((maxtry - ntry) / maxtry * (eki + ekj) < e) {
                            ic = false;
                        }
                    }
                    if (ic) continue block2;
                }
            } while (0 == this.pnpoly(xg, yg, st) || ic && (ntry += 1.0) < maxtry);
            st.tr[i].x = xg;
            st.tr[i].y = yg;
        }
        st.sortbyd();
        if (oldRandom != st.random.getRandomType()) {
            st.random.setRandomType(oldRandom);
        }
    }

    public void raster(Stand st, double xspacing, double yspacing, double xstart, double ystart) {
        double xmax;
        double xmin;
        double ymin = xmin = 99999.9;
        double ymax = xmax = -xmin;
        for (int i = 0; i < st.ncpnt; ++i) {
            if (st.cpnt[i].x < xmin) {
                xmin = st.cpnt[i].x;
            }
            if (st.cpnt[i].y < ymin) {
                ymin = st.cpnt[i].y;
            }
            if (st.cpnt[i].x > xmax) {
                xmax = st.cpnt[i].x;
            }
            if (!(st.cpnt[i].y > ymax)) continue;
            ymax = st.cpnt[i].y;
        }
        st.sortbyNo();
        double xx = xstart;
        do {
            double yy = ystart;
            do {
                int merk = -9;
                for (int i = 0; i < st.ntrees; ++i) {
                    if (!(st.tr[i].x <= 0.0) || !(st.tr[i].y <= 0.0) || merk >= 0) continue;
                    merk = i;
                }
                if (merk < 0 || this.pnpoly(yy, xx, st) != 1) continue;
                boolean plant = true;
                for (int i = 0; i < st.ntrees; ++i) {
                    double yDistS;
                    double xDistS;
                    double e;
                    if (!(st.tr[i].x > 0.0) || !(st.tr[i].y > 0.0) || merk == i || !((e = Math.sqrt((xDistS = (xx - st.tr[i].x) * (xx - st.tr[i].x)) + (yDistS = (st.tr[i].y - yy) * (st.tr[i].y - yy)))) < 2.0 * st.tr[i].d / 100.0)) continue;
                    plant = false;
                }
                if (!plant) continue;
                st.tr[merk].x = xx;
                st.tr[merk].y = yy;
            } while ((yy += yspacing) < ymax);
        } while ((xx += xspacing) < xmax);
        this.zufall(st);
        st.sortbyd();
    }

    public int pnpoly(double x, double y, Stand st) {
        int c = 0;
        int m = st.ncpnt;
        int j = m - 1;
        int i = 0;
        while (i < m) {
            if ((st.cpnt[i].y <= y && y < st.cpnt[j].y || st.cpnt[j].y <= y && y < st.cpnt[i].y) && x < (st.cpnt[j].x - st.cpnt[i].x) * (y - st.cpnt[i].y) / (st.cpnt[j].y - st.cpnt[i].y) + st.cpnt[i].x) {
                c = c == 0 ? 1 : 0;
            }
            j = i++;
        }
        return c;
    }

    public void setGroupRadius(double radius) {
        this.groupRadius = radius;
    }

    private double getCoverArea(Stand st) {
        double co = 0.0;
        double groupRadiusS = this.groupRadius * this.groupRadius;
        for (int k = 0; k < st.ntrees; ++k) {
            double distYS;
            double distXS;
            double d;
            if (st.tr[k].out >= 0 || !(st.tr[k].x >= 0.0) || !(st.tr[k].y > 0.0) || !((d = (distXS = (this.oldpositionX - st.tr[k].x) * (this.oldpositionX - st.tr[k].x)) + (distYS = (this.oldpositionY - st.tr[k].y) * (this.oldpositionY - st.tr[k].y))) <= groupRadiusS)) continue;
            co += Math.PI * (st.tr[k].cw * 0.5 * (st.tr[k].cw * 0.5));
        }
        return co /= Math.PI * (this.groupRadius * this.groupRadius);
    }

    private Stand shuffleTrees(Stand st) {
        int i;
        for (i = 0; i < st.ntrees; ++i) {
            if (!(st.tr[i].x <= 0.0) || !(st.tr[i].y <= 0.0)) continue;
            st.tr[i].x = st.random.nextUniform() - 100.0;
        }
        for (i = 0; i < st.ntrees - 1; ++i) {
            for (int j = i + 1; j < st.ntrees; ++j) {
                if (!(st.tr[i].x > st.tr[j].x)) continue;
                st.tr[st.ntrees + 1] = st.tr[i];
                st.tr[i] = st.tr[j];
                st.tr[j] = st.tr[st.ntrees + 1];
            }
        }
        return st;
    }
}

