/*
 * Decompiled with CFR 0.152.
 */
package treegross.base;

import treegross.base.FunctionInterpreter;
import treegross.base.Group;
import treegross.base.HeightCurve;
import treegross.base.Stand;
import treegross.base.Tree;

public class Groups {
    Stand st = null;

    public Groups(Stand stx) {
        this.st = stx;
    }

    public int getNumberOfGroups() {
        int ngr = -9;
        for (int i = 0; i < this.st.ntrees; ++i) {
            if (ngr >= this.st.tr[i].group) continue;
            ngr = this.st.tr[i].group;
        }
        return ngr;
    }

    public double getGha(int gr) {
        double bha = 0.0;
        for (int i = 0; i < this.st.ntrees; ++i) {
            if (this.st.tr[i].group != gr || !(this.st.tr[i].d >= 7.0) || this.st.tr[i].out >= 1) continue;
            bha += this.st.tr[i].fac * Math.PI * (this.st.tr[i].d * 0.005) * (this.st.tr[i].d * 0.005);
        }
        return bha /= this.st.size;
    }

    public double getNha(int gr) {
        double nha = 0.0;
        for (int i = 0; i < this.st.ntrees; ++i) {
            if (this.st.tr[i].group != gr || !(this.st.tr[i].d >= 7.0) || this.st.tr[i].out >= 1) continue;
            nha += this.st.tr[i].fac;
        }
        return nha /= this.st.size;
    }

    public double getVha(int gr) {
        double vha = 0.0;
        for (int i = 0; i < this.st.ntrees; ++i) {
            if (this.st.tr[i].group != gr || !(this.st.tr[i].d >= 7.0) || this.st.tr[i].out >= 1) continue;
            vha += this.st.tr[i].fac * this.st.tr[i].v;
        }
        return vha /= this.st.size;
    }

    public double getDg(int gr) {
        double dg = 0.0;
        double nha = this.getNha(gr);
        if (nha > 0.0) {
            dg = 200.0 * Math.sqrt(this.getGha(gr) / this.getNha(gr) / Math.PI);
        }
        return dg;
    }

    public double getSI(int gr) {
        double si = 0.0;
        double n = 0.0;
        for (int i = 0; i < this.st.ntrees; ++i) {
            if (this.st.tr[i].group != gr || !(this.st.tr[i].d >= 7.0) || this.st.tr[i].out >= 1) continue;
            si += this.st.tr[i].si;
            n += 1.0;
        }
        si = n > 0.0 ? (si /= n) : 0.0;
        return si;
    }

    public int getSpeciesCode(int gr) {
        int code = 0;
        for (int i = 0; i < this.st.ntrees; ++i) {
            if (this.st.tr[i].group != gr) continue;
            code = this.st.tr[i].code;
            return code;
        }
        return code;
    }

    public double getHg(int gr) {
        double hg = 0.0;
        double dg = this.getDg(gr);
        int code = this.getSpeciesCode(gr);
        int merk = 0;
        for (int i = 0; i < this.st.nspecies; ++i) {
            if (this.st.sp[i].code != code) continue;
            merk = i;
        }
        HeightCurve hc = new HeightCurve();
        if (dg > 0.0) {
            if (this.st.sp[merk].heightcurveUsed.contains("Einh")) {
                Tree tree = new Tree();
                tree.d = dg;
                tree.sp = this.st.sp[merk];
                tree.sp.dg = this.st.sp[merk].dg;
                tree.sp.hg = this.st.sp[merk].hg;
                FunctionInterpreter fi = new FunctionInterpreter();
                hg = fi.getValueForTree(tree, tree.sp.spDef.uniformHeightCurveXML);
            } else {
                int ncurve = Integer.parseInt(this.st.sp[merk].heightcurveUsed.substring(0, 1));
                hg = hc.getHeight(ncurve, dg, this.st.sp[merk].heightcurveUsedP0, this.st.sp[merk].heightcurveUsedP1, this.st.sp[merk].heightcurveUsedP2);
            }
        }
        return hg;
    }

    public double getAge(int gr) {
        double age = 0.0;
        double n = 0.0;
        for (int i = 0; i < this.st.ntrees; ++i) {
            if (this.st.tr[i].group != gr || !(this.st.tr[i].d >= 7.0) || this.st.tr[i].out >= 1) continue;
            age += (double)this.st.tr[i].age;
            n += 1.0;
        }
        age = n > 0.0 ? (age /= n) : 0.0;
        return age;
    }

    public double getVaus(int gr, int typ, int fromYear) {
        double vha = 0.0;
        for (int i = 0; i < this.st.ntrees; ++i) {
            if (this.st.tr[i].group != gr || !(this.st.tr[i].d >= 7.0) || this.st.tr[i].outtype < typ || this.st.tr[i].out < fromYear) continue;
            vha += this.st.tr[i].fac * this.st.tr[i].v;
        }
        return vha /= this.st.size;
    }

    public double getNaus(int gr, int typ, int fromYear) {
        double nha = 0.0;
        for (int i = 0; i < this.st.ntrees; ++i) {
            if (this.st.tr[i].group != gr || !(this.st.tr[i].d >= 7.0) || this.st.tr[i].outtype < typ || this.st.tr[i].out < fromYear) continue;
            nha += this.st.tr[i].fac;
        }
        return nha /= this.st.size;
    }

    public double getGaus(int gr, int typ, int fromYear) {
        double gha = 0.0;
        for (int i = 0; i < this.st.ntrees; ++i) {
            if (this.st.tr[i].group != gr || !(this.st.tr[i].d >= 7.0) || this.st.tr[i].outtype < typ || this.st.tr[i].out < fromYear) continue;
            gha += this.st.tr[i].fac * Math.PI * (this.st.tr[i].d * 0.005) * (this.st.tr[i].d * 0.005);
        }
        return gha /= this.st.size;
    }

    public double getDgaus(int gr, int typ, int fromYear) {
        double dga = 0.0;
        double m = 0.0;
        for (int i = 0; i < this.st.ntrees; ++i) {
            if (this.st.tr[i].group != gr || !(this.st.tr[i].d >= 7.0) || this.st.tr[i].outtype < typ || this.st.tr[i].out < fromYear) continue;
            dga += this.st.tr[i].fac * Math.PI * (this.st.tr[i].d * 0.005) * (this.st.tr[i].d * 0.005);
            m += this.st.tr[i].fac;
        }
        if (m > 0.0) {
            dga /= m;
            dga = 200.0 * Math.sqrt(dga / Math.PI);
        }
        return dga;
    }

    public double getV_mort(int gr, int fromYear) {
        double vha = 0.0;
        for (int i = 0; i < this.st.ntrees; ++i) {
            if (this.st.tr[i].group != gr || this.st.tr[i].outtype != 1 || this.st.tr[i].out < fromYear) continue;
            vha += this.st.tr[i].fac * this.st.tr[i].v;
        }
        return vha /= this.st.size;
    }

    public double getN_mort(int gr, int fromYear) {
        double nha = 0.0;
        for (int i = 0; i < this.st.ntrees; ++i) {
            if (this.st.tr[i].group != gr || this.st.tr[i].outtype != 1 || this.st.tr[i].out < fromYear) continue;
            nha += this.st.tr[i].fac;
        }
        return nha /= this.st.size;
    }

    public double getG_mort(int gr, int fromYear) {
        double gha = 0.0;
        for (int i = 0; i < this.st.ntrees; ++i) {
            if (this.st.tr[i].group != gr || this.st.tr[i].outtype != 1 || this.st.tr[i].out < fromYear) continue;
            gha += this.st.tr[i].fac * Math.PI * (this.st.tr[i].d * 0.005) * (this.st.tr[i].d * 0.005);
        }
        return gha /= this.st.size;
    }

    public double getDg_mort(int gr, int fromYear) {
        double dga = 0.0;
        double m = 0.0;
        for (int i = 0; i < this.st.ntrees; ++i) {
            if (this.st.tr[i].group != gr || this.st.tr[i].outtype != 1 || this.st.tr[i].out < fromYear) continue;
            dga += this.st.tr[i].fac * Math.PI * (this.st.tr[i].d * 0.005) * (this.st.tr[i].d * 0.005);
            m += this.st.tr[i].fac;
        }
        if (m > 0.0) {
            dga /= m;
            dga = 200.0 * Math.sqrt(dga / Math.PI);
        }
        return dga;
    }

    public double getFlAnteilCS(int gr) {
        double antfl = 0.0;
        double fl = 0.0;
        double sum = 0.0;
        for (int i = 0; i < this.st.ntrees; ++i) {
            if (!(this.st.tr[i].d >= 7.0) || this.st.tr[i].out >= 1) continue;
            double cRS = this.st.tr[i].cw * 0.5 * (this.st.tr[i].cw * 0.5);
            sum += Math.PI * cRS;
            if (this.st.tr[i].group != gr) continue;
            fl += Math.PI * cRS;
        }
        if (sum > 0.0) {
            antfl = fl / sum;
        }
        return antfl;
    }

    public void setAutoGrouping() {
        int i;
        Group[] grp = new Group[500];
        for (i = 0; i < this.st.ntrees; ++i) {
            this.st.tr[i].group = 0;
        }
        for (i = 0; i < this.st.nspecies; ++i) {
            int merk;
            int j;
            int ngrp = 0;
            for (j = 0; j < 500; ++j) {
                grp[j] = new Group();
            }
            for (j = 0; j < this.st.ntrees; ++j) {
                if (this.st.tr[j].code != this.st.sp[i].code || this.st.tr[j].out >= 0) continue;
                merk = -9;
                for (int jj = 0; jj < ngrp; ++jj) {
                    if (grp[jj].age != this.st.tr[j].age) continue;
                    merk = jj;
                }
                if (merk < 0) {
                    merk = ngrp++;
                }
                grp[merk].age = this.st.tr[j].age;
                grp[merk].avage = this.st.tr[j].age;
                grp[merk].gha += Math.PI * (this.st.tr[j].d * 0.005 * (this.st.tr[j].d * 0.005));
                ++grp[merk].nha;
            }
            for (j = 0; j < ngrp - 1; ++j) {
                for (int k = j + 1; k < ngrp; ++k) {
                    if (grp[j].age >= grp[k].age) continue;
                    Group grpt = grp[j];
                    grp[j] = grp[k];
                    grp[k] = grpt;
                }
            }
            int agedist = 999;
            while (ngrp > 3) {
                int j2;
                merk = 9999999;
                for (j2 = 0; j2 < ngrp - 1; ++j2) {
                    if (!((double)agedist > grp[j2].avage - grp[j2 + 1].avage)) continue;
                    merk = j2;
                }
                if (merk <= 0) continue;
                grp[merk].avage = (grp[merk].avage * (double)grp[merk].nha + grp[merk + 1].avage * (double)grp[merk + 1].nha) / (double)(grp[merk].nha + grp[merk + 1].nha);
                grp[merk].gha += grp[merk + 1].gha;
                grp[merk].nha += grp[merk + 1].nha;
                for (j2 = merk + 1; j2 < ngrp - 1; ++j2) {
                    grp[j2] = grp[j2 + 1];
                }
                --ngrp;
            }
            for (int j3 = 0; j3 < ngrp; ++j3) {
            }
        }
    }
}

