/*
 * Decompiled with CFR 0.152.
 */
package treegross.base;

public class HeightCurve {
    int n;
    double[] sb = new double[6];
    double[] xbar = new double[6];
    double[] std = new double[6];
    double[] d = new double[6];
    double[] t = new double[6];
    double[] b = new double[6];
    double[] bc = new double[6];
    int[] lw = new int[6];
    int[] mw = new int[6];
    int[] isave = new int[6];
    double[] r = new double[26];
    double[] rx = new double[26];
    double[] ry = new double[26];
    int ind;
    int m;
    int df;
    int dfr;
    int ndep;
    double[] x = new double[5000];
    double dmat;
    double[] ans = new double[12];
    int numberOfFunctions = 0;

    public void heightcurve() {
        this.n = 0;
    }

    public void adddh(int typ, int anz, double dd, double hh) {
        ++this.n;
        if (typ == 0) {
            this.x[this.n] = hh;
            this.x[this.n + anz] = dd;
            this.x[this.n + 2 * anz] = dd * dd;
            this.ind = 2;
        }
        if (typ == 1) {
            this.x[this.n] = 1.0 / (hh - 1.3);
            this.x[this.n + anz] = 1.0 / dd;
            this.x[this.n + 2 * anz] = 1.0 / (dd * dd);
            this.ind = 2;
        }
        if (typ == 2) {
            this.x[this.n] = 1.0 / Math.exp(Math.log(hh - 1.3) / 3.0);
            this.x[this.n + anz] = 1.0 / dd;
            this.ind = 1;
        }
        if (typ == 3) {
            this.x[this.n] = Math.log(hh);
            this.x[this.n + anz] = Math.log(dd);
            this.x[this.n + 2 * anz] = Math.log(dd) * Math.log(dd);
            this.ind = 2;
        }
        if (typ == 4) {
            this.x[this.n] = hh;
            this.x[this.n + anz] = Math.log(dd);
            this.ind = 1;
        }
        if (typ == 5) {
            this.x[this.n] = Math.log(hh);
            this.x[this.n + anz] = Math.log(dd);
            this.x[this.n + 2 * anz] = dd;
            this.ind = 2;
        }
    }

    public int getNumberOfFunctions() {
        this.getHeightCurveName(0);
        return this.numberOfFunctions;
    }

    public String getHeightCurveName(int number) {
        this.numberOfFunctions = 6;
        String name = "nicht gefunden";
        if (number == 0) {
            name = "0=Parabolic";
        }
        if (number == 1) {
            name = "1=Prodan";
        }
        if (number == 2) {
            name = "2=Petterson 3.0";
        }
        if (number == 3) {
            name = "3=Korsun";
        }
        if (number == 4) {
            name = "4=logarithmic";
        }
        if (number == 5) {
            name = "5=Freese";
        }
        return name;
    }

    public void start() {
        int i;
        for (i = 0; i <= 25; ++i) {
            this.ry[i] = 0.0;
            this.rx[i] = 0.0;
            this.r[i] = 0.0;
        }
        for (i = 0; i <= 5; ++i) {
            this.xbar[i] = 0.0;
            this.std[i] = 0.0;
            this.d[i] = 0.0;
            this.t[i] = 0.0;
            this.b[i] = 0.0;
            this.bc[i] = 0.0;
            this.isave[i] = 0;
        }
        this.ndep = 1;
        this.isave[1] = 2;
        this.isave[2] = 3;
        this.m = this.ind + 1;
        this.corre();
        this.order(this.ind);
        this.minV(this.ind);
        this.mulTre(this.ind);
    }

    int getn() {
        return this.n;
    }

    public double getb0() {
        return this.ans[1];
    }

    public double getb1() {
        return this.bc[1];
    }

    public double getb2() {
        return this.bc[2];
    }

    public double hwert(int typ, double dk) {
        double hk = 0.0;
        if (dk > 0.0) {
            if (typ == 0) {
                hk = this.ans[1] + (this.bc[1] + this.bc[2] * dk) * dk;
            }
            if (typ == 1) {
                hk = 1.3 + dk * dk / (this.bc[2] + (this.bc[1] + this.ans[1] * dk) * dk);
            }
            if (typ == 2) {
                hk = 1.3 + Math.exp(Math.log(1.0 / (this.ans[1] + this.bc[1] * (1.0 / dk))) * 3.0);
            }
            if (typ == 3) {
                hk = Math.exp(this.ans[1] + this.bc[1] * Math.log(dk) + this.bc[2] * Math.log(dk) * Math.log(dk));
            }
            if (typ == 4) {
                hk = this.ans[1] + this.bc[1] * Math.log(dk);
            }
            if (typ == 5) {
                hk = Math.exp(this.ans[1] + this.bc[1] * Math.log(dk) + this.bc[2] * dk);
            }
        }
        if (hk < 1.3) {
            hk = 1.3;
        }
        return hk;
    }

    public double getHeight(int typ, double dk, double b0, double b1, double b2) {
        double hk = 0.0;
        if (dk > 0.0) {
            if (typ == 0) {
                hk = b0 + (b1 + b2 * dk) * dk;
            }
            if (typ == 1) {
                hk = 1.3 + dk * dk / (b2 + (b1 + b0 * dk) * dk);
            }
            if (typ == 2) {
                hk = 1.3 + Math.exp(Math.log(1.0 / (b0 + b1 * (1.0 / dk))) * 3.0);
            }
            if (typ == 3) {
                hk = Math.exp(b0 + b1 * Math.log(dk) + b2 * Math.log(dk) * Math.log(dk));
            }
            if (typ == 4) {
                hk = b0 + b1 * Math.log(dk);
            }
            if (typ == 5) {
                hk = Math.exp(b0 + b1 * Math.log(dk) + b2 * dk);
            }
        }
        if (hk < 1.3) {
            hk = 1.3;
        }
        return hk;
    }

    void corre() {
        int jk;
        int i;
        int j;
        for (j = 1; j <= this.m; ++j) {
            this.b[j] = 0.0;
            this.t[j] = 0.0;
        }
        int k = (this.m * this.m + this.m) / 2;
        for (j = 1; j <= k; ++j) {
            this.r[j] = 0.0;
        }
        double fn = this.n;
        int l = 0;
        for (j = 1; j <= this.m; ++j) {
            for (i = 1; i <= this.n; ++i) {
                this.t[j] = this.t[j] + this.x[++l];
            }
            this.xbar[j] = this.t[j];
            this.t[j] = this.t[j] / fn;
        }
        for (i = 1; i <= this.n; ++i) {
            jk = 0;
            l = i - this.n;
            for (j = 1; j <= this.m; ++j) {
                this.d[j] = this.x[l += this.n] - this.t[j];
                this.b[j] = this.b[j] + this.d[j];
            }
            for (j = 1; j <= this.m; ++j) {
                for (k = 1; k <= j; ++k) {
                    this.r[++jk] = this.r[jk] + this.d[j] * this.d[k];
                }
            }
        }
        jk = 0;
        for (j = 1; j <= this.m; ++j) {
            this.xbar[j] = this.xbar[j] / fn;
            for (k = 1; k <= j; ++k) {
                this.r[++jk] = this.r[jk] - this.b[j] * this.b[k] / fn;
            }
        }
        jk = 0;
        for (j = 1; j <= this.m; ++j) {
            this.std[j] = Math.sqrt(Math.abs(this.r[jk += j]));
        }
        for (j = 1; j <= this.m; ++j) {
            for (k = j; k <= this.m; ++k) {
                jk = j + (k * k - k) / 2;
                l = this.m * (j - 1) + k;
                this.rx[l] = this.r[jk];
                l = this.m * (k - 1) + 1;
                this.rx[l] = this.r[jk];
                this.r[jk] = this.std[j] * this.std[k] == 0.0 ? 0.0 : this.r[jk] / (this.std[j] * this.std[k]);
            }
        }
        fn = Math.sqrt(fn - 1.0);
        for (j = 1; j <= this.m; ++j) {
            this.std[j] = this.std[j] / fn;
        }
        l = -this.m;
        for (i = 1; i <= this.m; ++i) {
            l = l + this.m + 1;
            this.b[i] = this.rx[l];
        }
    }

    void order(int k) {
        int mm = 0;
        for (int j = 1; j <= k; ++j) {
            int l2 = this.isave[j];
            int l = this.ndep - l2 < 0 ? this.ndep + (l2 * l2 - l2) / 2 : l2 + (this.ndep * this.ndep - this.ndep) / 2;
            this.ry[j] = this.r[l];
            for (int i = 1; i <= k; ++i) {
                int l1 = this.isave[i];
                l = l1 - l2 < 0 ? l1 + (l2 * l2 - l2) / 2 : l2 + (l1 * l1 - l1) / 2;
                this.rx[++mm] = this.r[l];
            }
        }
        this.isave[k + 1] = this.ndep;
    }

    void minV(int n) {
        int jk;
        int ji;
        double hold;
        int ki;
        int i;
        int j;
        int k;
        this.dmat = 1.0;
        int nk = -n;
        for (k = 1; k <= n; ++k) {
            int kj;
            int ik;
            int ij;
            this.lw[k] = k;
            this.mw[k] = k;
            int kk = (nk += n) * k;
            double biga = this.rx[kk];
            for (j = k; j <= n; ++j) {
                int iz = n * (j - 1);
                for (i = k; i <= n; ++i) {
                    ij = iz + i;
                    if (!(Math.abs(biga) - Math.abs(this.rx[ij]) < 0.0)) continue;
                    biga = this.rx[ij];
                    this.lw[k] = i;
                    this.mw[k] = j;
                }
            }
            j = this.lw[k];
            if (j - k > 0) {
                ki = k - n;
                for (i = 1; i <= n; ++i) {
                    hold = -this.rx[ki += n];
                    ji = ki - k + j;
                    this.rx[ki] = this.rx[ji];
                    this.rx[ji] = hold;
                }
            }
            if ((i = this.mw[k]) - k > 0) {
                int jp = n * (i - 1);
                for (j = 1; j <= n; ++j) {
                    jk = nk + j;
                    ji = jp + j;
                    hold = -this.rx[jk];
                    this.rx[jk] = this.rx[ji];
                    this.rx[ji] = hold;
                }
            }
            if (biga == 0.0) {
                this.dmat = 0.0;
                break;
            }
            for (i = 1; i <= n; ++i) {
                if (i - k == 0) continue;
                ik = nk + i;
                this.rx[ik] = this.rx[ik] / -biga;
            }
            for (i = 1; i <= n; ++i) {
                ik = nk + i;
                hold = this.rx[ik];
                ij = i - n;
                for (j = 1; j <= n; ++j) {
                    ij += n;
                    if (i - k == 0 || j - k == 0) continue;
                    kj = ij - i + k;
                    this.rx[ij] = hold * this.rx[kj] + this.rx[ij];
                }
            }
            kj = k - n;
            for (j = 1; j <= n; ++j) {
                kj += n;
                if (j - k == 0) continue;
                this.rx[kj] = this.rx[kj] / biga;
            }
            this.dmat *= biga;
            this.rx[kk] = 1.0 / biga;
        }
        k = n;
        if (this.dmat == 0.0) {
            k = 0;
        }
        while (k > 1) {
            if ((i = this.lw[--k]) - k > 0) {
                int jq = n * (k - 1);
                int jr = n * (i - 1);
                for (j = 1; j <= n; ++j) {
                    jk = jq + j;
                    hold = this.rx[jk];
                    ji = jr + j;
                    this.rx[jk] = -this.rx[ji];
                    this.rx[ji] = hold;
                }
            }
            if ((j = this.mw[k]) - k <= 0) continue;
            ki = k - n;
            for (i = 1; i <= n; ++i) {
                hold = this.rx[ki += n];
                ji = ki - k + j;
                this.rx[ki] = -this.rx[ji];
                this.rx[ji] = hold;
            }
        }
    }

    void mulTre(int k) {
        int l;
        int i;
        int l1;
        int j;
        int mm = k + 1;
        for (j = 1; j <= k; ++j) {
            this.bc[j] = 0.0;
        }
        for (j = 1; j <= k; ++j) {
            l1 = k * (j - 1);
            for (i = 1; i <= k; ++i) {
                l = l1 + i;
                this.bc[j] = this.bc[j] + this.ry[i] * this.rx[l];
            }
        }
        double rm = 0.0;
        double bo = 0.0;
        l1 = this.isave[mm];
        for (i = 1; i <= k; ++i) {
            rm += this.bc[i] * this.ry[i];
            l = this.isave[i];
            this.bc[i] = this.std[l] != 0.0 ? this.bc[i] * (this.std[l1] / this.std[l]) : 0.0;
            bo += this.bc[i] * this.xbar[l];
        }
        bo = this.xbar[l1] - bo;
        double ssar = rm * this.b[l1];
        rm = Math.sqrt(Math.abs(rm));
        double ssdr = this.b[l1] - ssar;
        double fn = this.n - k - 1;
        double sy = ssdr / fn;
        for (j = 1; j <= k; ++j) {
            l1 = k * (j - 1) + j;
            l = this.isave[j];
            this.sb[j] = this.b[l] > 0.0 ? Math.sqrt(Math.abs(this.rx[l1] / this.b[l] * sy)) : -999.9;
            if (this.sb[j] != 0.0) {
                this.t[j] = this.bc[j] / this.sb[j];
            } else {
                this.sb[j] = -999.9;
            }
            this.t[j] = this.bc[j] / this.sb[j];
        }
        sy = Math.sqrt(Math.abs(sy));
        int fk = k;
        this.ans[1] = bo;
        this.ans[2] = rm;
        this.ans[3] = sy;
        this.ans[4] = ssar;
        this.ans[5] = fk;
        this.ans[6] = ssar / (double)fk;
        this.ans[7] = ssdr;
        this.ans[8] = fn;
        this.ans[9] = ssdr / fn;
        this.ans[10] = this.ans[6] / this.ans[9];
    }
}

