/*
 * Decompiled with CFR 0.152.
 */
package treegross.base;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import treegross.base.TaperFunction;

public class JSortiererNFV
implements Serializable {
    int numberOfFunctions;
    String funInfo;
    int funNo;
    double dbh;
    double mh;
    double dTop;
    double mhTop;
    double height;
    double asStarth;
    double asEndh;
    double asMinAvD;
    double asMaxAvD;
    double asMinTopD;
    double asMaxTopD;
    public double asMinLen;
    public double asMaxLen;
    public double asIntervall;
    public double asAddLenPer;
    public double asAddLenAbs;
    public boolean logFound;
    public double logLength;
    public double logTopD;
    public double logMidD;
    public double logAddLength;
    String modelRegion = "default";
    TaperFunction tp = null;
    public static final String PROP_SAMPLE_PROPERTY = "sampleProperty";
    private String sampleProperty;
    private final PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);

    public JSortiererNFV(String region) {
        this.modelRegion = region;
        this.tp = new TaperFunction(this.modelRegion);
    }

    public String getSampleProperty() {
        return this.sampleProperty;
    }

    public void setSampleProperty(String value) {
        String oldValue = this.sampleProperty;
        this.sampleProperty = value;
        this.propertySupport.firePropertyChange(PROP_SAMPLE_PROPERTY, oldValue, this.sampleProperty);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public boolean getAssortment(int function, double du_cm, double hu_m, double do_cm, double ho_m, double hoehe_m, double hs_m, double he_m, double dmmin_cm, double dmmax_cm, double dzmin_cm, double dzmax_cm, double laengmin_m, double laengmax_m, double intervall_m, double laengzpro, double laengzab_m) {
        this.funNo = function;
        this.dbh = du_cm;
        this.mh = hu_m;
        this.dTop = do_cm;
        this.mhTop = ho_m;
        this.height = hoehe_m;
        if (this.dTop > this.dbh) {
            this.dTop = 0.0;
            this.mhTop = 0.0;
        }
        this.asStarth = hs_m;
        this.asEndh = he_m;
        this.asMinAvD = dmmin_cm;
        this.asMaxAvD = dmmax_cm;
        this.asMinTopD = dzmin_cm;
        this.asMaxTopD = dzmax_cm;
        this.asMinLen = laengmin_m;
        this.asMaxLen = laengmax_m;
        this.asIntervall = intervall_m;
        this.asAddLenPer = laengzpro;
        this.asAddLenAbs = laengzab_m;
        return this.findLog();
    }

    boolean findLog() {
        this.logFound = true;
        this.logTopD = this.asMinTopD;
        this.logMidD = 0.0;
        this.logLength = 0.0;
        double hu = this.asStarth;
        if (this.asMinTopD > this.dbh || this.asStarth > this.asEndh) {
            this.logFound = false;
        } else {
            double ho = this.tp.getLengthEst(this.funNo, this.dbh, this.height, this.asMinTopD);
            if (ho >= this.asEndh) {
                ho = this.asEndh;
            }
            this.logLength = ho - this.asStarth;
            this.logAddLength = this.asAddLenPer > 0.0 ? this.logLength * (this.asAddLenPer / 100.0) : this.asAddLenAbs;
            this.logMidD = this.tp.getDiameterEst(this.funNo, this.dbh, this.height, this.asStarth + this.logLength / 2.0, 0, 0);
            if (this.logMidD < this.asMinAvD) {
                this.logMidD = this.asMinAvD;
                ho = this.tp.getLengthEst(this.funNo, this.dbh, this.height, this.asMinAvD);
                this.logLength = (ho - this.asStarth) * 2.0;
                this.logTopD = this.tp.getDiameterEst(this.funNo, this.dbh, this.height, this.asStarth + this.logLength, 0, 0);
                this.logAddLength = this.asAddLenPer > 0.0 ? this.logLength * (this.asAddLenPer / 100.0) : this.asAddLenAbs;
            }
            if (this.logLength > this.asMaxLen) {
                this.logLength = this.asMaxLen;
                ho = this.asStarth + this.logLength;
                this.logTopD = this.tp.getDiameterEst(this.funNo, this.dbh, this.height, ho, 0, 0);
                this.logMidD = this.tp.getDiameterEst(this.funNo, this.dbh, this.height, this.asStarth + this.logLength / 2.0, 0, 0);
                this.logAddLength = this.asAddLenPer > 0.0 ? this.logLength * (this.asAddLenPer / 100.0) : this.asAddLenAbs;
            }
            if (this.logTopD < this.asMinTopD || this.logTopD > this.asMaxTopD) {
                this.logFound = false;
            }
            if (this.logMidD < this.asMinAvD || this.logMidD > this.asMaxAvD) {
                this.logFound = false;
            }
            if (this.logLength < this.asMinLen || this.logLength > this.asMaxLen) {
                this.logFound = false;
            }
        }
        return this.logFound;
    }

    public double getADm_cm() {
        return this.tp.getDiameterEst(this.funNo, this.dbh, this.height, this.asStarth + this.logLength / 2.0, 1, 0);
    }

    public double getADz_cm() {
        return this.tp.getDiameterEst(this.funNo, this.dbh, this.height, this.asStarth + this.logLength, 1, 0);
    }

    public double getADb_cm() {
        return this.tp.getDiameterEst(this.funNo, this.dbh, this.height, this.asStarth, 1, 0);
    }

    public double getALae_m() {
        return this.logLength;
    }

    public double getAPos_m() {
        return this.asStarth;
    }

    public double getAVolmR_m3() {
        return this.tp.getCumVolume(this.funNo, this.dbh, this.height, this.asStarth + this.logLength, 0, 0) - this.tp.getCumVolume(this.funNo, this.dbh, this.height, this.asStarth, 0, 0);
    }

    public double getAVoloR_m3() {
        return this.tp.getCumVolume(this.funNo, this.dbh, this.height, this.asStarth + this.logLength, 1, 0) - this.tp.getCumVolume(this.funNo, this.dbh, this.height, this.asStarth, 1, 0);
    }

    public double getALaengzug_cm() {
        return this.logAddLength * 100.0;
    }

    public double getARestU_m3() {
        return this.tp.getCumVolume(this.funNo, this.dbh, this.height, this.asStarth, 0, 0);
    }

    public double getARestO_m3() {
        return this.tp.getCumVolume(this.funNo, this.dbh, this.height, this.height, 0, 0) - this.tp.getCumVolume(this.funNo, this.dbh, this.height, this.asStarth + this.logLength + this.logAddLength, 0, 0);
    }

    public double getADzB_cm() {
        if (this.logFound) {
            return this.logTopD;
        }
        return 0.0;
    }

    public double getADmB_cm() {
        if (this.logFound) {
            return this.logMidD;
        }
        return 0.0;
    }

    private void loadFunctionInfo(int funNo) {
        this.numberOfFunctions = this.tp.getNumberOfFunctions();
        this.funInfo = this.tp.getFunctionName(funNo);
    }

    public int getNumberOfFunctions() {
        this.loadFunctionInfo(this.funNo);
        return this.numberOfFunctions;
    }

    public String getFunctionName(int funNo) {
        this.loadFunctionInfo(funNo);
        return this.funInfo;
    }

    public void setModelRegion(String region) {
        this.modelRegion = region;
    }

    public double getVolumeHuber(double d_cm, double l_m) {
        return Math.PI * (d_cm * 0.005 * (d_cm * 0.005)) * l_m;
    }

    public int getFunNumber(int speciesCodeNds) {
        return this.tp.getFunctionNumber(speciesCodeNds);
    }
}

