/*
 * Decompiled with CFR 0.152.
 */
package treegross.base;

import treegross.base.PlugInMortality;
import treegross.base.Stand;
import treegross.base.Tree;

class Mortality
implements PlugInMortality {
    Mortality() {
    }

    @Override
    public void mortalityByInfluenceZone(Stand st) {
        int[] treeNo = new int[st.ntrees];
        int numberOfCandidates = 0;
        for (int i = 0; i < st.nspecies; ++i) {
            Tree atree = new Tree();
            atree.sp = st.sp[i];
            atree.st = st;
            double olddg = atree.sp.dg;
            double oldhg = atree.sp.hg;
            atree.code = st.sp[i].code;
            atree.d = st.sp[i].dg;
            if (st.sp[i].h100 > 0.0) {
                atree.h = st.sp[i].h100;
            }
            if (atree.h < 7.0) {
                atree.h = 7.0;
            }
            atree.age = (int)Math.round(st.sp[i].h100age);
            if (atree.d < 7.0) {
                atree.d = 7.0;
            }
            if (atree.h < 7.1) {
                atree.h = 7.1;
            }
            if (atree.sp.dg < 7.0) {
                atree.sp.dg = 7.0;
            }
            if (atree.sp.hg < 7.1) {
                atree.sp.hg = 7.1;
            }
            atree.d = atree.sp.dg;
            atree.h = atree.sp.hg;
            atree.cb = atree.calculateCb();
            atree.cw = atree.calculateCw();
            double maxBa = atree.calculateMaxBasalArea();
            double maxNha = maxBa / (Math.PI * (atree.d * 0.005 * (atree.d * 0.005)));
            st.sp[i].spDef.criticalCrownClosure = maxNha * Math.PI * (atree.cw * 0.5 * (atree.cw * 0.5)) * 1.0E-4;
            if (st.sp[i].spDef.criticalCrownClosure < 1.0 && atree.d == 7.0) {
                st.sp[i].spDef.criticalCrownClosure = 1.0;
            }
            st.sp[i].dg = olddg;
            st.sp[i].hg = oldhg;
        }
        do {
            int i;
            st.updateCompetitionMortality(numberOfCandidates, treeNo);
            numberOfCandidates = 0;
            for (i = 0; i < st.ntrees; ++i) {
                if (st.tr[i].out >= 0 || !(st.tr[i].c66xy > st.tr[i].sp.spDef.criticalCrownClosure)) continue;
                treeNo[numberOfCandidates] = i;
                ++numberOfCandidates;
            }
            double maxDiff = Double.NEGATIVE_INFINITY;
            int removeIndex = -1;
            for (i = 0; i < numberOfCandidates; ++i) {
                double actualDiff = st.tr[treeNo[i]].c66xy - st.tr[treeNo[i]].sp.spDef.criticalCrownClosure;
                if (!(actualDiff > maxDiff)) continue;
                maxDiff = actualDiff;
                removeIndex = treeNo[i];
            }
            if (removeIndex < 0) continue;
            st.tr[removeIndex].out = st.year;
            st.tr[removeIndex].outtype = 1;
        } while (numberOfCandidates > 0);
    }
}

