/*
 * Decompiled with CFR 0.152.
 */
package treegross.base;

import treegross.base.FunctionInterpreter;
import treegross.base.Stand;
import treegross.base.Tree;

public class SIofDistrib {
    public void si(Stand st, int code, int alter, double dg, double hg) {
        st.sortbyd();
        double size = st.area();
        int n100 = (int)(100.0 * size);
        if (n100 == 0) {
            n100 = 1;
        }
        double gsum = 0.0;
        int n = 0;
        int i = 0;
        do {
            if (st.tr[i].code != code || st.tr[i].si != -9.0 || st.tr[i].out >= 0) continue;
            ++n;
            gsum += Math.PI * (st.tr[i].d * 0.005 * (st.tr[i].d * 0.005));
        } while (++i < st.ntrees && n < n100);
        double d100 = 200.0 * Math.sqrt(gsum / (Math.PI * (double)n));
        int merk = 0;
        for (i = 0; i < st.nspecies; ++i) {
            if (code != st.sp[i].code) continue;
            merk = i;
        }
        Tree tree = new Tree();
        tree.d = d100;
        tree.sp = st.sp[merk];
        tree.sp.dg = dg;
        tree.sp.hg = hg;
        tree.age = alter;
        FunctionInterpreter fi = new FunctionInterpreter();
        double h100 = fi.getValueForTree(tree, tree.sp.spDef.uniformHeightCurveXML);
        tree = new Tree();
        tree.sp = st.sp[merk];
        tree.sp.h100 = h100;
        tree.age = alter;
        fi = new FunctionInterpreter();
        double siteindex = fi.getValueForTree(tree, st.sp[merk].spDef.siteindexXML);
        for (i = 0; i < st.ntrees; ++i) {
            if (st.tr[i].si != -9.0 || st.tr[i].code != code) continue;
            st.tr[i].si = siteindex;
        }
    }
}

