/*
 * Decompiled with CFR 0.152.
 */
package treegross.base;

import treegross.base.Stand;
import treegross.random.RandomNumber;

public class ScaleManager {
    public static final int SCALE_AUTO = 0;
    public static final int SCALE_FIXED = 1;
    public static final int SCALE_NOT = 2;
    private int nThreads;
    private int nt2;
    private int scaleMethod;
    private int autoThreshold = 500;

    public ScaleManager(int scaleMethod, int scale, int autoTheshold) {
        this.setAutoTheshold(autoTheshold);
        this.setScaleMethod(scaleMethod);
        this.setScale(scale);
    }

    public ScaleManager() {
        this(0, Runtime.getRuntime().availableProcessors(), 500);
    }

    public final void setScale(int scale) {
        this.nThreads = scale;
        if (this.nThreads < 1 || this.nThreads > 32) {
            this.nThreads = 1;
        }
        this.nt2 = this.nThreads * 3;
    }

    public final void setAutoTheshold(int t) {
        this.autoThreshold = t >= 0 ? t : 0;
    }

    public final void setScaleMethod(int m) {
        this.scaleMethod = m;
        if (this.scaleMethod < 0 || this.scaleMethod > 2) {
            this.scaleMethod = 2;
        }
    }

    public int getScaleMethod() {
        return this.scaleMethod;
    }

    public void updateCompetition(Stand st) {
        int localScaleMethod = this.scaleMethod;
        if (this.nThreads == 1 || st.nTreesAlive < this.nt2) {
            localScaleMethod = 2;
        }
        switch (localScaleMethod) {
            case 0: {
                if (st.nTreesAlive >= this.autoThreshold) {
                    this.updateCompetitionFixScale(st);
                    break;
                }
                this.updateCompetitionNoScale(st);
                break;
            }
            case 1: {
                this.updateCompetitionFixScale(st);
                break;
            }
            case 2: {
                this.updateCompetitionNoScale(st);
            }
        }
    }

    public void updateCompetitionMortality(Stand st, int numberOfCandidates, int[] treeNo) {
        if (numberOfCandidates <= 0) {
            return;
        }
        int localScaleMethod = this.scaleMethod;
        if (this.nThreads == 1 || numberOfCandidates < this.nt2) {
            localScaleMethod = 2;
        }
        switch (localScaleMethod) {
            case 0: {
                if (st.nTreesAlive >= this.autoThreshold) {
                    this.updateCompetitionMortalityFixScale(st, numberOfCandidates, treeNo);
                    break;
                }
                this.updateCompetitionMortalityNoScale(st, numberOfCandidates, treeNo);
                break;
            }
            case 1: {
                this.updateCompetitionMortalityFixScale(st, numberOfCandidates, treeNo);
                break;
            }
            case 2: {
                this.updateCompetitionMortalityNoScale(st, numberOfCandidates, treeNo);
            }
        }
    }

    public void updateCrown(Stand st) {
        int localScaleMethod = this.scaleMethod;
        if (this.nThreads == 1 || st.nTreesAlive < this.nt2) {
            localScaleMethod = 2;
        }
        switch (localScaleMethod) {
            case 0: {
                if (st.nTreesAlive >= this.autoThreshold) {
                    this.updateCrownFixScale(st);
                    break;
                }
                this.updateCrownNoScale(st);
                break;
            }
            case 1: {
                this.updateCrownFixScale(st);
                break;
            }
            case 2: {
                this.updateCrownNoScale(st);
            }
        }
    }

    void growTrees(Stand st, int period, RandomNumber random) {
        int localScaleMethod = this.scaleMethod;
        if (this.nThreads == 1 || st.nTreesAlive < this.nt2) {
            localScaleMethod = 2;
        }
        switch (localScaleMethod) {
            case 0: {
                if (st.nTreesAlive >= this.autoThreshold) {
                    this.growFixScale(st, period, random);
                    break;
                }
                this.growNoScale(st, period, random);
                break;
            }
            case 1: {
                this.growFixScale(st, period, random);
                break;
            }
            case 2: {
                this.growNoScale(st, period, random);
            }
        }
    }

    private void updateCompetitionMortalityNoScale(Stand st, int numberOfCandidates, int[] treeNo) {
        for (int i = 0; i < numberOfCandidates; ++i) {
            st.tr[treeNo[i]].updateCompetition();
        }
    }

    private void updateCompetitionMortalityFixScale(Stand st, int numberOfCandidates, int[] treeNo) {
        UpdateThreadCompetitionMortality[] ut = new UpdateThreadCompetitionMortality[this.nThreads];
        int avgSize = numberOfCandidates / this.nThreads;
        int rest = numberOfCandidates % this.nThreads;
        int e = rest + avgSize;
        int s = 0;
        for (int i = 0; i < ut.length; ++i) {
            ut[i] = new UpdateThreadCompetitionMortality(st, s, e, treeNo);
            ut[i].start();
            s = e;
            e += avgSize;
        }
        for (UpdateThreadCompetitionMortality ut1 : ut) {
            try {
                ut1.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void updateCompetitionNoScale(Stand st) {
        for (int i = 0; i < st.ntrees && !st.stop; ++i) {
            if (st.tr[i].out >= 0) continue;
            st.tr[i].updateCompetition();
        }
    }

    private void updateCompetitionFixScale(Stand st) {
        UpdateThreadCompetition[] ut = new UpdateThreadCompetition[this.nThreads];
        int avgSize = st.ntrees / this.nThreads;
        int rest = st.ntrees % this.nThreads;
        int e = rest + avgSize;
        int s = 0;
        for (int i = 0; i < ut.length; ++i) {
            ut[i] = new UpdateThreadCompetition(st, s, e);
            ut[i].start();
            s = e;
            e += avgSize;
        }
        for (UpdateThreadCompetition ut1 : ut) {
            try {
                ut1.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void updateCrownNoScale(Stand st) {
        for (int i = 0; i < st.ntrees && !st.stop; ++i) {
            if (st.tr[i].out >= 0) continue;
            st.tr[i].updateCrown();
        }
    }

    private void updateCrownFixScale(Stand st) {
        UpdateThreadCrown[] ut = new UpdateThreadCrown[this.nThreads];
        int avgSize = st.ntrees / this.nThreads;
        int rest = st.ntrees % this.nThreads;
        int e = rest + avgSize;
        int s = 0;
        for (int i = 0; i < ut.length; ++i) {
            ut[i] = new UpdateThreadCrown(st, s, e);
            ut[i].start();
            s = e;
            e += avgSize;
        }
        for (UpdateThreadCrown ut1 : ut) {
            try {
                ut1.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void growNoScale(Stand st, int period, RandomNumber random) {
        for (int i = 0; i < st.ntrees && !st.stop; ++i) {
            if (st.tr[i].out >= 0) continue;
            st.tr[i].grow(period, random);
        }
    }

    private void growFixScale(Stand st, int period, RandomNumber random) {
        GrowThread[] ut = new GrowThread[this.nThreads];
        int avgSize = st.ntrees / this.nThreads;
        int rest = st.ntrees % this.nThreads;
        int e = rest + avgSize;
        int s = 0;
        for (int i = 0; i < ut.length; ++i) {
            ut[i] = new GrowThread(st, s, e, period, random);
            ut[i].start();
            s = e;
            e += avgSize;
        }
        for (GrowThread ut1 : ut) {
            try {
                ut1.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class UpdateThreadCompetitionMortality
    extends Thread {
        private final Stand st;
        private final int s;
        private final int e;
        private final int[] treeNo;

        public UpdateThreadCompetitionMortality(Stand st, int startIndex, int endIndex, int[] treeNo) {
            this.st = st;
            this.s = startIndex;
            this.e = endIndex;
            this.treeNo = treeNo;
        }

        @Override
        public void run() {
            for (int i = this.s; i < this.e && !this.st.stop; ++i) {
                this.st.tr[this.treeNo[i]].updateCompetition();
            }
        }
    }

    private class UpdateThreadCompetition
    extends Thread {
        private final Stand st;
        private final int s;
        private final int e;

        public UpdateThreadCompetition(Stand st, int startIndex, int endIndex) {
            this.st = st;
            this.s = startIndex;
            this.e = endIndex;
        }

        @Override
        public void run() {
            for (int i = this.s; i < this.e && !this.st.stop; ++i) {
                if (this.st.tr[i].out >= 0) continue;
                this.st.tr[i].updateCompetition();
            }
        }
    }

    private class UpdateThreadCrown
    extends Thread {
        private final Stand st;
        private final int s;
        private final int e;

        public UpdateThreadCrown(Stand st, int startIndex, int endIndex) {
            this.st = st;
            this.s = startIndex;
            this.e = endIndex;
        }

        @Override
        public void run() {
            for (int i = this.s; i < this.e && !this.st.stop; ++i) {
                if (this.st.tr[i].out >= 0) continue;
                this.st.tr[i].updateCrown();
            }
        }
    }

    private class GrowThread
    extends Thread {
        private final Stand st;
        private final int s;
        private final int e;
        private final int period;
        private final RandomNumber random;

        public GrowThread(Stand st, int startIndex, int endIndex, int period, RandomNumber random) {
            this.st = st;
            this.s = startIndex;
            this.e = endIndex;
            this.period = period;
            this.random = random.clone();
        }

        @Override
        public void run() {
            for (int i = this.s; i < this.e && !this.st.stop; ++i) {
                if (this.st.tr[i].out >= 0) continue;
                this.st.tr[i].grow(this.period, this.random);
            }
        }
    }
}

