/*
 * Decompiled with CFR 0.152.
 */
package treegross.base;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import treegross.base.Corners;
import treegross.base.FunctionInterpreter;
import treegross.base.GenDistribution;
import treegross.base.GenerateXY;
import treegross.base.HeightCurve;
import treegross.base.PlugInIngrowth;
import treegross.base.PlugInMortality;
import treegross.base.PlugInRisk;
import treegross.base.ScaleManager;
import treegross.base.Species;
import treegross.base.SpeciesDefMap;
import treegross.base.SpeciesNotDefinedException;
import treegross.base.StandChangeEvent;
import treegross.base.StandChangeListener;
import treegross.base.TreatmentRuleStand;
import treegross.base.Tree;
import treegross.random.RandomNumber;

public class Stand
implements Cloneable {
    public static final double MAX_SITE_INDEX = 110.0;
    public boolean debug = true;
    public int maxStandTrees = 50000;
    public int maxStandSpecies = 30;
    public int maxStandCorners = 200;
    public String standortsKennziffer = "";
    public String programDir = "";
    private SpeciesDefMap sdm = null;
    public String modelRegion = "default";
    public int ntrees = 0;
    public int nTreesAlive = 0;
    public int nspecies = 0;
    public int ncpnt = 0;
    public String standname = "no name";
    public double size = 0.0;
    public double size_ep = 0.0;
    public double nha;
    public double bha;
    public double nhaout;
    public double bhaout;
    public double nhatotal;
    public double bhatotal;
    public double degreeOfDensity;
    public int year = 2009;
    public int monat = 3;
    public int bt = 0;
    public int wet = 0;
    public int ageclass = 0;
    public RandomNumber random;
    public boolean distanceDependent = true;
    public boolean ingrowthActive = false;
    public boolean riskActive = false;
    public double volumeOfDeadwood = 0.0;
    public boolean deadwoodModul = false;
    public String deadwoodModulName = "none";
    public String sortingModul = "none";
    public String biomassModul = "none";
    public String id = "";
    public String datenHerkunft = "";
    public String standort = "";
    public double rechtswert_m = 0.0;
    public double hochwert_m = 0.0;
    public double hoehe_uNN_m = -99.9;
    public int exposition_Gon = -99;
    public double hangneigungProzent = -99.9;
    public String wuchsgebiet = "";
    public String wuchsbezirk = "";
    public String FileXMLSettings = "ForestSimulatorSettings.xml";
    public int temp_Integer;
    public String bemerkungen = "";
    public double dg;
    public double hg;
    public double dgout;
    public double d100;
    public double h100;
    public Tree[] tr = new Tree[this.maxStandTrees];
    public Species[] sp = new Species[this.maxStandSpecies];
    public Corners[] cpnt = new Corners[this.maxStandCorners];
    public Corners center = new Corners();
    public int status = 0;
    public int timeStep = 5;
    public TreatmentRuleStand trule = new TreatmentRuleStand();
    public int nRegeneration = 0;
    int sizeoftr = 0;
    private final ArrayList<StandChangeListener> StandChangeListeners = new ArrayList();
    public double ed = 0.0;
    public double pd = 0.0;
    public int water = -99;
    private final ScaleManager scaleMan = new ScaleManager();
    boolean stop = false;
    private static final Logger LOGGER = Logger.getLogger(Stand.class.getName());

    public Stand() {
        this.random = new RandomNumber(12);
    }

    public Stand(int scaleMethod) {
        this();
        this.scaleMan.setScaleMethod(scaleMethod);
    }

    public void setScaleManScale(int scale) {
        this.scaleMan.setScale(scale);
    }

    public void setScaleManAutoTheshold(int t) {
        this.scaleMan.setAutoTheshold(t);
    }

    public void setScaleManScaleMethod(int method) {
        this.scaleMan.setScaleMethod(method);
    }

    public void updateCompetition() {
        this.scaleMan.updateCompetition(this);
    }

    public void updateCrown() {
        this.scaleMan.updateCrown(this);
    }

    public void updateCompetitionMortality(int numberOfCandidates, int[] treeNo) {
        this.scaleMan.updateCompetitionMortality(this, numberOfCandidates, treeNo);
    }

    public Stand clone() {
        Stand clone = new Stand(this.scaleMan.getScaleMethod());
        clone.debug = this.debug;
        clone.random = this.random.clone();
        clone.maxStandTrees = this.maxStandTrees;
        clone.maxStandSpecies = this.maxStandSpecies;
        clone.maxStandCorners = this.maxStandCorners;
        clone.standortsKennziffer = this.standortsKennziffer;
        clone.programDir = this.programDir;
        clone.sdm = this.sdm;
        clone.modelRegion = this.modelRegion;
        clone.ncpnt = this.ncpnt;
        clone.standname = this.standname;
        clone.size = this.size;
        clone.nha = this.nha;
        clone.bha = this.bha;
        clone.nhaout = this.nhaout;
        clone.bhaout = this.bhaout;
        clone.nhatotal = this.nhatotal;
        clone.bhatotal = this.bhatotal;
        clone.degreeOfDensity = this.degreeOfDensity;
        clone.year = this.year;
        clone.monat = this.monat;
        clone.bt = this.bt;
        clone.wet = this.wet;
        clone.bemerkungen = this.bemerkungen;
        clone.ageclass = this.ageclass;
        clone.riskActive = this.riskActive;
        clone.distanceDependent = this.distanceDependent;
        clone.ingrowthActive = this.ingrowthActive;
        clone.volumeOfDeadwood = this.volumeOfDeadwood;
        clone.deadwoodModul = this.deadwoodModul;
        clone.sortingModul = this.sortingModul;
        clone.biomassModul = this.biomassModul;
        clone.id = this.id;
        clone.datenHerkunft = this.datenHerkunft;
        clone.standort = this.standort;
        clone.rechtswert_m = this.rechtswert_m;
        clone.hochwert_m = this.hochwert_m;
        clone.hoehe_uNN_m = this.hoehe_uNN_m;
        clone.exposition_Gon = this.exposition_Gon;
        clone.hangneigungProzent = this.hangneigungProzent;
        clone.wuchsgebiet = this.wuchsgebiet;
        clone.wuchsbezirk = this.wuchsbezirk;
        clone.FileXMLSettings = this.FileXMLSettings;
        clone.temp_Integer = this.temp_Integer;
        clone.dg = this.dg;
        clone.hg = this.hg;
        clone.dgout = this.dgout;
        clone.d100 = this.d100;
        clone.h100 = this.h100;
        System.arraycopy(this.cpnt, 0, clone.cpnt, 0, this.maxStandCorners);
        clone.center.no = this.center.no;
        clone.center.x = this.center.x;
        clone.center.y = this.center.y;
        clone.center.z = this.center.z;
        clone.trule = this.trule.clone();
        clone.nRegeneration = this.nRegeneration;
        clone.sizeoftr = this.sizeoftr;
        clone.status = this.status;
        clone.riskActive = this.riskActive;
        for (int i = 0; i < this.ntrees; ++i) {
            int crop = 0;
            int tzb = 0;
            int hb = 0;
            if (this.tr[i].crop) {
                crop = 1;
            }
            if (this.tr[i].tempcrop) {
                tzb = 1;
            }
            if (this.tr[i].habitat) {
                hb = 1;
            }
            try {
                clone.addtreefac(this.tr[i].code, this.tr[i].no, this.tr[i].age, this.tr[i].out, this.tr[i].d, this.tr[i].h, this.tr[i].cb, this.tr[i].cw, this.tr[i].si, this.tr[i].x, this.tr[i].y, this.tr[i].z, crop, tzb, hb, this.tr[i].fac);
                clone.tr[i].outtype = this.tr[i].outtype;
                clone.tr[i].layer = this.tr[i].layer;
                clone.tr[i].group = this.tr[i].group;
                clone.tr[i].quality = this.tr[i].quality;
                clone.tr[i].randomIntercept = this.tr[i].randomIntercept;
                clone.tr[i].randomSlope = this.tr[i].randomSlope;
                continue;
            }
            catch (SpeciesNotDefinedException e) {
                if (!this.debug) continue;
                LOGGER.log(Level.WARNING, null, e);
            }
        }
        this.StandChangeListeners.stream().forEach(StandChangeListener2 -> clone.addStandChangeListener((StandChangeListener)StandChangeListener2));
        clone.descspecies();
        return clone;
    }

    public void stop() {
        this.stop = true;
    }

    public void newStand() {
        this.ntrees = 0;
        this.nspecies = 0;
        this.ncpnt = 0;
        this.distanceDependent = false;
        this.random = new RandomNumber(12);
        this.ingrowthActive = true;
        this.trule.treatmentStep = 5;
        this.trule.lastTreatment = 0;
        this.status = 0;
        this.bt = -999;
        this.trule.standType = 0;
        this.wet = -999;
    }

    public void easyStart(String localPath, String xmlSettingsFile, String standname, double standsize, int year) {
        SpeciesDefMap SDM = new SpeciesDefMap();
        LOGGER.log(Level.INFO, "SDM loaded from {0}\\{1}", new Object[]{localPath, xmlSettingsFile});
        if (localPath != null && xmlSettingsFile != null) {
            try {
                SDM.readFromPath(localPath + "\\" + xmlSettingsFile);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "loading species definitions", ex);
            }
        } else {
            SDM.readInternal(null);
        }
        this.setSDM(SDM);
        this.setProgramDir(localPath);
        this.addName(standname);
        this.addsize(standsize);
        this.year = year;
        double l = Math.sqrt(10000.0 * standsize);
        this.ncpnt = 0;
        this.addcornerpoint("ECK1", 0.0, 0.0, 0.0);
        this.addcornerpoint("ECK2", 0.0, l, 0.0);
        this.addcornerpoint("ECK3", l, l, 0.0);
        this.addcornerpoint("ECK4", l, 0.0, 0.0);
        this.center.no = "polygon";
        this.center.x = l * 0.5;
        this.center.y = l * 0.5;
        this.center.z = 0.0;
        this.scaleMan.setScaleMethod(1);
    }

    public void loadSDM(String path) {
        this.sdm = new SpeciesDefMap();
        this.sdm.readFromPath(path);
    }

    public void setSDM(SpeciesDefMap amap) {
        this.sdm = amap;
    }

    public SpeciesDefMap getSDM() {
        return this.sdm;
    }

    public int addCloneTree(int index) {
        Tree t = this.tr[index];
        int zb = 0;
        int tzb = 0;
        int hb = 0;
        if (t.crop) {
            zb = 1;
        }
        if (t.tempcrop) {
            tzb = 1;
        }
        if (t.habitat) {
            hb = 1;
        }
        try {
            this.addtreefac(t.code, t.no.trim() + "clone", t.age, t.out, t.d, t.h, t.cb, t.cw, t.si, t.x, t.y, t.z, zb, tzb, hb, t.fac);
            this.tr[this.ntrees - 1].v = t.v;
            this.tr[this.ntrees - 1].quality = 0.5 + this.random.nextNormal(3.0) / 6.0;
            return this.ntrees - 1;
        }
        catch (SpeciesNotDefinedException e) {
            if (this.debug) {
                LOGGER.log(Level.WARNING, null, e);
            }
            return -9;
        }
    }

    public boolean addtree(int co, String num, int age, int out, double d, double h, double cb, double cw, double si, double x, double y, double z, int zb, int tzb, int hb) throws SpeciesNotDefinedException {
        if (this.ntrees + 1 >= this.maxStandTrees - 1) {
            if (this.debug) {
                LOGGER.log(Level.WARNING, "Maximum tree number reached! Tree not added! {0} {1} d={2} species={3} height={4}", new Object[]{this.standname, this.trule.targetType, d, co, h});
            }
            return false;
        }
        this.tr[this.ntrees] = new Tree();
        this.tr[this.ntrees].code = co;
        this.tr[this.ntrees].no = num;
        this.tr[this.ntrees].age = age;
        this.tr[this.ntrees].out = out;
        this.tr[this.ntrees].crop = false;
        this.tr[this.ntrees].tempcrop = false;
        this.tr[this.ntrees].habitat = false;
        this.tr[this.ntrees].origin = 0;
        this.tr[this.ntrees].year = this.year;
        this.tr[this.ntrees].d = d;
        this.tr[this.ntrees].h = h;
        this.tr[this.ntrees].cb = cb;
        this.tr[this.ntrees].cw = cw;
        this.tr[this.ntrees].x = x;
        this.tr[this.ntrees].y = y;
        if (z < 0.0) {
            z = 0.0;
        }
        this.tr[this.ntrees].z = z;
        this.tr[this.ntrees].outtype = 0;
        this.tr[this.ntrees].fac = 1.0;
        this.tr[this.ntrees].si = si;
        this.tr[this.ntrees].group = -1;
        this.tr[this.ntrees].crop = zb > 0;
        this.tr[this.ntrees].tempcrop = tzb > 0;
        this.tr[this.ntrees].habitat = hb > 0;
        this.tr[this.ntrees].sp = this.addspecies(this.tr[this.ntrees]);
        this.tr[this.ntrees].quality = 0.5 + this.random.nextNormal(3.0) / 6.0;
        try {
            String[] tec = this.tr[this.ntrees].sp.spDef.diameterTreeErrorXML.split(";");
            if (tec.length >= 2) {
                this.tr[this.ntrees].randomIntercept = this.random.nextNormal() * Double.parseDouble(tec[0]);
                this.tr[this.ntrees].randomSlope = this.random.nextNormal() * Double.parseDouble(tec[1]);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.INFO, "Diameter Tree Error for species {0} faulty!!!", this.tr[this.ntrees].code);
        }
        this.tr[this.ntrees].st = this;
        ++this.ntrees;
        return true;
    }

    public boolean addTreeFromPlanting(int co, String num, int age, int out, double d, double h, double cb, double cw, double si, double x, double y, double z, int zb, int tzb, int hb) throws SpeciesNotDefinedException {
        boolean result = this.addtree(co, num, age, out, d, h, cb, cw, si, x, y, z, zb, tzb, hb);
        this.tr[this.ntrees - 1].origin = 1;
        return result;
    }

    public void addTreeFromNaturalIngrowth(int co, String num, int age, int out, double d, double h, double cb, double cw, double si, double x, double y, double z, int zb, int tzb, int hb) throws SpeciesNotDefinedException {
        this.addtree(co, num, age, out, d, h, cb, cw, si, x, y, z, zb, tzb, hb);
        this.tr[this.ntrees - 1].origin = 2;
    }

    public void addTreeFromDB(int co, String num, double fac, int age, int out, int outtype, double d, double h, double v, double cb, double cw, double si, double x, double y, double z, int zb, int tzb, int hb, int layer) throws SpeciesNotDefinedException {
        this.tr[this.ntrees] = new Tree();
        this.tr[this.ntrees].code = co;
        this.tr[this.ntrees].no = num;
        this.tr[this.ntrees].fac = fac;
        this.tr[this.ntrees].age = age;
        this.tr[this.ntrees].out = out;
        this.tr[this.ntrees].outtype = outtype;
        this.tr[this.ntrees].crop = false;
        this.tr[this.ntrees].tempcrop = false;
        this.tr[this.ntrees].habitat = false;
        this.tr[this.ntrees].origin = 0;
        this.tr[this.ntrees].year = this.year;
        this.tr[this.ntrees].d = d;
        this.tr[this.ntrees].h = h;
        this.tr[this.ntrees].v = v;
        this.tr[this.ntrees].cb = cb;
        this.tr[this.ntrees].cw = cw;
        this.tr[this.ntrees].x = x;
        this.tr[this.ntrees].y = y;
        this.tr[this.ntrees].z = z;
        this.tr[this.ntrees].si = si;
        this.tr[this.ntrees].group = -1;
        this.tr[this.ntrees].crop = zb > 0;
        this.tr[this.ntrees].tempcrop = tzb > 0;
        this.tr[this.ntrees].habitat = hb > 0;
        this.tr[this.ntrees].sp = this.addspecies(this.tr[this.ntrees]);
        this.tr[this.ntrees].st = this;
        this.tr[this.ntrees].layer = layer;
        this.tr[this.ntrees].quality = 0.5 + this.random.nextNormal(3.0) / 6.0;
        try {
            String[] tec = this.tr[this.ntrees].sp.spDef.diameterTreeErrorXML.split(";");
            if (tec.length >= 2) {
                this.tr[this.ntrees].randomIntercept = this.random.nextNormal() * Double.parseDouble(tec[0]);
                this.tr[this.ntrees].randomSlope = this.random.nextNormal() * Double.parseDouble(tec[1]);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.INFO, "Diameter Tree Error for species {0} faulty!!!", this.tr[this.ntrees].code);
        }
        ++this.ntrees;
    }

    public void addtreefac(int co, String num, int age, int out, double d, double h, double cb, double cw, double si, double x, double y, double z, int zb, int tzb, int hb, double fac) throws SpeciesNotDefinedException {
        if (this.ntrees + 1 >= this.maxStandTrees - 1) {
            if (this.debug) {
                LOGGER.log(Level.WARNING, "Maximum tree number reached! Tree not added! {0} {1} d={2} species={3} height={4}", new Object[]{this.standname, this.trule.targetType, d, co, h});
            }
            return;
        }
        this.tr[this.ntrees] = new Tree();
        this.tr[this.ntrees].code = co;
        this.tr[this.ntrees].no = num;
        this.tr[this.ntrees].age = age;
        this.tr[this.ntrees].out = out;
        this.tr[this.ntrees].crop = false;
        this.tr[this.ntrees].tempcrop = false;
        this.tr[this.ntrees].habitat = false;
        this.tr[this.ntrees].d = d;
        this.tr[this.ntrees].h = h;
        this.tr[this.ntrees].cb = cb;
        this.tr[this.ntrees].cw = cw;
        this.tr[this.ntrees].origin = 0;
        this.tr[this.ntrees].year = this.year;
        this.tr[this.ntrees].x = x;
        this.tr[this.ntrees].y = y;
        if (z < 0.0) {
            z = 0.0;
        }
        this.tr[this.ntrees].z = z;
        this.tr[this.ntrees].outtype = 0;
        this.tr[this.ntrees].fac = fac;
        this.tr[this.ntrees].si = si;
        this.tr[this.ntrees].group = -1;
        this.tr[this.ntrees].crop = zb > 0;
        this.tr[this.ntrees].tempcrop = tzb > 0;
        this.tr[this.ntrees].habitat = hb > 0;
        this.tr[this.ntrees].quality = 0.5 + this.random.nextNormal(3.0) / 6.0;
        this.tr[this.ntrees].sp = this.addspecies(this.tr[this.ntrees]);
        try {
            String[] tec = this.tr[this.ntrees].sp.spDef.diameterTreeErrorXML.split(";");
            if (tec.length >= 2) {
                this.tr[this.ntrees].randomIntercept = this.random.nextNormal() * Double.parseDouble(tec[0]);
                this.tr[this.ntrees].randomSlope = this.random.nextNormal() * Double.parseDouble(tec[1]);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.INFO, "Diameter Tree Error for species {0} faulty!!!", this.tr[this.ntrees].code);
        }
        this.tr[this.ntrees].st = this;
        ++this.ntrees;
    }

    public void addXMLTree(int codenumber, String number, int age, int out, int outtype, double d, double h, double cb, double cw, double si, double fac, double x, double y, double z, boolean zb, boolean tzb, boolean hb, int layer, double volumeDeadwood, String remarks) throws SpeciesNotDefinedException {
        this.tr[this.ntrees] = new Tree(codenumber, number, age, out, outtype, d, h, cb, cw, si, fac, x, y, z, zb, tzb, hb, layer, volumeDeadwood, remarks);
        this.tr[this.ntrees].sp = this.addspecies(this.tr[this.ntrees]);
        this.tr[this.ntrees].st = this;
        this.tr[this.ntrees].quality = 0.5 + this.random.nextNormal(3.0) / 6.0;
        try {
            String[] tec = this.tr[this.ntrees].sp.spDef.diameterTreeErrorXML.split(";");
            if (tec.length >= 2) {
                this.tr[this.ntrees].randomIntercept = this.random.nextNormal() * Double.parseDouble(tec[0]);
                this.tr[this.ntrees].randomSlope = this.random.nextNormal() * Double.parseDouble(tec[1]);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.INFO, "Diameter Tree Error for species {0} faulty!!!", this.tr[this.ntrees].code);
        }
        ++this.ntrees;
    }

    public void addName(String na) {
        this.standname = na;
    }

    public void addYear(Integer yr) {
        this.year = yr;
    }

    public void addsize(double ha) {
        this.size = ha;
    }

    public void addcornerpoint(String no, double x, double y, double z) {
        this.cpnt[this.ncpnt] = new Corners();
        this.cpnt[this.ncpnt].no = no;
        this.cpnt[this.ncpnt].x = x;
        this.cpnt[this.ncpnt].y = y;
        this.cpnt[this.ncpnt].z = z;
        ++this.ncpnt;
    }

    public void addtreeNFV(int co, String num, int age, int out, double d, double h, double cb, double cw, double si, double x, double y, double z, int zb, int tzb, int hb, int ou, double fac, String rm) throws SpeciesNotDefinedException {
        this.tr[this.ntrees] = new Tree();
        this.tr[this.ntrees].code = co;
        this.tr[this.ntrees].no = num;
        this.tr[this.ntrees].age = age;
        this.tr[this.ntrees].out = out;
        this.tr[this.ntrees].crop = false;
        this.tr[this.ntrees].d = d;
        this.tr[this.ntrees].h = h;
        this.tr[this.ntrees].cb = cb;
        this.tr[this.ntrees].cw = cw;
        this.tr[this.ntrees].x = x;
        this.tr[this.ntrees].y = y;
        this.tr[this.ntrees].z = z;
        this.tr[this.ntrees].outtype = 0;
        this.tr[this.ntrees].fac = fac;
        this.tr[this.ntrees].origin = 0;
        this.tr[this.ntrees].year = this.year;
        this.tr[this.ntrees].layer = ou;
        this.tr[this.ntrees].ou = ou;
        this.tr[this.ntrees].remarks = rm;
        this.tr[this.ntrees].si = si;
        this.tr[this.ntrees].group = -1;
        this.tr[this.ntrees].crop = zb > 0;
        this.tr[this.ntrees].tempcrop = tzb > 0;
        this.tr[this.ntrees].habitat = hb > 0;
        this.tr[this.ntrees].quality = 0.5 + this.random.nextNormal(3.0) / 6.0;
        this.tr[this.ntrees].sp = this.addspecies(this.tr[this.ntrees]);
        try {
            String[] tec = this.tr[this.ntrees].sp.spDef.diameterTreeErrorXML.split(";");
            if (tec.length >= 2) {
                this.tr[this.ntrees].randomIntercept = this.random.nextNormal() * Double.parseDouble(tec[0]);
                this.tr[this.ntrees].randomSlope = this.random.nextNormal() * Double.parseDouble(tec[1]);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.INFO, "Diameter Tree Error for species {0} faulty!!!", this.tr[this.ntrees].code);
        }
        this.tr[this.ntrees].st = this;
        ++this.ntrees;
    }

    public void sortbyd() {
        for (int i = 0; i < this.ntrees - 1; ++i) {
            for (int j = i + 1; j < this.ntrees; ++j) {
                if (!(this.tr[i].d < this.tr[j].d)) continue;
                this.tr[this.ntrees + 1] = this.tr[i];
                this.tr[i] = this.tr[j];
                this.tr[j] = this.tr[this.ntrees + 1];
            }
        }
    }

    public void sortbyh() {
        for (int i = 0; i < this.ntrees - 1; ++i) {
            for (int j = i + 1; j < this.ntrees; ++j) {
                if (!(this.tr[i].h < this.tr[j].h)) continue;
                this.tr[this.ntrees + 1] = this.tr[i];
                this.tr[i] = this.tr[j];
                this.tr[j] = this.tr[this.ntrees + 1];
            }
        }
    }

    public void sortbyy() {
        for (int i = 0; i < this.ntrees - 1; ++i) {
            for (int j = i + 1; j < this.ntrees; ++j) {
                if (!(this.tr[i].y < this.tr[j].y)) continue;
                this.tr[this.ntrees + 1] = this.tr[i];
                this.tr[i] = this.tr[j];
                this.tr[j] = this.tr[this.ntrees + 1];
            }
        }
    }

    public void sortbyNo() {
        for (int i = 0; i < this.ntrees - 1; ++i) {
            for (int j = i + 1; j < this.ntrees; ++j) {
                if (this.tr[i].no.compareTo(this.tr[j].no) <= 0) continue;
                this.tr[this.ntrees + 1] = this.tr[i];
                this.tr[i] = this.tr[j];
                this.tr[j] = this.tr[this.ntrees + 1];
            }
        }
    }

    public void standinfo() {
        this.bha = 0.0;
        this.nha = 0.0;
        this.bhaout = 0.0;
        this.nhaout = 0.0;
        this.nhatotal = 0.0;
        this.bhatotal = 0.0;
        for (int i = 0; i < this.ntrees; ++i) {
            double treeBa = this.tr[i].fac * Math.PI * (this.tr[i].d * 0.005 * (this.tr[i].d * 0.005));
            if (this.tr[i].out < 0) {
                this.nha += this.tr[i].fac;
                if (this.tr[i].d >= 7.0) {
                    this.bha += treeBa;
                }
            }
            if (this.tr[i].out == this.year) {
                this.nhaout += this.tr[i].fac;
                if (this.tr[i].d >= 7.0) {
                    this.bhaout += treeBa;
                }
            }
            if (this.tr[i].out <= 0 || this.tr[i].out >= this.year) continue;
            this.nhatotal += this.tr[i].fac;
            if (!(this.tr[i].d >= 7.0)) continue;
            this.bhatotal += treeBa;
        }
        this.bhatotal = (this.bhatotal + this.bha + this.bhaout) / this.size;
        this.nhatotal = (this.nhatotal + this.nhaout + this.nha) / this.size;
        this.bha /= this.size;
        this.nha /= this.size;
        this.bhaout /= this.size;
        this.nhaout /= this.size;
    }

    public double getVha(int spe) {
        double vha = 0.0;
        for (int i = 0; i < this.ntrees; ++i) {
            if (this.tr[i].code != spe && spe != 0) continue;
            vha += this.tr[i].fac * this.tr[i].v;
        }
        return vha / this.size;
    }

    public double getVhaTargetDiameter(int spe) {
        double vha = 0.0;
        for (int i = 0; i < this.ntrees; ++i) {
            if (this.tr[i].outtype != 3 || this.tr[i].out != this.year || this.tr[i].code != spe && spe != 0) continue;
            vha += this.tr[i].fac * this.tr[i].v;
        }
        return vha / this.size;
    }

    public double getVhaThinning(int spe) {
        double vha = 0.0;
        for (int i = 0; i < this.ntrees; ++i) {
            if (this.tr[i].outtype != 2 || this.tr[i].out != this.year || this.tr[i].code != spe && spe != 0) continue;
            vha += this.tr[i].fac * this.tr[i].v;
        }
        return vha / this.size;
    }

    public int getMissingHeight(int spe) {
        int miss = 0;
        for (int j = this.ntrees - 1; j >= 0; --j) {
            if (!(this.tr[j].d >= 7.0) || !(this.tr[j].h < 1.3) || this.tr[j].code != spe && spe != 0) continue;
            ++miss;
        }
        return miss;
    }

    public double getVhaResidual(int spe) {
        double vha = 0.0;
        for (int i = 0; i < this.ntrees; ++i) {
            if (this.tr[i].out >= 0 || this.tr[i].code != spe && spe != 0) continue;
            vha += this.tr[i].fac * this.tr[i].v;
        }
        return vha / this.size;
    }

    public double getDmax(int spe) {
        double dmax = 0.0;
        for (int i = 0; i < this.ntrees; ++i) {
            if (!(this.tr[i].d > dmax) || this.tr[i].out >= 0 || this.tr[i].code != spe && spe != 0) continue;
            dmax = this.tr[i].d;
        }
        return dmax;
    }

    public void initspecies() {
        this.nspecies = 0;
        this.sp[this.nspecies] = new Species();
        if (this.ntrees > 0) {
            this.sp[0].code = this.tr[0].code;
            ++this.nspecies;
            for (int i = 1; i < this.ntrees; ++i) {
                boolean ic = false;
                for (int j = 0; j < this.nspecies; ++j) {
                    if (this.tr[i].code != this.sp[j].code) continue;
                    ic = true;
                }
                if (ic) continue;
                this.sp[this.nspecies] = new Species();
                this.sp[this.nspecies].code = this.tr[i].code;
                ++this.nspecies;
            }
        }
    }

    public void grow2(int period, boolean naturalIngrowth) {
        this.grow2(period, naturalIngrowth, true);
    }

    public void grow2(int period, boolean naturalIngrowth, boolean mortality) {
        if (mortality) {
            this.executeMortality();
            this.descspecies();
        }
        this.grow(period, naturalIngrowth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grow(int period, boolean naturalIngrowth) {
        block11: {
            if (this.status == 0) {
                this.status = 1;
            }
            if (this.riskActive) {
                try {
                    String modelPlugIn = "treegross.base.Risk";
                    PlugInRisk risk = (PlugInRisk)Class.forName(modelPlugIn).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    risk.applyRisk(this);
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    if (!this.debug) break block11;
                    LOGGER.log(Level.WARNING, "treegross", e);
                }
            }
        }
        this.scaleMan.updateCompetition(this);
        this.scaleMan.growTrees(this, period, this.random);
        this.scaleMan.updateCompetition(this);
        this.year += period;
        this.descspecies();
        this.scaleMan.updateCrown(this);
        if (this.nspecies > 0 && naturalIngrowth) {
            try {
                PlugInIngrowth ig = (PlugInIngrowth)Class.forName(this.sp[0].spDef.ingrowthXML).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ig.predictIngrowth(this);
            }
            catch (Exception e) {
                if (this.debug) {
                    LOGGER.log(Level.WARNING, "treegross", e);
                }
            }
            finally {
                this.descspecies();
            }
        }
        this.cleanTreeArrayReg();
        this.notifyStandChanged("growing", this);
    }

    public void growBack(int years, boolean db) {
        int i;
        for (i = 0; i < this.ntrees; ++i) {
            if (this.tr[i].out >= 0 && this.tr[i].out != this.tr[i].st.year) continue;
            this.tr[i].growBack(years);
        }
        for (i = 0; i < this.ntrees; ++i) {
            for (int ik = 0; ik < this.ntrees; ++ik) {
                if (!(this.tr[ik].d < 7.0) && !(this.tr[ik].h < 5.0) && this.tr[ik].age > 10) continue;
                this.removeTree(ik);
            }
        }
        this.year -= years;
        this.sortbyd();
        this.descspecies();
        for (i = 0; i < this.ntrees; ++i) {
            if (this.tr[i].out >= 0) continue;
            this.tr[i].cw = this.tr[i].calculateCw();
            this.tr[i].cb = this.tr[i].calculateCb();
        }
        this.descspecies();
        if (db) {
            for (int i2 = 0; i2 < this.nspecies; ++i2) {
                if (!(this.sp[i2].dg > 7.0) || !(this.sp[i2].h100age > 10.0) || !(this.sp[i2].d100 > 9.0)) continue;
                Tree atree = new Tree();
                atree.st = this;
                atree.sp = this.sp[i2];
                atree.d = this.sp[i2].d100;
                atree.h = this.sp[i2].h100;
                atree.age = (int)Math.round(this.sp[i2].h100age);
                atree.code = this.sp[i2].code;
                atree.cw = atree.calculateCw();
                double maxStandBasalArea = atree.calculateMaxBasalArea() * atree.getModerateThinningFactor() * (this.sp[i2].percCSA / 100.0);
                double ghaToGen = maxStandBasalArea - this.sp[i2].gha;
                if (!(ghaToGen > 0.0)) continue;
                if (this.sp[i2].dg > 150.0 || this.sp[i2].d100 > 150.0) {
                    LOGGER.log(Level.SEVERE, "treegross", "species dg or d100 too heigh! " + this.sp[i2]);
                }
                try {
                    int j;
                    FunctionInterpreter fi = new FunctionInterpreter();
                    GenDistribution gdb = new GenDistribution();
                    double dgGen = this.sp[i2].dg;
                    double dMaxGen = this.sp[i2].d100;
                    if (dMaxGen / dgGen > 1.8) {
                        dMaxGen = dgGen * 1.8;
                    }
                    gdb.weibull(this, this.sp[i2].code, (int)Math.round(this.sp[i2].h100age), dgGen, this.sp[i2].hg, dMaxGen, ghaToGen * this.size, true);
                    double si_soll = -9.0;
                    for (j = 0; j < this.ntrees; ++j) {
                        if (!(this.tr[j].si > 0.0) || this.tr[j].code != this.sp[i2].code) continue;
                        si_soll = this.tr[j].si;
                    }
                    for (j = 0; j < this.ntrees; ++j) {
                        if (!(this.tr[j].si <= -9.0)) continue;
                        this.tr[j].si = si_soll;
                    }
                    for (j = 0; j < this.ntrees; ++j) {
                        if (this.tr[j].h != 0.0) continue;
                        this.tr[j].h = fi.getValueForTree(this.tr[j], this.tr[j].sp.spDef.uniformHeightCurveXML) + fi.getValueForTree(this.tr[j], this.tr[j].sp.spDef.heightVariationXML) * this.random.nextNormal(3.0);
                    }
                    for (j = 0; j < this.ntrees; ++j) {
                        this.tr[j].setMissingData();
                    }
                    GenerateXY gxy = new GenerateXY();
                    gxy.zufall(this);
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, "", ex);
                }
            }
        }
    }

    private void removeTree(int m) {
        if (this.ntrees > 1) {
            for (int i = m; i < this.ntrees - 1; ++i) {
                this.tr[i] = this.tr[i + 1];
            }
            --this.ntrees;
        } else {
            this.ntrees = 0;
        }
    }

    public double area() {
        double size_m = 0.0;
        if (this.ncpnt > 1) {
            for (int i = 0; i < this.ncpnt - 1; ++i) {
                size_m += (this.cpnt[i].x - this.cpnt[i + 1].x) * (this.cpnt[i].y + this.cpnt[i + 1].y);
            }
            size_m += (this.cpnt[this.ncpnt - 1].x - this.cpnt[0].x) * (this.cpnt[this.ncpnt - 1].y + this.cpnt[0].y);
            size_m = Math.abs(size_m / 20000.0);
        }
        return size_m;
    }

    public void descspecies() {
        int j;
        int i;
        int i2;
        int j2;
        int j3;
        this.nha = 0.0;
        this.nhaout = 0.0;
        this.bha = 0.0;
        this.bhaout = 0.0;
        int startindex = this.ntrees - 1;
        int ndh = 0;
        this.nTreesAlive = 0;
        for (j3 = startindex; j3 >= 0; --j3) {
            if (this.tr[j3].out < 1) {
                ++this.nTreesAlive;
            }
            if (!(this.tr[j3].d >= 7.0)) continue;
            if (this.tr[j3].out < 1) {
                this.nha += this.tr[j3].fac;
                this.bha += this.tr[j3].fac * Math.PI * (this.tr[j3].d * 0.005) * (this.tr[j3].d * 0.005);
                if (this.tr[j3].h >= 1.3) {
                    ++ndh;
                }
            }
            if (this.tr[j3].out != this.year) continue;
            this.nhaout += this.tr[j3].fac;
            this.bhaout += this.tr[j3].fac * Math.PI * (this.tr[j3].d * 0.005) * (this.tr[j3].d * 0.005);
        }
        this.nha /= this.size;
        this.bha /= this.size;
        this.nhaout /= this.size;
        this.bhaout /= this.size;
        if (this.nha > 0.0) {
            this.dg = 200.0 * Math.sqrt(this.bha / (Math.PI * this.nha));
        }
        if (this.nhaout > 0.0) {
            this.dgout = 200.0 * Math.sqrt(this.bhaout / (Math.PI * this.nhaout));
        }
        for (j3 = 0; j3 < this.nspecies; ++j3) {
            this.sp[j3].updateSpecies(this);
        }
        this.d100 = 0.0;
        double n100 = this.size * 100.0;
        if (n100 > 0.0) {
            double jj = 0.0;
            for (int k = 0; jj < n100 && k < this.ntrees; ++k) {
                if (!(this.tr[k].d >= 7.0) || this.tr[k].out >= 1) continue;
                this.d100 += this.tr[k].fac * Math.PI * (this.tr[k].d * 0.005) * (this.tr[k].d * 0.005);
                jj += this.tr[k].fac;
            }
            this.d100 = 200.0 * Math.sqrt(this.d100 / (Math.PI * jj));
        }
        int missingheights = this.getMissingHeight(0);
        if (ndh > 4) {
            int j4;
            int k = ndh / 1000;
            ++k;
            ndh = 0;
            HeightCurve m = new HeightCurve();
            m.heightcurve();
            for (j4 = 0; j4 < this.ntrees; j4 += k) {
                if (!(this.tr[j4].d >= 7.0) || !(this.tr[j4].h > 1.3) || this.tr[j4].out >= 1) continue;
                ++ndh;
            }
            for (j4 = 0; j4 < this.ntrees; j4 += k) {
                if (!(this.tr[j4].d >= 7.0) || !(this.tr[j4].h > 1.3) || this.tr[j4].out >= 1) continue;
                m.adddh(this.sp[0].spDef.heightCurve, ndh, this.tr[j4].d, this.tr[j4].h);
            }
            m.start();
            if (this.dg > 0.0) {
                this.hg = m.hwert(this.sp[0].spDef.heightCurve, this.dg);
            }
            if (this.d100 > 0.0) {
                this.h100 = m.hwert(this.sp[0].spDef.heightCurve, this.d100);
            }
            double h_d = this.hg / this.dg;
            double h_d_100 = this.h100 / this.d100;
            if (h_d > 5.0 || h_d_100 > 5.0) {
                ndh = 1;
            } else if (missingheights > 0) {
                for (int j5 = startindex; j5 >= 0; --j5) {
                    if (!(this.tr[j5].h < 1.3)) continue;
                    this.tr[j5].h = m.hwert(this.sp[0].spDef.heightCurve, this.tr[j5].d);
                }
            }
        }
        double dk = 0.0;
        double hk = 0.0;
        if (ndh > 0 && ndh <= 4) {
            for (int j6 = startindex; j6 >= 0; --j6) {
                if (!(this.tr[j6].d >= 7.0) || !(this.tr[j6].h > 1.3) || this.tr[j6].out >= 1 || !(hk < this.tr[j6].h)) continue;
                dk = this.tr[j6].d;
                hk = this.tr[j6].h;
            }
            double dgmerk = this.sp[0].dg;
            double hgmerk = this.sp[0].hg;
            Tree tree = new Tree();
            tree.d = this.d100;
            tree.sp = this.sp[0];
            tree.sp.dg = dk;
            tree.sp.hg = hk;
            FunctionInterpreter fi = new FunctionInterpreter();
            this.h100 = fi.getValueForTree(tree, tree.sp.spDef.uniformHeightCurveXML);
            tree.d = this.dg;
            this.hg = fi.getValueForTree(tree, tree.sp.spDef.uniformHeightCurveXML);
            if (missingheights > 0) {
                for (int j7 = 0; j7 < this.ntrees; ++j7) {
                    if (!(this.tr[j7].h < 1.3)) continue;
                    tree.d = this.tr[j7].d;
                    this.tr[j7].h = fi.getValueForTree(tree, tree.sp.spDef.uniformHeightCurveXML);
                }
            }
            this.sp[0].dg = dgmerk;
            this.sp[0].hg = hgmerk;
        }
        for (j2 = 0; j2 < this.nspecies; ++j2) {
            if (!(this.sp[j2].h100 <= 0.0)) continue;
            this.sp[j2].updateSpecies(this);
        }
        if (ndh <= 0) {
            this.hg = 0.0;
            this.h100 = 0.0;
            if (this.ntrees != 0 && this.debug) {
                LOGGER.log(Level.WARNING, "missing heights @ stand {0}", this.standname);
            }
        }
        for (j2 = 0; j2 < this.ntrees; ++j2) {
            this.tr[j2].setMissingData();
        }
        if (this.ntrees > 0) {
            this.selectNeighborTrees();
        }
        this.scaleMan.updateCompetition(this);
        double sumBA = 0.0;
        double sumCSA = 0.0;
        for (i2 = 0; i2 < this.ntrees; ++i2) {
            if (!(this.tr[i2].d >= 7.0) || this.tr[i2].out >= 0) continue;
            double dS = this.tr[i2].d * 0.005 * this.tr[i2].d * 0.005;
            double cS = this.tr[i2].cw * 0.5 * (this.tr[i2].cw * 0.5);
            sumBA += this.tr[i2].fac * Math.PI * dS;
            sumCSA += this.tr[i2].fac * Math.PI * cS;
        }
        this.volumeOfDeadwood = 0.0;
        for (i2 = 0; i2 < this.nspecies; ++i2) {
            this.sp[i2].percBA = 0.0;
            this.sp[i2].percCSA = 0.0;
            this.volumeOfDeadwood += this.sp[i2].volumeOfDeadwood;
            for (int j8 = 0; j8 < this.ntrees; ++j8) {
                if (this.tr[j8].code != this.sp[i2].code || !(this.tr[j8].d >= 7.0) || this.tr[j8].out >= 0) continue;
                double dS = this.tr[j8].d * 0.005 * this.tr[j8].d * 0.005;
                double cS = this.tr[j8].cw * 0.5 * (this.tr[j8].cw * 0.5);
                this.sp[i2].percBA += this.tr[j8].fac * Math.PI * dS;
                this.sp[i2].percCSA += this.tr[j8].fac * Math.PI * cS;
            }
            this.sp[i2].percBA = sumBA > 0.0 && this.sp[i2].percBA > 0.0 ? 100.0 * this.sp[i2].percBA / sumBA : 0.0;
            this.sp[i2].percCSA = sumCSA > 0.0 && this.sp[i2].percCSA > 0.0 ? 100.0 * this.sp[i2].percCSA / sumCSA : 0.0;
        }
        double sumPercent = 0.0;
        for (i = 0; i < this.nspecies; ++i) {
            if (this.sp[i].trule.targetCrownPercent != 1000.0) continue;
            this.sp[i].trule.targetCrownPercent = this.sp[i].percCSA;
        }
        for (i = 0; i < this.nspecies; ++i) {
            sumPercent += this.sp[i].trule.targetCrownPercent;
        }
        for (i = 0; i < this.nspecies; ++i) {
            this.sp[i].trule.targetCrownPercent = sumPercent > 0.0 ? 100.0 * this.sp[i].trule.targetCrownPercent / sumPercent : 0.0;
        }
        for (i = 0; i < this.nspecies; ++i) {
            this.sp[i].vol = 0.0;
            this.sp[i].vhaout = 0.0;
            for (j = startindex; j >= 0; --j) {
                if (this.tr[j].code != this.sp[i].code || !(this.tr[j].d >= 7.0)) continue;
                if (this.tr[j].out < 1 || this.tr[j].out == this.year - 1) {
                    this.sp[i].vol += this.tr[j].fac * this.tr[j].v;
                }
                if (this.tr[j].out != this.year) continue;
                this.sp[i].vhaout += this.tr[j].fac * this.tr[j].v;
            }
            this.sp[i].vol /= this.size;
            this.sp[i].vhaout /= this.size;
        }
        for (int n = 0; n < this.nspecies; ++n) {
            if (this.sp[n].d100 <= 0.0) {
                this.sp[n].d100 = this.sp[n].dg;
            }
            if (this.sp[n].h100 <= 0.0) {
                this.sp[n].h100 = this.sp[n].hg;
            }
            if (!(this.sp[n].h100age <= 0.0)) continue;
            for (j = startindex; j >= 0; --j) {
                if (!(this.tr[j].d >= 7.0) || this.tr[j].code != this.sp[n].code) continue;
                this.sp[n].h100age = this.tr[j].age;
            }
        }
        if (this.nspecies > 0) {
            this.calculateDegreeOfStockingAndSpeciesPercentage();
        }
        if (this.bt < 10 && this.bha > 0.0) {
            this.bt = this.getBT();
        }
    }

    public void missingData() {
        int j;
        if (this.ncpnt <= 0) {
            double l = Math.sqrt(this.size * 10000.0);
            this.addcornerpoint("E1", 0.0, l, 0.0);
            this.addcornerpoint("E2", l, l, 0.0);
            this.addcornerpoint("E3", l, 0.0, 0.0);
            this.addcornerpoint("E4", 0.0, 0.0, 0.0);
            this.center.no = "polygon";
            this.center.x = l * 0.5;
            this.center.y = l * 0.5;
            this.center.z = 0.0;
        }
        if (!this.center.no.contains("polygon") && !this.center.no.contains("circle")) {
            double xm = 0.0;
            double ym = 0.0;
            double zm = 0.0;
            for (int i = 0; i < this.ncpnt; ++i) {
                xm += this.cpnt[i].x;
                ym += this.cpnt[i].y;
                zm += this.cpnt[i].z;
            }
            this.center.x = xm / (double)this.ncpnt;
            this.center.y = ym / (double)this.ncpnt;
            this.center.z = zm / (double)this.ncpnt;
            this.center.no = "polygon";
        }
        this.bha = 0.0;
        for (int i = 0; i < this.ntrees; ++i) {
            if (this.tr[i].out >= 1 || !(this.tr[i].d >= 7.0)) continue;
            this.bha += this.tr[i].fac * Math.PI * (this.tr[i].d * 0.005) * (this.tr[i].d * 0.005);
        }
        int missingHeight = this.getMissingHeight(0);
        if (missingHeight >= 0) {
            for (int i = 0; i < this.nspecies; ++i) {
                this.sp[i].updateSpecies(this);
            }
        }
        if ((missingHeight = this.getMissingHeight(0)) >= 0) {
            int k;
            double n100 = this.size * 100.0;
            if (n100 > 0.0) {
                double jj = 0.0;
                for (k = 0; jj < n100 && k < this.ntrees; ++k) {
                    if (this.tr[k].out >= 1 || !(this.tr[k].d >= 7.0)) continue;
                    this.d100 += this.tr[k].fac * Math.PI * (this.tr[k].d * 0.005) * (this.tr[k].d * 0.005);
                    jj += this.tr[k].fac;
                }
                this.d100 = 200.0 * Math.sqrt(this.d100 / (Math.PI * jj));
            }
            int ndh = 0;
            for (int j2 = 0; j2 < this.ntrees; ++j2) {
                if (!(this.tr[j2].h >= 1.3) || this.tr[j2].out >= 1) continue;
                ++ndh;
            }
            int missingheights = this.getMissingHeight(0);
            if (ndh > 5) {
                int j3;
                k = ndh / 1000;
                ++k;
                ndh = 0;
                for (j = 0; j < this.ntrees; j += k) {
                    if (!(this.tr[j].h > 1.3) || this.tr[j].out >= 1) continue;
                    ++ndh;
                }
                HeightCurve m = new HeightCurve();
                m.heightcurve();
                for (j3 = 0; j3 < this.ntrees; j3 += k) {
                    if (!(this.tr[j3].h > 1.3) || this.tr[j3].out >= 1) continue;
                    m.adddh(this.sp[0].spDef.heightCurve, ndh, this.tr[j3].d, this.tr[j3].h);
                }
                m.start();
                if (this.dg > 0.0) {
                    this.hg = m.hwert(this.sp[0].spDef.heightCurve, this.dg);
                }
                if (this.d100 > 0.0) {
                    this.h100 = m.hwert(this.sp[0].spDef.heightCurve, this.d100);
                }
                if (missingheights > 0) {
                    for (j3 = 0; j3 < this.ntrees; ++j3) {
                        if (!(this.tr[j3].h < 1.3)) continue;
                        this.tr[j3].h = m.hwert(this.sp[0].spDef.heightCurve, this.tr[j3].d);
                    }
                }
            }
            double dk = 0.0;
            double hk = 0.0;
            if (ndh > 0 && ndh <= 5) {
                for (int j4 = 0; j4 < this.ntrees; ++j4) {
                    if (!(this.tr[j4].h > 1.3) || this.tr[j4].out >= 1) continue;
                    dk = this.tr[j4].d;
                    hk = this.tr[j4].h;
                }
                double dgmerk = this.sp[0].dg;
                double hgmerk = this.sp[0].hg;
                Tree tree = new Tree();
                tree.d = this.d100;
                tree.sp = this.sp[0];
                tree.sp.dg = dk;
                tree.sp.hg = hk;
                FunctionInterpreter fi = new FunctionInterpreter();
                this.h100 = fi.getValueForTree(tree, tree.sp.spDef.uniformHeightCurveXML);
                tree.d = this.dg;
                this.hg = fi.getValueForTree(tree, tree.sp.spDef.uniformHeightCurveXML);
                if (missingheights > 0) {
                    for (int j5 = 0; j5 < this.ntrees; ++j5) {
                        if (!(this.tr[j5].h < 1.3)) continue;
                        tree.d = this.tr[j5].d;
                        this.tr[j5].h = fi.getValueForTree(tree, tree.sp.spDef.uniformHeightCurveXML);
                    }
                }
                this.sp[0].dg = dgmerk;
                this.sp[0].hg = hgmerk;
            }
        }
        for (int jj = 0; jj < this.nspecies; ++jj) {
            double avSiteIndex = 0.0;
            double nSiteIndex = 0.0;
            for (j = 0; j < this.ntrees; ++j) {
                if (this.tr[j].code != this.sp[jj].code || !(this.tr[j].si > 0.0) || !(this.tr[j].si < 110.0)) continue;
                avSiteIndex += this.tr[j].si * this.tr[j].fac;
                nSiteIndex += this.tr[j].fac;
            }
            if (!(nSiteIndex > 0.0)) continue;
            avSiteIndex /= nSiteIndex;
            for (j = 0; j < this.ntrees; ++j) {
                if (this.tr[j].code != this.sp[jj].code || !(this.tr[j].si < 0.0)) continue;
                this.tr[j].si = avSiteIndex;
            }
            this.sp[jj].hbon = avSiteIndex;
        }
        this.sortbyh();
        for (int j6 = 0; j6 < this.ntrees; ++j6) {
            this.tr[j6].setMissingData();
        }
        this.sortbyd();
        this.selectNeighborTrees();
        this.scaleMan.updateCompetition(this);
    }

    public Species addspecies(Tree t) throws SpeciesNotDefinedException {
        int merk = -9;
        if (this.ntrees == 0 && this.nRegeneration == 0) {
            this.nspecies = 0;
        }
        for (int i = 0; i < this.nspecies; ++i) {
            if (this.sp[i].code != t.code) continue;
            merk = i;
        }
        if (merk == -9) {
            this.sp[this.nspecies] = new Species();
            this.sp[this.nspecies].code = t.code;
            this.sp[this.nspecies].size = this.size;
            this.sp[this.nspecies].setZero();
            this.sp[this.nspecies].spDef = this.sdm.getByCode(t.code);
            if (this.sp[this.nspecies].spDef == null) {
                throw new SpeciesNotDefinedException(t, this.sdm);
            }
            this.sp[this.nspecies].h100 = 0.0;
            this.sp[this.nspecies].hg = 0.0;
            this.sp[this.nspecies].spDef.modelRegion = this.modelRegion;
            this.sp[this.nspecies].loadTrRuleDefault();
            merk = this.nspecies++;
        }
        return this.sp[merk];
    }

    public void setProgramDir(String dir) {
        this.programDir = dir;
    }

    public void setModelRegion(String s) {
        this.modelRegion = s;
    }

    public boolean getSpeciesDefinedTrue() {
        for (int i = 0; i < this.nspecies; ++i) {
            if (this.sp[i].spDef.defined) continue;
            return false;
        }
        return true;
    }

    public String getSpeciesUndefinedCode() {
        String str = "Species code:";
        for (int i = 0; i < this.nspecies; ++i) {
            if (this.sp[i].spDef.defined) continue;
            str = str + " " + this.sp[i].code;
        }
        return str;
    }

    public void notifyStandChanged(String action, Object sender) {
        if (this.StandChangeListeners.isEmpty()) {
            return;
        }
        StandChangeEvent sce = new StandChangeEvent(this, "StandChangeEvent", action, sender);
        ArrayList vtemp = (ArrayList)this.StandChangeListeners.clone();
        for (Object vtemp1 : vtemp) {
            StandChangeListener target = (StandChangeListener)vtemp1;
            target.StandChanged(sce);
        }
    }

    public void addStandChangeListener(StandChangeListener scl) {
        if (this.StandChangeListeners.contains(scl)) {
            return;
        }
        this.StandChangeListeners.add(scl);
    }

    public void removeAllStandChangeListeners() {
        this.StandChangeListeners.clear();
    }

    public void selectNeighborTrees() {
        double[] eA = null;
        if (this.ntrees > 0) {
            eA = new double[this.tr[0].maxNeighbor];
        }
        for (int i = 0; i < this.ntrees; ++i) {
            int k;
            if (this.tr[i].out >= 0 && this.tr[i].out != this.year) continue;
            for (k = 0; k < this.tr[i].maxNeighbor; ++k) {
                eA[k] = 9999.9;
                this.tr[i].neighbor[k] = -9;
            }
            for (int j = 0; j < this.ntrees; ++j) {
                int k2;
                if (this.tr[j].out >= 0 && this.tr[j].out != this.year || i == j) continue;
                double distXS = (this.tr[i].x - this.tr[j].x) * (this.tr[i].x - this.tr[j].x);
                double distYS = (this.tr[i].y - this.tr[j].y) * (this.tr[i].y - this.tr[j].y);
                double entf = Math.sqrt(distXS + distYS);
                double minimumRadius = 2.0 * this.tr[i].cw;
                if (minimumRadius < 2.0) {
                    minimumRadius = 2.0;
                }
                if (!(entf < minimumRadius) || !(this.tr[j].h > this.tr[i].cb)) continue;
                int merk = -9;
                for (k2 = 0; k2 < this.tr[i].maxNeighbor; ++k2) {
                    if (!(eA[k2] > entf) || merk >= 0) continue;
                    merk = k2;
                }
                if (merk <= -1) continue;
                for (k2 = this.tr[i].maxNeighbor - 2; k2 >= merk; --k2) {
                    this.tr[i].neighbor[k2 + 1] = this.tr[i].neighbor[k2];
                    eA[k2 + 1] = eA[k2];
                }
                this.tr[i].neighbor[merk] = j;
                eA[merk] = entf;
            }
            this.tr[i].nNeighbor = 0;
            for (k = 0; k < this.tr[i].maxNeighbor; ++k) {
                if (!(eA[k] < 9999.0)) continue;
                ++this.tr[i].nNeighbor;
            }
        }
    }

    public void calculateDegreeOfStockingAndSpeciesPercentage() {
        int i;
        this.degreeOfDensity = 0.0;
        for (i = 0; i < this.nspecies; ++i) {
            double gha_model;
            Tree atree;
            if (this.sp[i].h100 > 1.3) {
                atree = new Tree();
                atree.code = this.sp[i].code;
                atree.d = this.sp[i].d100;
                atree.h = this.sp[i].h100;
                atree.sp = this.sp[i];
                atree.no = "dummy tree for species " + this.sp[i].code;
                atree.st = this;
                atree.cw = atree.calculateCw();
                gha_model = atree.calculateMaxBasalArea() * atree.getModerateThinningFactor();
                if (gha_model <= 0.0) {
                    gha_model = 1.0;
                }
                this.sp[i].percBA = this.sp[i].gha / gha_model;
                this.degreeOfDensity += this.sp[i].percBA;
                continue;
            }
            atree = new Tree();
            atree.code = this.sp[i].code;
            atree.d = this.sp[i].dg;
            atree.h = this.sp[i].hg;
            atree.sp = this.sp[i];
            atree.no = "dummy tree for species " + this.sp[i].code;
            atree.st = this;
            atree.cw = atree.calculateCw();
            gha_model = atree.calculateMaxBasalArea() * atree.getModerateThinningFactor();
            if (gha_model <= 0.0) {
                gha_model = 1.0;
            }
            this.sp[i].percBA = this.sp[i].gha / gha_model;
            this.degreeOfDensity += this.sp[i].percBA;
        }
        if (this.degreeOfDensity > 0.0) {
            for (i = 0; i < this.nspecies; ++i) {
                this.sp[i].percBA = 100.0 * this.sp[i].percBA / this.degreeOfDensity;
            }
        }
    }

    public int cleanTreeArrayReg() {
        Collection trees = this.getDeadRegTrees();
        ArrayList<Tree> treelist = new ArrayList<Tree>();
        for (int i = 0; i < this.ntrees; ++i) {
            treelist.add(this.tr[i]);
        }
        if (treelist.removeAll(trees)) {
            this.ntrees -= trees.size();
            this.tr = treelist.toArray(new Tree[this.maxStandTrees]);
            this.descspecies();
        }
        return trees.size();
    }

    public boolean deleteTree(int index, boolean decspecies) {
        int oldN = this.ntrees;
        ArrayList<Tree> treelist = new ArrayList<Tree>();
        for (int i = 0; i < this.ntrees; ++i) {
            if (i == index) continue;
            treelist.add(this.tr[i]);
        }
        this.ntrees = treelist.size();
        this.tr = treelist.toArray(new Tree[this.maxStandTrees]);
        if (decspecies) {
            this.descspecies();
        }
        return oldN - this.ntrees == 1;
    }

    private Collection getDeadRegTrees() {
        ArrayList<Tree> treestoremove = new ArrayList<Tree>();
        for (int i = 0; i < this.ntrees; ++i) {
            if (!(this.tr[i].d < 7.0) || this.tr[i].out <= -1) continue;
            treestoremove.add(this.tr[i]);
        }
        return treestoremove;
    }

    public void setSiteIndex(int treeCode, double siteIndex) {
        for (int i = 0; i < this.ntrees; ++i) {
            if (!(this.tr[i].d >= 7.0) || this.tr[i].out >= 0 || this.tr[i].code != treeCode && treeCode != 0) continue;
            this.tr[i].si = siteIndex;
        }
    }

    public double getMeanCrownWidth(int treeCode) {
        double mean = 0.0;
        int n = 0;
        for (int i = 0; i < this.ntrees; ++i) {
            if (!(this.tr[i].d >= 7.0) || this.tr[i].out >= 0 || this.tr[i].code != treeCode && treeCode != 0) continue;
            mean += this.tr[i].cw;
            ++n;
        }
        if (n > 0) {
            mean /= (double)n;
        }
        return mean;
    }

    public double getMeanCrownBase(int treeCode) {
        double mean = 0.0;
        int n = 0;
        for (int i = 0; i < this.ntrees; ++i) {
            if (!(this.tr[i].d >= 7.0) || this.tr[i].out >= 0 || this.tr[i].code != treeCode && treeCode != 0) continue;
            mean += this.tr[i].cb;
            ++n;
        }
        if (n > 0) {
            mean /= (double)n;
        }
        return mean;
    }

    public int getBT() {
        double maxg = 0.0;
        int merk = 0;
        for (int i = 0; i < this.nspecies; ++i) {
            if (!(this.sp[i].percCSA > maxg)) continue;
            maxg = this.sp[i].percCSA;
            merk = this.sp[i].code;
        }
        Integer bt1 = merk;
        double maxg2 = 0.0;
        merk = 0;
        for (int i = 0; i < this.nspecies; ++i) {
            if (!(this.sp[i].percCSA > maxg2) || this.sp[i].code == bt1) continue;
            maxg2 = this.sp[i].percCSA;
            merk = this.sp[i].code;
        }
        Integer bt2 = merk;
        if (maxg > 75.0) {
            bt2 = 0;
        }
        String bts = bt1.toString().substring(0, 1) + bt2.toString().substring(0, 1);
        int bt0 = Integer.parseInt(bts);
        return bt0;
    }

    public void executeMortality() {
        if (this.ntrees > 0) {
            try {
                String modelPlugIn = "treegross.base.Mortality";
                PlugInMortality mo = (PlugInMortality)Class.forName(modelPlugIn).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                mo.mortalityByInfluenceZone(this);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOGGER.log(Level.SEVERE, "treegross", e);
            }
            for (int i = 0; i < this.ntrees; ++i) {
                if (this.tr[i].out >= 0) continue;
                this.tr[i].ageBasedMortality();
            }
        }
    }
}

