/*
 * Decompiled with CFR 0.152.
 */
package treegross.base;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import treegross.base.PlugInTaperFunction;

public class TaperFunction {
    private String pluginClass = "treegross.base.TaperFunctionBySchmidt";
    private PlugInTaperFunction tapInstance;
    private static final Logger LOGGER = Logger.getLogger(TaperFunction.class.getName());

    public TaperFunction(String pluginClass) {
        this.initInstance(pluginClass);
    }

    private void initInstance(String pluginClass) {
        this.pluginClass = pluginClass;
        String modelPlugIn = pluginClass;
        try {
            this.tapInstance = (PlugInTaperFunction)Class.forName(modelPlugIn).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            this.tapInstance = null;
            LOGGER.log(Level.SEVERE, "treegross", ex);
        }
    }

    public void setInstance(String pluginClass) {
        this.initInstance(pluginClass);
    }

    public PlugInTaperFunction getInstance() {
        return this.tapInstance;
    }

    public void loadParameter(int funNo) {
        if (this.tapInstance != null) {
            this.tapInstance.loadParameter(funNo);
        } else {
            LOGGER.log(Level.SEVERE, "Plugin {0} for TaperFunction not instancinated!", this.pluginClass);
        }
    }

    public double barkreduce(int funNo, double d) {
        double bark = 0.0;
        if (this.tapInstance != null) {
            bark = this.tapInstance.barkreduce(funNo, d);
        } else {
            LOGGER.log(Level.SEVERE, "Plugin {0} for TaperFunction not instancinated!", this.pluginClass);
        }
        return bark;
    }

    public double getDiameterEst(int funNo, double dbh, double height, double h, int barkindex, int sortindex) {
        double diameter = 0.0;
        if (this.tapInstance != null) {
            diameter = this.tapInstance.getDiameterEst(funNo, dbh, height, h, barkindex, sortindex);
        } else {
            LOGGER.log(Level.SEVERE, "Plugin {0} for TaperFunction not instancinated!", this.pluginClass);
        }
        return diameter;
    }

    public double getLengthEst(int funNo, double dbh, double height, double stemd) {
        double length = 0.0;
        if (this.tapInstance != null) {
            length = this.tapInstance.getLengthEst(funNo, dbh, height, stemd);
        } else {
            LOGGER.log(Level.SEVERE, "Plugin {0} for TaperFunction not instancinated!", this.pluginClass);
        }
        return length;
    }

    public double getCumVolume(int funNo, double dbh, double height, double h, int barkindex, int sortindex) {
        double cumVolume = 0.0;
        if (this.tapInstance != null) {
            cumVolume = this.tapInstance.getCumVolume(funNo, dbh, height, h, barkindex, sortindex);
        } else {
            LOGGER.log(Level.SEVERE, "Plugin {0} for TaperFunction not instancinated!", this.pluginClass);
        }
        return cumVolume;
    }

    public int getNumberOfFunctions() {
        int nFunNr = 0;
        if (this.tapInstance != null) {
            nFunNr = this.tapInstance.getNumberOfFunctions();
        } else {
            LOGGER.log(Level.SEVERE, "Plugin {0} for TaperFunction not instancinated!", this.pluginClass);
        }
        return nFunNr;
    }

    public String getFunctionName(int funNo) {
        String funName = "not found";
        if (this.tapInstance != null) {
            funName = this.tapInstance.getFunctionName(funNo);
        } else {
            LOGGER.log(Level.SEVERE, "Plugin {0} for TaperFunction not instancinated!", this.pluginClass);
        }
        return funName;
    }

    public int getFunctionNumber(int speciesCode) {
        int funNo = 0;
        if (this.tapInstance != null) {
            funNo = this.tapInstance.getFunctionNumber(speciesCode);
        } else {
            LOGGER.log(Level.SEVERE, "Plugin {0} for TaperFunction not instancinated!", this.pluginClass);
        }
        return funNo;
    }
}

