/*
 * Decompiled with CFR 0.152.
 */
package treegross.base;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import treegross.base.FunctionInterpreter;
import treegross.base.PlugInCompetition;
import treegross.base.Species;
import treegross.base.Stand;
import treegross.random.RandomNumber;

public class Tree
implements Cloneable {
    public static final double SW_THRESHOLD = 7.0;
    public long universalID = 0L;
    public int code;
    public String no;
    public int age;
    public int out;
    public int outtype;
    public double d;
    public double h;
    public double v;
    public double cb;
    public double cw;
    public double x;
    public double y;
    public double z;
    public boolean crop;
    public boolean tempcrop;
    public boolean habitat;
    public double c66;
    public double c66c;
    public double c66xy;
    public double c66cxy;
    public double fac;
    public double si;
    public Species sp;
    public Stand st;
    public int layer;
    public double bhdinc;
    public double hinc;
    public int year;
    public int origin;
    public String remarks;
    public double hMeasuredValue;
    public double proceeds;
    public double pwohc;
    public double sharelog;
    public double costs;
    public double shareXtimber;
    public int zGrad = 0;
    public double volumeDeadwood = 0.0;
    public double volumeDeadwoodConservation = 0.0;
    public double volumeHarvested = 0.0;
    public double degreeOfDecay = 0.0;
    public int maxNeighbor = 15;
    public int[] neighbor = new int[this.maxNeighbor];
    public int nNeighbor;
    public int group;
    public int ihpot;
    public double cbLightCrown = -9.0;
    public double cwLightCrown = -9.0;
    int yearOfRemovalinReality = 0;
    public int ou = 0;
    public int mortalityReason = 0;
    public double vitality = 1.0;
    public double quality = 1.0;
    public double randomSlope = 0.0;
    public double randomIntercept = 0.0;
    public boolean outBySkidtrail = false;
    public int bioMass = 0;
    private static final Logger LOGGER = Logger.getLogger(Tree.class.getName());

    public Tree() {
    }

    public Tree(int codex, String nox, int agex, int outx, int outtypex, double dx, double hx, double cbx, double cwx, double six, double facx, double xx, double yx, double zx, boolean cropTreex, boolean tempCropTreex, boolean habitatTreex, int treeLayerx, double volumeDeadwoodx, String remarksx) {
        this.code = codex;
        this.no = nox;
        this.out = outx;
        this.outtype = outtypex;
        this.d = dx;
        this.h = hx;
        this.age = agex;
        this.cb = cbx;
        this.cw = cwx;
        this.si = six;
        this.fac = facx;
        this.x = xx;
        this.y = yx;
        this.z = zx;
        this.habitat = habitatTreex;
        this.crop = cropTreex;
        this.tempcrop = tempCropTreex;
        this.layer = treeLayerx;
        this.volumeDeadwood = volumeDeadwoodx;
        this.remarks = remarksx;
        this.quality = 0.5;
        this.randomSlope = 0.0;
        this.randomIntercept = 0.0;
    }

    public Tree clone() {
        Tree clone = new Tree();
        clone.universalID = this.universalID;
        clone.age = this.age;
        clone.bhdinc = this.bhdinc;
        clone.c66 = this.c66;
        clone.c66c = this.c66c;
        clone.c66cxy = this.c66cxy;
        clone.c66xy = this.c66xy;
        clone.cb = this.cb;
        clone.cbLightCrown = this.cbLightCrown;
        clone.code = this.code;
        clone.costs = this.costs;
        clone.crop = this.crop;
        clone.cw = this.cw;
        clone.cwLightCrown = this.cwLightCrown;
        clone.d = this.d;
        clone.fac = this.fac;
        clone.h = this.h;
        clone.hMeasuredValue = this.hMeasuredValue;
        clone.habitat = this.habitat;
        clone.hinc = this.hinc;
        clone.layer = this.layer;
        clone.no = this.no;
        clone.origin = this.origin;
        clone.ou = this.ou;
        clone.out = this.out;
        clone.outtype = this.outtype;
        clone.proceeds = this.proceeds;
        clone.pwohc = this.pwohc;
        clone.remarks = this.remarks != null ? this.remarks : "";
        clone.shareXtimber = this.shareXtimber;
        clone.sharelog = this.sharelog;
        clone.si = this.si;
        clone.sp = this.sp.clone();
        clone.v = this.v;
        clone.x = this.x;
        clone.y = this.y;
        clone.year = this.year;
        clone.yearOfRemovalinReality = this.yearOfRemovalinReality;
        clone.z = this.z;
        clone.zGrad = this.zGrad;
        clone.volumeDeadwood = this.volumeDeadwood;
        clone.degreeOfDecay = this.degreeOfDecay;
        clone.quality = this.quality;
        clone.randomSlope = this.randomSlope;
        clone.randomIntercept = this.randomIntercept;
        clone.vitality = this.vitality;
        clone.outBySkidtrail = this.outBySkidtrail;
        clone.bioMass = this.bioMass;
        clone.group = this.group;
        return clone;
    }

    public double calculateCw() {
        double cwerg;
        if (this.sp.spDef.crownwidthXML.getFunctionText().length() > 2 && this.d >= 7.0) {
            FunctionInterpreter fi = new FunctionInterpreter();
            cwerg = fi.getValueForTree(this, this.sp.spDef.crownwidthXML);
        } else {
            cwerg = 0.01;
        }
        if (this.d < 7.0) {
            double dmerk = this.d;
            double hmerk = this.h;
            double cbmerk = this.cb;
            this.d = 7.0;
            this.h = 8.0;
            this.cb = 2.0;
            FunctionInterpreter fi = new FunctionInterpreter();
            cwerg = fi.getValueForTree(this, this.sp.spDef.crownwidthXML);
            this.d = dmerk;
            this.h = hmerk;
            this.cb = cbmerk;
            if (this.no == null) {
                this.no = "";
            }
        }
        if (cwerg > 50.0) {
            if (this.st != null && this.st.debug) {
                LOGGER.log(Level.SEVERE, "Calculate crown width ({0}/{1}/{2}): cw unrealistic {3} using old cw: {4}", new Object[]{this.st.standname, this.no, this.d, cwerg, this.cw});
            }
            cwerg = this.cw;
        }
        return cwerg;
    }

    public double calculateCwAtHeight(double hx) {
        double erg;
        if (this.d >= 7.0) {
            double cwAtHx = 0.0;
            double h66 = this.h - 2.0 * (this.h - this.cb) / 3.0;
            if (hx < this.h && hx > h66) {
                cwAtHx = Math.sqrt(1.5 * (this.cw * 0.5 * (this.cw * 0.5)) * (this.h - hx) / (this.h - this.cb));
            }
            if (hx <= h66 && hx > this.cb) {
                cwAtHx = this.cw * 0.5;
            }
            erg = 2.0 * cwAtHx;
        } else {
            double dCb;
            erg = hx <= this.h ? ((dCb = this.h - this.cb) != 0.0 ? (this.h - hx) * this.cw / (this.h - this.cb) : (this.h - hx) * this.cw) : 0.0;
        }
        return erg;
    }

    public double calculateCb() {
        double cberg = 0.0;
        if (this.sp.spDef.crownbaseXML.getFunctionText().length() > 4 && this.d >= 7.0) {
            FunctionInterpreter fi = new FunctionInterpreter();
            if (this.sp.h100 < 1.3 || Double.isNaN(this.sp.h100)) {
                this.sp.h100 = this.h;
            }
            cberg = fi.getValueForTree(this, this.sp.spDef.crownbaseXML);
        }
        if (this.d < 7.0) {
            cberg = this.h / 2.0;
        }
        if (cberg < 0.01) {
            cberg = 0.01;
        }
        if (Double.isNaN(cberg)) {
            boolean errout = false;
            if (this.st != null && this.st.debug) {
                errout = true;
            }
            if (errout) {
                LOGGER.log(Level.WARNING, "Calculated crown base is NaN for: {0}/{1}\n\t{2} dbh: {3} height: {4} sp.h100: {5}.", new Object[]{this.st.standname, this.no, this.sp.spDef.crownbaseXML, this.d, this.h, this.sp.h100});
            }
            cberg = this.h / 2.0;
        }
        return cberg;
    }

    public double calculateVolume() {
        double erg = 0.0;
        if (this.d > 3.0 && this.h > 3.0) {
            FunctionInterpreter fi = new FunctionInterpreter();
            erg = fi.getValueForTree(this, this.sp.spDef.volumeFunctionXML);
            if (erg < 0.0) {
                erg = 0.0;
            }
            if (Double.isNaN(erg)) {
                erg = 0.0;
            }
        }
        return erg;
    }

    public double calculateDecay() {
        FunctionInterpreter fi = new FunctionInterpreter();
        double erg = fi.getValueForTree(this, this.sp.spDef.decayXML);
        if (erg < 0.0) {
            erg = 0.0;
        }
        if (erg < 1.0) {
            this.volumeDeadwood = this.v * erg;
        }
        return erg;
    }

    public double calculateSiteIndex() {
        FunctionInterpreter fi = new FunctionInterpreter();
        double erg = fi.getValueForTree(this, this.sp.spDef.siteindexXML);
        return erg;
    }

    public double calculateMaxBasalArea() {
        FunctionInterpreter fi = new FunctionInterpreter();
        double erg = fi.getValueForTree(this, this.sp.spDef.maximumDensityXML);
        return erg;
    }

    public void ageBasedMortality() {
        double ageindex = 1.0 * (double)this.age / (1.0 * (double)this.sp.spDef.maximumAge) - 1.0;
        if (ageindex > this.st.random.nextUniform()) {
            this.out = this.st.year;
            this.outtype = 1;
        }
    }

    public double getModerateThinningFactor() {
        double tfac = 1.0;
        if (this.sp.spDef.moderateThinning.length() > 4) {
            String zeile = this.sp.spDef.moderateThinning;
            if (zeile.contains(";")) {
                String[] tokens = zeile.split(";");
                int end = tokens.length / 3;
                for (int i = 0; i < end; ++i) {
                    double hu = Double.parseDouble(tokens[i * 3]);
                    double f = Double.parseDouble(tokens[i * 3 + 1]);
                    double ho = Double.parseDouble(tokens[i * 3 + 2]);
                    if (!(this.h >= hu) || !(this.h < ho)) continue;
                    tfac = f;
                    break;
                }
            } else {
                FunctionInterpreter fi = new FunctionInterpreter();
                double basalarea = fi.getValueForTree(this, this.sp.spDef.moderateThinning);
                tfac = basalarea / this.calculateMaxBasalArea();
            }
        }
        return tfac;
    }

    public void setMissingData() {
        if (this.si <= -9.0 && this.sp.hbon <= 0.0) {
            if (this.sp.h100 <= 1.3 || Double.isNaN(this.sp.h100)) {
                this.sp.h100 = this.st.h100;
            }
            this.si = this.calculateSiteIndex();
        }
        if (this.si <= -9.0) {
            this.si = this.sp.hbon;
        }
        if (this.cb < 0.01) {
            this.cb = this.calculateCb();
        }
        if (this.cw < 0.01) {
            this.cw = this.calculateCw();
        }
        if (this.v <= 0.0) {
            this.v = this.calculateVolume();
        }
    }

    void grow(int years, RandomNumber rn) {
        FunctionInterpreter fi = new FunctionInterpreter();
        if (this.d < 7.0) {
            double dneu;
            double jh1;
            double c66m = 2.0;
            Tree atree = new Tree();
            atree.sp = this.sp;
            atree.code = this.sp.code;
            atree.si = this.si;
            atree.age = 30;
            atree.no = this.no + " @ " + this.st.standname;
            double jh2 = jh1 = fi.getValueForTree(atree, this.sp.spDef.siteindexHeightXML);
            this.hinc = (jh2 *= (Math.exp((double)(this.age + 5) / 30.0) - 1.0) / (Math.exp(1.0) - 1.0)) - (jh1 *= (Math.exp((double)this.age / 30.0) - 1.0) / (Math.exp(1.0) - 1.0));
            if (this.hinc < 0.0) {
                this.hinc = 0.0;
            }
            this.bhdinc = 0.0;
            double hd = 1.0;
            if (this.sp.code < 200) {
                hd = 1.28;
                c66m = 1.2;
            } else if (this.sp.code >= 200 && this.sp.code < 300) {
                hd = 1.4;
                c66m = 2.2;
            } else if (this.sp.code >= 300 && this.sp.code < 400) {
                hd = 1.8;
                c66m = 1.5;
            } else if (this.sp.code >= 400 && this.sp.code < 500) {
                hd = 1.2;
                c66m = 1.2;
            } else if (this.sp.code >= 500 && this.sp.code < 600) {
                hd = 0.95;
                c66m = 1.8;
            } else if (this.sp.code >= 600 && this.sp.code < 700) {
                hd = 0.7;
                c66m = 1.9;
            } else if (this.sp.code >= 700 && this.sp.code < 800) {
                hd = 1.1;
                c66m = 1.2;
            } else if (this.sp.code >= 800 && this.sp.code < 900) {
                hd = 0.95;
                c66m = 1.0;
            }
            double hmod = this.c66xy / c66m;
            if (hmod > 1.0) {
                hmod = 0.999;
            }
            if (hmod < 0.0) {
                hmod = 0.0;
            }
            hmod = 1.0 - hmod * hmod;
            if (rn.randomOn) {
                this.hinc = 0.9 * this.hinc + 0.2 * this.hinc * rn.nextNormal(1.0);
            }
            if ((dneu = (this.h + (double)years * hmod * (0.2 * this.hinc)) / hd) > this.d) {
                this.d = dneu;
            }
        } else {
            double effect;
            boolean errout;
            this.bhdinc = fi.getValueForTree(this, this.sp.spDef.diameterIncrementXML);
            boolean bl = errout = this.st != null ? this.st.debug : false;
            if (Double.isInfinite(this.bhdinc) || Double.isNaN(this.bhdinc) || this.bhdinc < 0.0) {
                if (errout) {
                    LOGGER.log(Level.WARNING, "dbh increment is < 0, NaN or infinite for: {0}/{1}\n\tbhdinc: {2}\n\tc66cxy: {3} c66xy: {4}crown width {5}\n\tcrown base {6} species: {7} h100 for species: {8}", new Object[]{this.st.standname, this.no, this.bhdinc, this.c66cxy, this.c66xy, this.cw, this.cb, this.code, this.sp.h100});
                }
                this.bhdinc = 0.0;
            }
            if (rn.randomOn) {
                if (this.bhdinc <= 0.0) {
                    this.bhdinc = 1.0E-6;
                }
                double e1 = 0.0;
                double e2 = 0.0;
                double e3 = 0.0;
                if (this.sp.spDef.diameterTreeErrorXML != null && this.sp.spDef.diameterTreeErrorXML.isEmpty()) {
                    try {
                        String[] tec = this.sp.spDef.diameterTreeErrorXML.split(";");
                        if (tec.length >= 4) {
                            e1 = this.randomIntercept;
                            e2 = this.randomSlope * fi.getValueForTree(this, tec[2]);
                            e3 = rn.nextNormal() * fi.getValueForTree(this, tec[3]);
                        }
                    }
                    catch (NumberFormatException e) {
                        LOGGER.log(Level.SEVERE, "Diameter Tree Error f\u00fcr Art {0} fehlerhaft !!!", this.code);
                    }
                }
                if (e1 == 0.0 && e2 == 0.0 && e3 == 0.0) {
                    effect = this.sp.spDef.diameterIncrementError * rn.nextNormal(1.0);
                    this.bhdinc = Math.exp(Math.log(this.bhdinc) + effect);
                } else {
                    double bhdinc0 = this.bhdinc;
                    this.bhdinc = Math.exp(Math.log(this.bhdinc * 10000.0) + e1 + e2) / 10000.0;
                    this.bhdinc = (this.bhdinc * 10000.0 + e3) / 10000.0;
                    if (this.st.debug) {
                        LOGGER.log(Level.INFO, "{0} ig {1} {2} {3} {4}  {5}", new Object[]{this.no, bhdinc0, e1, e2, e3, this.bhdinc});
                    }
                }
            }
            if (this.bhdinc < 0.0) {
                this.bhdinc = 0.0;
            }
            this.bhdinc = 2.0 * Math.sqrt((Math.PI * (this.d * 0.5 * (this.d * 0.5)) + this.bhdinc * 10000.0) / Math.PI) - this.d;
            if (this.bhdinc < 0.0) {
                this.bhdinc = 0.0;
            }
            double ihpot_l = fi.getValueForTree(this, this.sp.spDef.potentialHeightIncrementXML);
            this.hinc = fi.getValueForTree(this, this.sp.spDef.heightIncrementXML);
            if (rn.randomOn) {
                effect = this.sp.spDef.heightIncrementError;
                this.hinc += effect * rn.nextNormal(1.0);
            }
            if (this.hinc > ihpot_l * 1.2) {
                this.hinc = ihpot_l * 1.2;
            }
        }
        if (this.hinc < 0.0) {
            this.hinc = 0.0;
        }
        double ts = 0.2;
        if (this.st.timeStep > 0) {
            ts = 1.0 / (double)this.st.timeStep;
        }
        this.h += (double)years * this.hinc * ts;
        this.d += (double)years * this.bhdinc * ts;
        this.age += years;
        this.v = this.calculateVolume();
    }

    void growBack(int years) {
        double ts = this.st.timeStep;
        if (this.out == this.st.year) {
            this.out = -1;
            this.outtype = 0;
        }
        RandomNumber rnOff = new RandomNumber(10);
        if (this.out < 0) {
            double newD;
            Tree xtree = this.clone();
            xtree.st = this.st;
            xtree.grow(years, rnOff);
            double dzvor = xtree.bhdinc;
            double hzvor = xtree.hinc;
            xtree = this.clone();
            xtree.st = this.st;
            xtree.h -= (double)years * hzvor / ts;
            xtree.d -= (double)years * dzvor / ts;
            xtree.age -= years;
            FunctionInterpreter fi = new FunctionInterpreter();
            xtree.sp.h100 -= fi.getValueForTree(xtree, this.sp.spDef.potentialHeightIncrementXML);
            if (xtree.h < 1.3) {
                this.h = 4.0;
            }
            if (xtree.d < 1.0) {
                this.d = 1.0;
            }
            xtree.cw = xtree.calculateCw();
            xtree.cb = xtree.calculateCb();
            xtree.grow(years, rnOff);
            double newH = this.h - (double)years * xtree.hinc / ts;
            if (newH < this.h) {
                this.h = newH;
            }
            if ((newD = this.d - (double)years * xtree.bhdinc / ts) < this.d) {
                this.d = newD;
            }
            if (this.d < 7.0 || this.h < 5.0) {
                this.d = 3.0;
                this.h = 4.0;
                this.cw = 2.0;
                this.cb = 2.0;
            }
            if (this.cb >= this.h) {
                this.cb = this.h - 0.2;
            }
            this.age -= years;
            this.v = this.calculateVolume();
        }
    }

    public void updateCrown() {
        if (this.d >= 7.0) {
            double cbnew = this.calculateCb();
            if (cbnew > this.cb) {
                this.cb = cbnew;
            }
            this.cw = this.calculateCw();
        } else {
            this.cb = this.h / 2.0;
            this.cw = this.calculateCw();
        }
    }

    public void updateCompetition() {
        if (this.fac > 0.0 && this.out < 1) {
            if (this.sp.spDef.competitionXML.length() > 1) {
                try {
                    String modelPlugIn = this.sp.spDef.competitionXML;
                    PlugInCompetition comp = (PlugInCompetition)Class.forName(modelPlugIn).getConstructor(new Class[0]).newInstance(new Object[0]);
                    comp.replaceC66AndC66c(this);
                    comp.replaceC66xyAndC66cxy(this, this.cw);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    LOGGER.log(Level.SEVERE, "ERROR in Class tree updateCompetition!", e);
                }
            } else {
                LOGGER.log(Level.SEVERE, "ERROR in Class tree updateCompetition! No COmpetition plugin specified for {0}", this.code);
            }
        } else {
            this.c66 = -99.0;
            this.c66c = -99.0;
            this.c66xy = -99.0;
            this.c66cxy = -99.0;
        }
    }

    public void setGroup(int group) {
        this.group = group;
    }
}

