/*
 * Decompiled with CFR 0.152.
 */
package treegross.base;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;
import treegross.base.SpeciesNotDefinedException;
import treegross.base.Stand;
import treegross.base.Tree;
import treegross.tools.XmlTool;

public class TreegrossXML2 {
    private static final Logger LOGGER = Logger.getLogger(TreegrossXML2.class.getName());
    private boolean error;

    public boolean getError() {
        return this.error;
    }

    private Document makeXmlDocument(Stand st) {
        NumberFormat f = NumberFormat.getInstance(new Locale("en", "US"));
        f.setMaximumFractionDigits(2);
        f.setMinimumFractionDigits(2);
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            Element elt;
            int i;
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            ProcessingInstruction pi = doc.createProcessingInstruction("xml-stylesheet", "type=\"text/xsl\" href=\"treegross.xsl\"");
            doc.appendChild(pi);
            Element rootElt = doc.createElement("Bestand");
            doc.appendChild(rootElt);
            if (st.nspecies > 0) {
                XmlTool.addChildString(rootElt, "Id", st.id);
                XmlTool.addChildString(rootElt, "Kennung", st.standname);
                XmlTool.addChildString(rootElt, "Allgemeines", " ");
                XmlTool.addChildString(rootElt, "Flaechengroesse_m2", Double.toString(st.size * 10000.0));
                XmlTool.addChildString(rootElt, "HauptbaumArtCodeStd", Integer.toString(st.sp[0].code));
                XmlTool.addChildString(rootElt, "HauptbaumArtCodeLokal", Integer.toString(st.sp[0].code));
                XmlTool.addChildString(rootElt, "AufnahmeJahr", Integer.toString(st.year));
                XmlTool.addChildString(rootElt, "AufnahmeMonat", Integer.toString(st.monat));
                XmlTool.addChildString(rootElt, "DatenHerkunft", st.datenHerkunft);
                XmlTool.addChildString(rootElt, "Standort", st.standort);
                XmlTool.addChildString(rootElt, "Hochwert_m", Double.toString(st.hochwert_m));
                XmlTool.addChildString(rootElt, "Rechtswert_m", Double.toString(st.rechtswert_m));
                XmlTool.addChildString(rootElt, "Hoehe_uNN_m", Double.toString(st.hoehe_uNN_m));
                XmlTool.addChildString(rootElt, "Exposition_Gon", Integer.toString(st.exposition_Gon));
                XmlTool.addChildString(rootElt, "Hangneigung_Prozent", Double.toString(st.hangneigungProzent));
                XmlTool.addChildString(rootElt, "Wuchsgebiet", st.wuchsgebiet);
                XmlTool.addChildString(rootElt, "Wuchsbezirk", st.wuchsbezirk);
                XmlTool.addChildString(rootElt, "Standortskennziffer", st.standortsKennziffer);
                XmlTool.addChildString(rootElt, "Status", Integer.toString(st.status));
                XmlTool.addChildString(rootElt, "Bemerkungen", st.bemerkungen);
            }
            for (i = 0; i < st.nspecies; ++i) {
                elt = doc.createElement("Baumartencode");
                XmlTool.addChildString(elt, "Code", Integer.toString(st.sp[i].code));
                XmlTool.addChildString(elt, "deutscherName", st.sp[i].spDef.longName);
                XmlTool.addChildString(elt, "lateinischerName", st.sp[i].spDef.latinName);
                rootElt.appendChild(elt);
            }
            if (st.ncpnt > 0) {
                Element elt2 = doc.createElement("Eckpunkt");
                XmlTool.addChildString(elt2, "Nr", st.center.no == null ? "n.d." : st.center.no);
                XmlTool.addChildString(elt2, "RelativeXKoordinate_m", f.format(st.center.x));
                XmlTool.addChildString(elt2, "RelativeYKoordinate_m", f.format(st.center.y));
                XmlTool.addChildString(elt2, "RelativeBodenhoehe_m", f.format(st.center.z));
                rootElt.appendChild(elt2);
            }
            for (i = 0; i < st.ncpnt; ++i) {
                elt = doc.createElement("Eckpunkt");
                XmlTool.addChildString(elt, "Nr", st.cpnt[i].no);
                XmlTool.addChildString(elt, "RelativeXKoordinate_m", f.format(st.cpnt[i].x));
                XmlTool.addChildString(elt, "RelativeYKoordinate_m", f.format(st.cpnt[i].y));
                XmlTool.addChildString(elt, "RelativeBodenhoehe_m", f.format(st.cpnt[i].z));
                rootElt.appendChild(elt);
            }
            for (int i2 = 0; i2 < st.ntrees; ++i2) {
                String grund;
                Element elt3 = doc.createElement("Baum");
                XmlTool.addChildString(elt3, "Nr", Integer.toString(i2 + 1));
                XmlTool.addChildString(elt3, "Kennung", st.tr[i2].no);
                XmlTool.addChildString(elt3, "BaumartcodeStd", "0");
                XmlTool.addChildString(elt3, "BaumartcodeLokal", Integer.toString(st.tr[i2].code));
                XmlTool.addChildString(elt3, "Alter_Jahr", Integer.toString(st.tr[i2].age));
                XmlTool.addChildString(elt3, "BHD_mR_cm", f.format(st.tr[i2].d));
                XmlTool.addChildString(elt3, "Hoehe_m", f.format(st.tr[i2].h));
                XmlTool.addChildString(elt3, "Kronenansatz_m", f.format(st.tr[i2].cb));
                XmlTool.addChildString(elt3, "MittlererKronenDurchmesser_m", f.format(st.tr[i2].cw));
                XmlTool.addChildString(elt3, "SiteIndex_m", f.format(st.tr[i2].si));
                XmlTool.addChildString(elt3, "RelativeXKoordinate_m", f.format(st.tr[i2].x));
                XmlTool.addChildString(elt3, "RelativeYKoordinate_m", f.format(st.tr[i2].y));
                XmlTool.addChildString(elt3, "RelativeBodenhoehe_m", f.format(st.tr[i2].z));
                boolean lebend = st.tr[i2].out == -1;
                XmlTool.addChildString(elt3, "Lebend", Boolean.toString(lebend));
                boolean entnommen = st.tr[i2].outtype >= 2;
                XmlTool.addChildString(elt3, "Entnommen", Boolean.toString(entnommen));
                XmlTool.addChildString(elt3, "AusscheideMonat", "3");
                XmlTool.addChildString(elt3, "AusscheideJahr", Integer.toString(st.tr[i2].out));
                switch (st.tr[i2].outtype) {
                    case 1: {
                        grund = "Mortalit\u00e4t";
                        break;
                    }
                    case 2: {
                        grund = "Durchforstung";
                        break;
                    }
                    case 3: {
                        grund = "Ernte";
                        break;
                    }
                    default: {
                        grund = "anderer";
                    }
                }
                XmlTool.addChildString(elt3, "AusscheideGrund", grund);
                XmlTool.addChildString(elt3, "ZBaum", Boolean.toString(st.tr[i2].crop));
                XmlTool.addChildString(elt3, "ZBaumtemporaer", Boolean.toString(st.tr[i2].tempcrop));
                XmlTool.addChildString(elt3, "HabitatBaum", Boolean.toString(st.tr[i2].habitat));
                XmlTool.addChildString(elt3, "KraftscheKlasse", "0");
                XmlTool.addChildString(elt3, "Schicht", Integer.toString(st.tr[i2].layer));
                f.setMaximumFractionDigits(4);
                f.setMinimumFractionDigits(4);
                XmlTool.addChildString(elt3, "Flaechenfaktor", f.format(st.tr[i2].fac));
                XmlTool.addChildString(elt3, "Volumen_cbm", f.format(st.tr[i2].v));
                XmlTool.addChildString(elt3, "VolumenTotholz_cbm", f.format(st.tr[i2].volumeDeadwood));
                XmlTool.addChildString(elt3, "Bemerkung", st.tr[i2].remarks);
                XmlTool.addChildString(elt3, "C66c", f.format(st.tr[i2].c66c));
                XmlTool.addChildString(elt3, "C66cxy", f.format(st.tr[i2].c66cxy));
                XmlTool.addChildString(elt3, "hinc", f.format(st.tr[i2].hinc));
                f.setMaximumFractionDigits(2);
                f.setMinimumFractionDigits(2);
                rootElt.appendChild(elt3);
            }
            return doc;
        }
        catch (ParserConfigurationException ex) {
            LOGGER.log(Level.SEVERE, "treegross", ex);
            return null;
        }
    }

    public String getXmlAsString(Stand st) {
        Document doc = this.makeXmlDocument(st);
        if (doc != null) {
            try {
                DOMSource domSource = new DOMSource(doc);
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(writer);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.transform(domSource, result);
                return writer.toString();
            }
            catch (TransformerException ex) {
                LOGGER.log(Level.SEVERE, "treegross", ex);
            }
        }
        return null;
    }

    public void saveAsXML(Stand st, String fileName) {
        Document doc = this.makeXmlDocument(st);
        if (doc != null) {
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(new File(fileName));
                transformer.transform(source, result);
            }
            catch (TransformerException ex) {
                LOGGER.log(Level.SEVERE, "treegross", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stand readTreegrossStand(Stand stl, URL url) {
        InputStream is = null;
        try {
            URLConnection urlcon = url.openConnection();
            is = urlcon.getInputStream();
            Stand stand = this.readTreegrossStandFromStream(stl, is);
            return stand;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "treegross", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, "treegross", ex);
                }
            }
        }
        return null;
    }

    public Stand readTreegrossStandFromStream(Stand stl, InputStream iss) {
        return this.readTreegrossStandFromStream(stl, iss, true);
    }

    public Stand readTreegrossStandFromStream(Stand stl, InputStream iss, boolean log) {
        Stand st;
        block21: {
            this.error = true;
            st = stl != null ? stl : new Stand();
            try {
                Node n;
                Document d = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(iss);
                Element standElt = d.getDocumentElement();
                st.id = XmlTool.getChildText(standElt, "Id");
                st.addName(XmlTool.getChildText(standElt, "Kennung"));
                st.addsize(Double.parseDouble(XmlTool.getChildText(standElt, "Flaechengroesse_m2")) / 10000.0);
                st.monat = Integer.parseInt(XmlTool.getChildText(standElt, "AufnahmeMonat"));
                st.year = Integer.parseInt(XmlTool.getChildText(standElt, "AufnahmeJahr"));
                st.datenHerkunft = XmlTool.getChildText(standElt, "DatenHerkunft");
                st.standort = XmlTool.getChildText(standElt, "Standort");
                st.rechtswert_m = Double.parseDouble(XmlTool.getChildText(standElt, "Rechtswert_m", "-9"));
                st.hochwert_m = Double.parseDouble(XmlTool.getChildText(standElt, "Hochwert_m", "-9"));
                st.hoehe_uNN_m = Double.parseDouble(XmlTool.getChildText(standElt, "Hoehe_uNN_m", "-9"));
                st.exposition_Gon = Integer.parseInt(XmlTool.getChildText(standElt, "Exposition_Gon", "-9"));
                st.hangneigungProzent = Double.parseDouble(XmlTool.getChildText(standElt, "Hangneigung_Prozent", "0"));
                st.wuchsgebiet = XmlTool.getChildText(standElt, "Wuchsgebiet");
                st.wuchsbezirk = XmlTool.getChildText(standElt, "Wuchsbezirk");
                st.standortsKennziffer = XmlTool.getChildText(standElt, "Standortskennziffer");
                st.status = Integer.parseInt(XmlTool.getChildText(standElt, "Status", "0"));
                st.bemerkungen = XmlTool.getChildText(standElt, "Bemerkungen");
                st.ncpnt = 0;
                st.ntrees = 0;
                st.nspecies = 0;
                st.center.no = "undefined";
                NodeList cornerpoints = standElt.getElementsByTagName("Eckpunkt");
                if (cornerpoints != null && cornerpoints.getLength() > 0) {
                    for (int i = 0; i < cornerpoints.getLength(); ++i) {
                        n = cornerpoints.item(i);
                        String nrx = XmlTool.getChildText(n, "Nr");
                        if (nrx.contains("circle") || nrx.contains("polygon")) {
                            st.center.no = nrx;
                            st.center.x = Double.parseDouble(XmlTool.getChildText(n, "RelativeXKoordinate_m"));
                            st.center.y = Double.parseDouble(XmlTool.getChildText(n, "RelativeYKoordinate_m"));
                            st.center.z = Double.parseDouble(XmlTool.getChildText(n, "RelativeBodenhoehe_m"));
                            continue;
                        }
                        st.addcornerpoint(XmlTool.getChildText(n, "Nr"), Double.parseDouble(XmlTool.getChildText(n, "RelativeXKoordinate_m")), Double.parseDouble(XmlTool.getChildText(n, "RelativeYKoordinate_m")), Double.parseDouble(XmlTool.getChildText(n, "RelativeBodenhoehe_m")));
                    }
                } else {
                    double length = Math.sqrt(st.size * 10000.0);
                    if (log) {
                        LOGGER.log(Level.WARNING, "No corner points stored in xml. Adding square coordinates (length={0})", length);
                    }
                    st.addcornerpoint("polygon_1", 0.0, 0.0, 0.0);
                    st.addcornerpoint("polygon_2", 0.0, length, 0.0);
                    st.addcornerpoint("polygon_3", length, length, 0.0);
                    st.addcornerpoint("polygon_4", length, 0.0, 0.0);
                }
                NodeList trees = standElt.getElementsByTagName("Baum");
                for (int i = 0; i < trees.getLength(); ++i) {
                    n = trees.item(i);
                    int out = Integer.parseInt(XmlTool.getChildText(n, "AusscheideJahr"));
                    int outtype = 0;
                    String ausGrund = XmlTool.getChildText(n, "AusscheideGrund");
                    if (ausGrund.contains("Mort")) {
                        outtype = 1;
                    } else if (ausGrund.contains("Durch")) {
                        outtype = 2;
                    } else if (ausGrund.contains("Ernte")) {
                        outtype = 3;
                    }
                    try {
                        st.addXMLTree(Integer.parseInt(XmlTool.getChildText(n, "BaumartcodeLokal")), XmlTool.getChildText(n, "Kennung"), Integer.parseInt(XmlTool.getChildText(n, "Alter_Jahr")), out, outtype, Double.parseDouble(XmlTool.getChildText(n, "BHD_mR_cm")), Double.parseDouble(XmlTool.getChildText(n, "Hoehe_m")), Double.parseDouble(XmlTool.getChildText(n, "Kronenansatz_m")), Double.parseDouble(XmlTool.getChildText(n, "MittlererKronenDurchmesser_m")), Double.parseDouble(XmlTool.getChildText(n, "SiteIndex_m")), Double.parseDouble(XmlTool.getChildText(n, "Flaechenfaktor")), Double.parseDouble(XmlTool.getChildText(n, "RelativeXKoordinate_m")), Double.parseDouble(XmlTool.getChildText(n, "RelativeYKoordinate_m")), Double.parseDouble(XmlTool.getChildText(n, "RelativeBodenhoehe_m")), Boolean.parseBoolean(XmlTool.getChildText(n, "ZBaum")), Boolean.parseBoolean(XmlTool.getChildText(n, "ZBaumtemporaer")), Boolean.parseBoolean(XmlTool.getChildText(n, "HabitatBaum")), Integer.parseInt(XmlTool.getChildText(n, "Schicht")), Double.parseDouble(XmlTool.getChildText(n, "VolumenTotholz_cbm")), XmlTool.getChildText(n, "Bemerkung"));
                        Tree addedTree = st.tr[st.ntrees - 1];
                        try {
                            Double c66c = Double.parseDouble(XmlTool.getChildText(n, "C66c", "0"));
                            addedTree.c66c = c66c;
                        }
                        catch (NumberFormatException ne) {
                            LOGGER.log(Level.WARNING, "treegross", "ERROR while parseing numeric tree data for tree: " + XmlTool.getChildText(n, "Kennung") + " node: C66c");
                        }
                        try {
                            Double c66cxy = Double.parseDouble(XmlTool.getChildText(n, "C66cxy", "0"));
                            addedTree.c66cxy = c66cxy;
                        }
                        catch (NumberFormatException ne) {
                            LOGGER.log(Level.WARNING, "treegross", "ERROR while parseing numeric tree data for tree: " + XmlTool.getChildText(n, "Kennung") + " node: C66cxy");
                        }
                        try {
                            Double hinc = Double.parseDouble(XmlTool.getChildText(n, "hinc", "0"));
                            addedTree.hinc = hinc;
                        }
                        catch (NumberFormatException ne) {
                            LOGGER.log(Level.WARNING, "treegross", "ERROR while parseing numeric tree data for tree: " + XmlTool.getChildText(n, "Kennung") + " node: hinc");
                        }
                        continue;
                    }
                    catch (NumberFormatException ne) {
                        if (!log) continue;
                        LOGGER.log(Level.SEVERE, "treegross", "ERROR while parseing numeric tree data for tree: " + XmlTool.getChildText(n, "Kennung"));
                        this.error = true;
                    }
                }
                this.error = false;
            }
            catch (IOException | ParserConfigurationException | SAXException | SpeciesNotDefinedException ex) {
                if (!log) break block21;
                LOGGER.log(Level.SEVERE, "treegross", ex);
                this.error = true;
            }
        }
        return st;
    }
}

