/*
 * Decompiled with CFR 0.152.
 */
package treegross.functions;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import treegross.functions.PlugInFunctionClass;
import treegross.functions.TGFunction;

public class TGClassFunction
implements TGFunction {
    private PlugInFunctionClass fc;
    private String function;
    private static final Logger LOGGER = Logger.getLogger(TGClassFunction.class.getName());

    @Override
    public void init(String xmlText) {
        this.function = xmlText;
        int m = this.function.indexOf("CLASS:");
        if (m > -1) {
            this.function = this.function.substring(m + 6);
        }
        String modelPlugIn = "treegross.plugin." + this.function;
        try {
            this.fc = (PlugInFunctionClass)Class.forName(modelPlugIn).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.log(Level.SEVERE, "treegross, function class loading: ", e);
        }
    }

    @Override
    public int getType() {
        return 1;
    }

    public PlugInFunctionClass getFunctionClass() {
        return this.fc;
    }

    @Override
    public String getFunctionText() {
        return this.function;
    }

    @Override
    public TGFunction clone() {
        TGClassFunction clone = new TGClassFunction();
        clone.init(this.function);
        return clone;
    }

    @Override
    public String toString() {
        return "CLASS:" + this.function;
    }
}

