/*
 * Decompiled with CFR 0.152.
 */
package treegross.plugin;

import treegross.base.Species;
import treegross.base.Tree;
import treegross.functions.PlugInFunctionClass;
import treegross.random.RandomNumber;

public class ElSaltoTreeDBHIncrement
implements PlugInFunctionClass {
    double dz1 = 0.0;
    double dz2 = 0.0;
    double dse = 0.0;
    double dz0 = 0.0;
    double dz3 = 0.0;
    double dz5 = 0.0;
    double dz4 = 0.0;
    String rtyp = " ";
    String info = "unknown";
    int numberOfFunctions = 7;
    int funNo = 1;

    @Override
    public String getName(int funNo) {
        this.initFunction(funNo);
        return this.info;
    }

    @Override
    public double getValueForTree(Tree t, String fun) {
        this.funNo = t.sp.spDef.code;
        this.initFunction(this.funNo);
        RandomNumber rn = new RandomNumber(12);
        double kr = t.cw / 2.0;
        double kl = t.h - t.cb;
        double cr = kl / t.cb;
        if (kl < 0.05) {
            kl = 0.05;
        }
        double km = Math.PI * kr / (6.0 * kl * kl) * (Math.pow(4.0 * kl * kl + kr * kr, 1.5) - kr * kr * kr);
        double effect = this.dse;
        double xc66 = t.c66;
        double xc66c = t.c66c;
        if (t.st.distanceDependent) {
            xc66 = t.c66xy;
            xc66c = t.c66cxy;
        }
        double ant = t.sp.gha / t.st.bha;
        double H100 = t.sp.h100;
        double dsx = Math.exp(this.dz0 + this.dz1 * Math.log(km) + this.dz2 * Math.log(H100) + this.dz3 * xc66 + this.dz4 * xc66c + this.dz5 * ant + effect * rn.nextNormal(1.0));
        if ((dsx /= 10000.0) < 0.0) {
            dsx = 0.0;
        }
        return dsx;
    }

    private void initFunction(int funNo) {
        if (funNo == 1) {
            this.info = "cooperi";
            this.dz0 = 2.848;
            this.dz1 = 0.105;
            this.dz2 = 0.378;
            this.dz3 = -0.616;
            this.dz4 = -3.635;
            this.dz5 = 0.004;
            this.dse = 0.0;
        }
        if (funNo == 2) {
            this.info = "durangensis";
            this.dz0 = 1.174;
            this.dz1 = 0.333;
            this.dz2 = 0.575;
            this.dz3 = -0.358;
            this.dz4 = -1.701;
            this.dz5 = 0.006;
            this.dse = 0.0;
        }
        if (funNo == 3) {
            this.info = "engelmannii";
            this.dz0 = 1.174;
            this.dz1 = 0.333;
            this.dz2 = 0.575;
            this.dz3 = -0.358;
            this.dz4 = -1.701;
            this.dz5 = 0.006;
            this.dse = 0.0;
        }
        if (funNo == 4) {
            this.info = "leiophylla";
            this.dz0 = 0.775;
            this.dz1 = 0.374;
            this.dz2 = 0.878;
            this.dz3 = -0.865;
            this.dz4 = 0.0;
            this.dz5 = 0.0;
            this.dse = 0.0;
        }
        if (funNo == 5) {
            this.info = "teocote";
            this.dz0 = 2.774;
            this.dz1 = 0.004;
            this.dz2 = 0.059;
            this.dz3 = -0.388;
            this.dz4 = -1.598;
            this.dz5 = 0.007;
            this.dse = 0.0;
        }
        if (funNo == 6) {
            this.info = "herrerae";
            this.dz0 = 2.774;
            this.dz1 = 0.004;
            this.dz2 = 0.059;
            this.dz3 = -0.388;
            this.dz4 = -1.598;
            this.dz5 = 0.007;
            this.dse = 0.0;
        }
        if (funNo == 8) {
            this.info = "ayacahuite";
            this.dz0 = 2.774;
            this.dz1 = 0.004;
            this.dz2 = 0.059;
            this.dz3 = -0.388;
            this.dz4 = -1.598;
            this.dz5 = 0.007;
            this.dse = 0.0;
        }
        if (funNo == 18) {
            this.info = "Quercus sp";
            this.dz0 = 1.738;
            this.dz1 = 0.391;
            this.dz2 = 0.384;
            this.dz3 = -0.404;
            this.dz4 = 0.0;
            this.dz5 = 0.0;
            this.dse = 0.0;
        }
        if (funNo == 20 || funNo == 21) {
            this.info = "otras latifoliadas";
            this.dz0 = 1.595;
            this.dz1 = 0.439;
            this.dz2 = 0.342;
            this.dz3 = -0.074;
            this.dz4 = 0.0;
            this.dz5 = 0.0;
            this.dse = 0.0;
        }
        if (funNo >= 50 || funNo < 60) {
            this.info = "otras latifoliadas";
            this.dz0 = 1.595;
            this.dz1 = 0.439;
            this.dz2 = 0.342;
            this.dz3 = -0.074;
            this.dz4 = 0.0;
            this.dz5 = 0.0;
            this.dse = 0.0;
        }
        if (funNo >= 30 && funNo < 40) {
            this.info = "Quercus sp";
            this.dz0 = 1.738;
            this.dz1 = 0.391;
            this.dz2 = 0.384;
            this.dz3 = -0.404;
            this.dz4 = 0.0;
            this.dz5 = 0.0;
            this.dse = 0.0;
        }
    }

    @Override
    public double getValueForSpecies(Species sp, String s) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

