/*
 * Decompiled with CFR 0.152.
 */
package treegross.plugin;

import treegross.base.Species;
import treegross.base.Tree;
import treegross.functions.PlugInFunctionClass;

public class ElSaltoTreeHeightIncrement
implements PlugInFunctionClass {
    double hz1 = 0.0;
    double hz2 = 0.0;
    double hse = 0.0;
    double hb4 = 0.0;
    double hb5 = 0.0;
    double ehoch = 0.0;
    String info = "unknown";
    int numberOfFunctions = 7;
    int funNo = 1;

    @Override
    public String getName(int funNo) {
        this.initFunction(funNo);
        return this.info;
    }

    @Override
    public double getValueForTree(Tree t, String fun) {
        double hsx = 0.0;
        this.funNo = t.sp.spDef.code;
        this.initFunction(this.funNo);
        double kr = t.cw / 2.0;
        double kl = t.h - t.cb;
        double cr = kl / t.cb;
        if (kl < 0.05) {
            kl = 0.05;
        }
        double km = Math.PI * kr / (6.0 * kl * kl) * (Math.pow(4.0 * kl * kl + kr * kr, 1.5) - kr * kr * kr);
        double effect = this.hse;
        if (this.funNo <= 5) {
            hsx = this.hz1 / (1.0 - (1.0 - this.hz1 / t.h) * Math.pow(t.d / (t.d + t.bhdinc), this.hz2)) - t.h;
        }
        if (this.funNo == 6) {
            hsx = this.hz1 * Math.pow(t.h / this.hz1, Math.pow(t.d / (t.d + t.bhdinc), this.hz2)) - t.h;
        }
        if (this.funNo == 7) {
            hsx = this.hz1 / (1.0 - (1.0 - this.hz1 / t.h) * Math.pow(t.d / (t.d + t.bhdinc), this.hz2)) - t.h;
        }
        if (this.funNo == 8) {
            hsx = this.hz1 * Math.pow(t.h / this.hz1, Math.pow(t.d / (t.d + t.bhdinc), this.hz2)) - t.h;
        }
        if (hsx < 0.0) {
            hsx = 0.0;
        }
        return hsx;
    }

    private void initFunction(int funNo) {
        this.numberOfFunctions = 9;
        if (funNo == 1) {
            this.info = "Pinus cooperi";
            this.hz1 = 28.2808;
            this.hz2 = 1.20086;
            this.hse = 0.068;
        }
        if (funNo == 2) {
            this.info = "Pinus durangensis";
            this.hz1 = 33.2986;
            this.hz2 = 1.0222;
            this.hse = 0.068;
        }
        if (funNo == 3) {
            this.info = "Pinus engelmanni";
            this.hz1 = 33.2986;
            this.hz2 = 1.0222;
            this.hse = 0.068;
        }
        if (funNo == 4) {
            this.info = "Pinus leiophylla";
            this.hz1 = 50.267;
            this.hz2 = 0.753;
            this.hse = 0.068;
        }
        if (funNo == 5) {
            this.info = "Pinus teocote";
            this.hz1 = 36.256;
            this.hz2 = 1.0213;
            this.hse = 0.068;
        }
        if (funNo == 6) {
            this.info = "Pinus herrerae";
            this.hz1 = 36.256;
            this.hz2 = 1.0213;
            this.hse = 0.068;
        }
        if (funNo == 8) {
            this.info = "Pinus ayacahuite";
            this.hz1 = 40.493;
            this.hz2 = 0.54;
            this.hse = 0.068;
        }
        if (funNo >= 30 && funNo < 40) {
            this.info = "Quercus spp";
            this.hz1 = 29.6333;
            this.hz2 = 1.1616;
            this.hse = 0.068;
        }
        if (funNo == 20 || funNo == 21) {
            this.info = "otras latifoliadas";
            this.hz1 = 26.2414;
            this.hz2 = 0.7629;
            this.hse = 0.068;
        }
        if (funNo >= 50 && funNo < 60) {
            this.info = "otras latifoliadas";
            this.hz1 = 26.2414;
            this.hz2 = 0.7629;
            this.hse = 0.068;
        }
    }

    @Override
    public double getValueForSpecies(Species sp, String s) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

