/*
 * Decompiled with CFR 0.152.
 */
package treegross.random;

import java.util.Random;
import treegross.random.NormalDistRandomList;
import treegross.random.UniformDistRandomList;

public class RandomNumber {
    public static final int OFF = 10;
    public static final int PSEUDO_FIXED = 11;
    public static final int PSEUDO = 12;
    public static final int FIXED_SIZE = 10000;
    private int loopPosUniform;
    private int loopPosNormal;
    private int randomType;
    public boolean randomOn;
    private final Random r;
    private final double a1 = 0.31938513;
    private final double a2 = -0.356563782;
    private final double a3 = 1.781477937;
    private final double a4 = -1.821255978;
    private final double a5 = 1.330274429;

    public RandomNumber(int type) {
        this.setRandomType(type);
        this.loopPosNormal = -1;
        this.loopPosUniform = -1;
        this.r = new Random();
    }

    public int getRandomType() {
        return this.randomType;
    }

    public final void setRandomType(int type) {
        this.randomType = 12;
        if (type >= 10 && type <= 12) {
            this.randomType = type;
        }
        this.randomOn = this.randomType != 10;
    }

    public void setLoopIndexNormal(int i) {
        this.loopPosNormal = i;
    }

    public int getLoopIndexNormal() {
        return this.loopPosNormal;
    }

    public void setLoopIndexUniform(int i) {
        this.loopPosUniform = i;
    }

    public int getLoopIndexUniform() {
        return this.loopPosUniform;
    }

    private void loopUniform() {
        ++this.loopPosUniform;
        if (this.loopPosUniform > 9999) {
            this.loopPosUniform = 0;
        }
    }

    private void loopNormal() {
        ++this.loopPosNormal;
        if (this.loopPosNormal > 9999) {
            this.loopPosNormal = 0;
        }
    }

    public double nextUniform() {
        switch (this.randomType) {
            case 12: {
                return this.r.nextDouble();
            }
            case 11: {
                this.loopUniform();
                return UniformDistRandomList.getValue(this.loopPosUniform);
            }
        }
        return 0.5;
    }

    public double nextNormal() {
        switch (this.randomType) {
            case 12: {
                return this.r.nextGaussian();
            }
            case 11: {
                this.loopNormal();
                return NormalDistRandomList.getValue(this.loopPosNormal);
            }
        }
        return 0.0;
    }

    public double nextNormal(double sigma) {
        double x;
        if (!this.randomOn) {
            return 0.0;
        }
        double p = 0.0;
        do {
            double px = (p = this.nextUniform()) < 0.5 ? 1.0 - p : p;
            x = sigma;
            double x2 = sigma * 0.5;
            for (int i = 0; i < 10; ++i) {
                double t = 1.0 / (1.0 + 0.2316419 * x);
                double z = 1.0 - 1.0 / Math.sqrt(Math.PI * 2) * Math.exp(-x * x * 0.5) * (0.31938513 * t + -0.356563782 * t * t + 1.781477937 * t * t * t + -1.821255978 * t * t * t * t + 1.330274429 * t * t * t * t * t);
                x = z < px ? (x += x2) : (x -= x2);
                x2 /= 2.0;
            }
        } while (x > sigma);
        if (p < 0.5) {
            x = -x;
        }
        return x;
    }

    public RandomNumber clone() {
        RandomNumber c = new RandomNumber(this.randomType);
        c.setLoopIndexUniform(this.loopPosUniform);
        c.setLoopIndexNormal(this.loopPosNormal);
        return c;
    }
}

