/*
 * Decompiled with CFR 0.152.
 */
package treegross.treatment;

import java.util.BitSet;
import java.util.Random;
import treegross.base.Stand;
import treegross.base.Tree;

public class HabitatTreeSelection {
    public void selectHabitatTrees(Stand st) {
        int[] criteriatreenumber = new int[(int)(100.0 * st.size)];
        int ntcriteria = 0;
        double mindistanceallowed = 0.0;
        BitSet b = new BitSet();
        Random r = new Random();
        if (this.getNHabitatTrees(st) < this.getTargetNHabitat(st)) {
            for (int n = 0; n < st.ntrees - 1; ++n) {
                for (int m = n + 1; m < st.ntrees; ++m) {
                    if (!(st.tr[n].h < st.tr[m].h)) continue;
                    Tree trtemp = st.tr[n];
                    st.tr[n] = st.tr[m];
                    st.tr[m] = trtemp;
                }
            }
            int habspecies = 1000;
            if (st.trule.habitatTreeType == 0) {
                habspecies = 500;
            }
            if (st.trule.habitatTreeType == 1) {
                habspecies = 300;
            }
            for (int n = 0; n < st.ntrees; ++n) {
                if (!(st.tr[n].h > st.tr[n].sp.trule.minCropTreeHeight) || ntcriteria >= (int)(100.0 * st.size) || st.tr[n].outtype != 0 || st.tr[n].habitat || st.tr[n].crop || st.tr[n].code >= habspecies) continue;
                double mindistance = Double.MAX_VALUE;
                for (int ii = 0; ii < st.ntrees; ++ii) {
                    double distYS;
                    double distXS;
                    double distance;
                    if (!st.tr[ii].crop || st.tr[ii].out >= 0 || !((distance = Math.sqrt((distXS = (st.tr[n].x - st.tr[ii].x) * (st.tr[n].x - st.tr[ii].x)) + (distYS = (st.tr[n].y - st.tr[ii].y) * (st.tr[n].y - st.tr[ii].y)))) < mindistance)) continue;
                    Tree atree = new Tree();
                    atree.code = st.tr[ii].code;
                    atree.sp = st.tr[ii].sp;
                    atree.d = st.tr[ii].sp.trule.targetDiameter;
                    mindistanceallowed = atree.calculateCw();
                    mindistance = distance;
                }
                if (!(mindistance > mindistanceallowed)) continue;
                criteriatreenumber[ntcriteria] = n;
                ++ntcriteria;
            }
            if (ntcriteria > 0) {
                boolean endselection;
                do {
                    int i;
                    int nselectedhabitattrees;
                    boolean bl = endselection = (nselectedhabitattrees = this.getNHabitatTrees(st)) >= this.getTargetNHabitat(st) || nselectedhabitattrees == ntcriteria;
                    if (endselection || b.get(i = Math.abs(r.nextInt()) % ntcriteria)) continue;
                    st.tr[criteriatreenumber[i]].habitat = true;
                    b.set(i);
                } while (!endselection);
            }
        }
    }

    public int getNHabitatTrees(Stand st) {
        int n = 0;
        for (int i = 0; i < st.ntrees; ++i) {
            if (st.tr[i].outtype != 0 || !st.tr[i].habitat) continue;
            ++n;
        }
        return n;
    }

    public int getTargetNHabitat(Stand st) {
        int targetNHabitatStand = (int)Math.floor(st.trule.nHabitat * st.size);
        if (st.trule.selectHabiatPart) {
            ++targetNHabitatStand;
        } else {
            double hab = st.trule.nHabitat * st.size;
            if (hab > 0.0 && hab < 1.0 && st.random.nextUniform() < hab) {
                targetNHabitatStand = 1;
            }
            if (hab >= 1.0) {
                targetNHabitatStand = (int)Math.round(hab);
            }
        }
        return targetNHabitatStand;
    }

    public double getVolHabitatTrees(Stand st) {
        double fm = 0.0;
        for (int i = 0; i < st.ntrees; ++i) {
            if (st.tr[i].outtype != 0 || !st.tr[i].habitat) continue;
            fm += st.tr[i].v * st.tr[i].fac;
        }
        return fm;
    }

    public boolean selectHabitatPartByStandSize(Stand st) {
        int floorStandSize;
        double part;
        boolean selHabitatPart = false;
        double randomNumber = st.random.nextUniform();
        if (randomNumber <= (part = st.size - (double)(floorStandSize = (int)Math.floor(st.size)))) {
            selHabitatPart = true;
        }
        return selHabitatPart;
    }
}

