/*
 * Decompiled with CFR 0.152.
 */
package treegross.treatment;

import java.util.logging.Level;
import java.util.logging.Logger;
import treegross.base.GenerateXY;
import treegross.base.Species;
import treegross.base.SpeciesNotDefinedException;
import treegross.base.Stand;
import treegross.base.Tree;
import treegross.treatment.CropTreeSelection;
import treegross.treatment.CropTreeSpecies;
import treegross.treatment.HabitatTreeSelection;

public class TreatmentElements2 {
    double vmaxharvest;
    double vmaxthinning;
    double vout;
    double harvested;
    double thinned;
    CropTreeSelection ctselect = new CropTreeSelection();
    HabitatTreeSelection htselect = new HabitatTreeSelection();
    private static final Logger LOGGER = Logger.getLogger(TreatmentElements2.class.getName());

    public void resetOutTake(Stand st) {
        this.vout = 0.0;
        this.harvested = 0.0;
        this.thinned = 0.0;
        this.vmaxharvest = 0.0;
        this.vmaxthinning = 0.0;
    }

    public void resetCropTrees(Stand st) {
        for (int i = 0; i < st.ntrees; ++i) {
            st.tr[i].crop = false;
        }
    }

    public void resetTempCropTrees(Stand st) {
        for (int i = 0; i < st.ntrees; ++i) {
            st.tr[i].tempcrop = false;
        }
    }

    public void resetHabitatTrees(Stand st) {
        for (int i = 0; i < st.ntrees; ++i) {
            st.tr[i].habitat = false;
        }
    }

    public void SelectOneCropTreePerSpecies(Stand st, boolean forceSelection) {
        double rn = forceSelection ? 0.0 : st.random.nextUniform();
        if (rn <= st.size) {
            int i;
            CropTreeSpecies[] ctspecies = new CropTreeSpecies[30];
            for (i = 0; i < st.nspecies - 1; ++i) {
                for (int j = i + 1; j < st.nspecies; ++j) {
                    if (!(st.sp[i].nha > st.sp[j].nha)) continue;
                    Species sptemp = st.sp[i];
                    st.sp[i] = st.sp[j];
                    st.sp[j] = sptemp;
                }
            }
            for (i = 0; i < st.nspecies; ++i) {
                Tree atree = new Tree();
                atree.st = st;
                atree.code = st.sp[i].code;
                atree.sp = st.sp[i];
                atree.d = st.sp[i].trule.targetDiameter;
                double dist_ct = atree.calculateCw();
                ctspecies[i] = new CropTreeSpecies();
                ctspecies[i].addCtsp(st.sp[i].code, 1.0 / st.size, dist_ct, st.sp[i].trule.minCropTreeHeight);
            }
            this.ctselect.selectCropTrees(st, ctspecies);
        }
    }

    public void selectCropTreeTargetPercentage(Stand st) {
        CropTreeSpecies[] ctspecies = new CropTreeSpecies[30];
        for (int i = 0; i < st.nspecies; ++i) {
            Tree atree = new Tree();
            atree.st = st;
            atree.code = st.sp[i].code;
            atree.sp = st.sp[i];
            atree.d = st.sp[i].trule.targetDiameter;
            double dist_ct = atree.calculateCw();
            int n_ct_ha = (int)(10000.0 / (Math.PI * (dist_ct * dist_ct) * 0.25) * st.sp[i].trule.targetCrownPercent * 0.01);
            ctspecies[i] = new CropTreeSpecies(st.sp[i].code, n_ct_ha, dist_ct, st.sp[i].trule.minCropTreeHeight);
        }
        this.ctselect.selectCropTrees(st, ctspecies);
    }

    public void selectNCropTrees(Stand st) {
        CropTreeSpecies[] ctspecies = new CropTreeSpecies[30];
        for (int i = 0; i < st.nspecies; ++i) {
            double dist_ct = st.sp[i].trule.numberCropTreesWanted == 0 ? 0.01 : 0.8 * Math.sqrt(100.0 * st.sp[i].trule.targetCrownPercent / (double)st.sp[i].trule.numberCropTreesWanted);
            ctspecies[i] = new CropTreeSpecies();
            ctspecies[i].addCtsp(st.sp[i].code, st.sp[i].trule.numberCropTreesWanted, dist_ct, st.sp[i].trule.minCropTreeHeight);
        }
        this.ctselect.selectCropTrees(st, ctspecies);
    }

    public void selectTempCropTreesTargetPercentage(Stand st) {
        CropTreeSpecies[] ctspecies = new CropTreeSpecies[30];
        for (int i = 0; i < st.nspecies; ++i) {
            Tree atree = new Tree();
            atree.st = st;
            atree.code = st.sp[i].code;
            atree.d = st.sp[i].d100;
            atree.sp = st.sp[i];
            double dist_ct = atree.calculateCw();
            int n_ct_ha = (int)(10000.0 / (Math.PI * (dist_ct * dist_ct) * 0.25) * st.sp[i].trule.targetCrownPercent * 0.01);
            ctspecies[i] = new CropTreeSpecies();
            ctspecies[i].addCtsp(st.sp[i].code, n_ct_ha, dist_ct, st.sp[i].trule.minCropTreeHeight);
        }
        this.ctselect.selectTempCropTrees(st, ctspecies);
    }

    public void selectHabitatTrees(Stand st) {
        this.htselect.selectHabitatTrees(st);
    }

    public void harvestTargetDiameter(Stand st) {
        this.vmaxharvest = st.size * st.trule.maxHarvestVolume - this.harvested;
        if (st.size * st.trule.maxOutVolume - this.vout < this.vmaxharvest) {
            this.vmaxharvest = st.size * st.trule.maxOutVolume - this.vout;
        }
        if (this.vmaxharvest > 0.0) {
            int i;
            for (i = 0; i < st.ntrees - 1; ++i) {
                for (int j = i + 1; j < st.ntrees; ++j) {
                    if (!(st.tr[i].sp.trule.targetDiameter - st.tr[i].d > st.tr[j].sp.trule.targetDiameter - st.tr[j].d)) continue;
                    Tree trtemp = st.tr[i];
                    st.tr[i] = st.tr[j];
                    st.tr[j] = trtemp;
                }
            }
            for (i = 0; i < st.ntrees; ++i) {
                if (st.tr[i].habitat || !(st.tr[i].d > st.tr[i].sp.trule.targetDiameter) || st.tr[i].out >= 0 || !(this.harvested < this.vmaxharvest)) continue;
                if (this.getDegreeOfCover(0, st, true) < st.trule.minimumCoverage) break;
                this.vout += st.tr[i].fac * st.tr[i].v;
                this.harvested += st.tr[i].fac * st.tr[i].v;
                st.tr[i].out = st.year;
                st.tr[i].outtype = 3;
            }
        }
    }

    public void harvestByGaps(Stand st) {
        this.vmaxharvest = st.size * st.trule.maxHarvestVolume - this.harvested;
        if (st.size * st.trule.maxOutVolume - this.vout < this.vmaxharvest) {
            this.vmaxharvest = st.size * st.trule.maxOutVolume - this.vout;
        }
        boolean done = false;
        while (this.harvested < this.vmaxharvest && this.vmaxharvest > 0.0 && !done) {
            double distYS;
            double distXS;
            double dist;
            int i;
            int merk = -9;
            double maxdiff = -9999.9;
            for (i = 0; i < st.ntrees; ++i) {
                if (st.tr[i].out >= 0 || !st.tr[i].crop || st.tr[i].habitat) continue;
                double diff = 0.0;
                for (int j = 0; j < st.ntrees; ++j) {
                    if (st.tr[j].out >= 0 || !st.tr[j].crop && !st.tr[j].habitat || !((dist = (distXS = (st.tr[j].x - st.tr[i].x) * (st.tr[j].x - st.tr[i].x)) + (distYS = (st.tr[j].y - st.tr[i].y) * (st.tr[j].y - st.tr[i].y))) <= 144.0)) continue;
                    diff += st.tr[j].d - st.tr[j].sp.trule.targetDiameter;
                }
                if (!(diff > 0.0) || !(diff > maxdiff)) continue;
                merk = i;
                maxdiff = diff;
            }
            if (merk == -9) {
                done = true;
                continue;
            }
            for (i = 0; i < st.ntrees; ++i) {
                if (st.tr[i].habitat || st.tr[i].out >= 0 || !(st.tr[i].h > 12.0) || !((dist = (distXS = (st.tr[merk].x - st.tr[i].x) * (st.tr[merk].x - st.tr[i].x)) + (distYS = (st.tr[merk].y - st.tr[i].y) * (st.tr[merk].y - st.tr[i].y))) <= 144.0) || !(st.tr[i].h > st.tr[merk].h * 0.25)) continue;
                this.vout += st.tr[i].fac * st.tr[i].v;
                this.harvested += st.tr[i].fac * st.tr[i].v;
                st.tr[i].out = st.year;
                st.tr[i].outtype = 3;
            }
        }
        if (this.harvested < this.vmaxharvest && this.vmaxharvest > 0.0) {
            for (int i = 0; i < st.ntrees; ++i) {
                if (st.tr[i].habitat || !(st.tr[i].d > st.tr[i].sp.trule.targetDiameter * 1.15) || st.tr[i].out >= 0 || !(this.harvested < this.vmaxharvest)) continue;
                if (this.getDegreeOfCover(0, st, true) < st.trule.minimumCoverage) break;
                this.vout += st.tr[i].fac * st.tr[i].v;
                this.harvested += st.tr[i].fac * st.tr[i].v;
                st.tr[i].out = st.year;
                st.tr[i].outtype = 3;
            }
        }
    }

    public void harvestCompetingCropTrees(Stand st) {
        this.vmaxharvest = st.size * st.trule.maxHarvestVolume - this.harvested;
        if (st.size * st.trule.maxOutVolume - this.vout < this.vmaxharvest) {
            this.vmaxharvest = st.size * st.trule.maxOutVolume - this.vout;
        }
        if (this.vmaxharvest > 0.0) {
            for (int i = 0; i < st.ntrees - 1; ++i) {
                for (int j = i + 1; j < st.ntrees; ++j) {
                    if (!(st.tr[i].sp.trule.targetDiameter - st.tr[i].d > st.tr[j].sp.trule.targetDiameter - st.tr[j].d)) continue;
                    Tree trtemp = st.tr[i];
                    st.tr[i] = st.tr[j];
                    st.tr[j] = trtemp;
                }
            }
            for (int i = 0; i < st.ntrees; ++i) {
                if (st.tr[i].out >= 1 || !st.tr[i].crop) continue;
                for (int j = 0; j < st.ntrees; ++j) {
                    if (st.tr[j].out >= 0 || !st.tr[j].crop || st.tr[i].no.compareTo(st.tr[j].no) == 0 || st.tr[j].habitat) continue;
                    double distXS = (st.tr[i].x - st.tr[j].x) * (st.tr[i].x - st.tr[j].x);
                    double distYS = (st.tr[i].y - st.tr[j].y) * (st.tr[i].y - st.tr[j].y);
                    double dist_trees = Math.sqrt(distXS + distYS);
                    double h66_i = st.tr[i].cb + (st.tr[i].h - st.tr[i].cb) / 3.0;
                    double dist_min = h66_i < st.tr[j].h ? (st.tr[i].calculateCwAtHeight(h66_i) + st.tr[j].calculateCwAtHeight(h66_i)) / 2.0 : 0.0;
                    if (!(this.harvested < this.vmaxharvest) || !(dist_trees < dist_min) || !(st.tr[j].sp.trule.targetDiameter - st.tr[j].d <= st.tr[i].sp.trule.targetDiameter - st.tr[i].d)) continue;
                    st.tr[j].out = st.year;
                    st.tr[j].outtype = 3;
                    this.vout += st.tr[j].fac * st.tr[j].v;
                    this.harvested += st.tr[j].fac * st.tr[j].v;
                }
            }
        }
    }

    public void harvestClearCut(Stand st) {
        int i;
        for (i = 0; i < st.ntrees; ++i) {
            if (st.tr[i].out >= 1 || !(st.tr[i].h >= st.tr[i].si * 0.6) || st.tr[i].habitat) continue;
            if (this.getDegreeOfCover(0, st, true) < st.trule.minimumCoverage) break;
            st.tr[i].out = st.year;
            st.tr[i].outtype = 3;
        }
        if (st.trule.onPlantingRemoveAllTrees) {
            for (i = 0; i < st.ntrees; ++i) {
                if (st.tr[i].out >= 0 || st.tr[i].habitat) continue;
                if (this.getDegreeOfCover(0, st, true) < st.trule.minimumCoverage) break;
                st.tr[i].out = st.year;
                st.tr[i].outtype = 3;
            }
        }
        st.status = 1;
    }

    public double percentOfBasalAreaAboveTargetDiameter(Stand st) {
        double perc = 0.0;
        double sum = 0.0;
        double sumTarget = 0.0;
        for (int i = 0; i < st.ntrees; ++i) {
            if (st.tr[i].out >= 0 || !(st.tr[i].d >= 7.0) || st.tr[i].habitat) continue;
            double treeG = st.tr[i].d * st.tr[i].d * st.tr[i].fac;
            sum += treeG;
            if (!(st.tr[i].d > st.tr[i].sp.trule.targetDiameter)) continue;
            sumTarget += treeG;
        }
        if (sum > 0.0) {
            perc = sumTarget / sum;
        }
        return perc;
    }

    public void harvestSchirmschlag(Stand st) {
        double degree = 0.0;
        String rp = st.trule.regenerationProcess;
        String[] rpArray = rp.split(";");
        int index = st.status - 1;
        if (index >= 0 && index < rpArray.length && rpArray[index] != null) {
            try {
                degree = Double.parseDouble(rpArray[index]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (degree == 0.0) {
            st.status = 98;
        }
        ++st.status;
        double baHarv = 0.0;
        if (degree > 0.0) {
            double baOut = st.bha - this.getMaxStandBasalArea(st, true) * degree;
            if (baOut < 0.0) {
                baOut = 0.0;
            }
            while (baHarv < baOut) {
                double max = -9999999.0;
                int merk = -9;
                for (int i = 0; i < st.ntrees; ++i) {
                    double diff;
                    if (st.tr[i].out >= 0 || !(st.tr[i].d >= 7.0) || st.tr[i].habitat || !(st.tr[i].d >= st.tr[i].sp.trule.targetDiameter * 0.3) || !(max < (diff = st.tr[i].d - st.tr[i].sp.trule.targetDiameter))) continue;
                    merk = i;
                    max = diff;
                }
                if (this.getDegreeOfCover(0, st, true) < st.trule.minimumCoverage || merk == -9) break;
                st.tr[merk].out = st.year;
                st.tr[merk].outtype = 3;
                baHarv += Math.PI * (st.tr[merk].d * 0.005 * (st.tr[merk].d * 0.005)) * (st.tr[merk].fac / st.size);
            }
        }
        if (degree == 0.0) {
            if (Double.parseDouble(rpArray[rpArray.length - 1]) == 0.0) {
                this.harvestRemainingTrees(st, true, -1, 1.3);
            } else {
                st.status = 1;
                st.trule.standTypeAtStatus1 = -1;
            }
        }
    }

    public void harvestTargetDiameterInPeriod(Stand st) {
        double degree = 0.0;
        String rp = st.trule.regenerationProcess;
        String[] rpArray = rp.split(";");
        int index = st.status - 1;
        if (index >= 0 && index < rpArray.length && rpArray[index] != null) {
            try {
                degree = Double.parseDouble(rpArray[index]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (degree == 0.0) {
            st.status = 98;
        }
        ++st.status;
        double baHarv = 0.0;
        if (degree > 0.0) {
            int kill;
            int count;
            int merk;
            double baOut = st.bha - this.getMaxStandBasalArea(st, true) * degree;
            if (baOut < 0.0) {
                baOut = 0.0;
            }
            double baOut50 = baOut * 0.5;
            while (baHarv < baOut50) {
                int i;
                merk = -9;
                count = 0;
                for (i = 0; i < st.ntrees; ++i) {
                    if (st.tr[i].out >= 0 || !(st.tr[i].d >= 7.0) || st.tr[i].habitat || st.tr[i].crop) continue;
                    ++count;
                }
                if (this.getDegreeOfCover(0, st, true) < st.trule.minimumCoverage || count <= 0) break;
                kill = (int)Math.floor(st.random.nextUniform() * (double)count);
                count = 0;
                for (i = 0; i < st.ntrees; ++i) {
                    if (st.tr[i].out >= 0 || !(st.tr[i].d >= 7.0) || st.tr[i].habitat || st.tr[i].crop) continue;
                    if (count == kill) {
                        merk = i;
                    }
                    ++count;
                }
                st.tr[merk].out = st.year;
                st.tr[merk].outtype = 3;
                baHarv += Math.PI * (st.tr[merk].d * 0.005 * (st.tr[merk].d * 0.005)) * (st.tr[merk].fac / st.size);
            }
            while (baHarv < baOut) {
                double min = Double.POSITIVE_INFINITY;
                merk = -9;
                for (int i = 0; i < st.ntrees; ++i) {
                    double diff;
                    if (st.tr[i].out >= 0 || !(st.tr[i].d >= 7.0) || st.tr[i].habitat || !st.tr[i].crop || !(min > (diff = st.tr[i].d - st.tr[i].sp.trule.targetDiameter))) continue;
                    merk = i;
                    min = diff;
                }
                if (this.getDegreeOfCover(0, st, true) < st.trule.minimumCoverage || merk == -9) break;
                st.tr[merk].out = st.year;
                st.tr[merk].outtype = 3;
                baHarv += Math.PI * (st.tr[merk].d * 0.005 * (st.tr[merk].d * 0.005)) * (st.tr[merk].fac / st.size);
            }
            while (baHarv < baOut) {
                int i;
                merk = -9;
                count = 0;
                for (i = 0; i < st.ntrees; ++i) {
                    if (st.tr[i].out >= 0 || !(st.tr[i].d >= 7.0) || st.tr[i].habitat || st.tr[i].crop) continue;
                    ++count;
                }
                if (this.getDegreeOfCover(0, st, true) < st.trule.minimumCoverage || count <= 0) break;
                kill = (int)Math.floor(st.random.nextUniform() * (double)count);
                count = 0;
                for (i = 0; i < st.ntrees; ++i) {
                    if (st.tr[i].out >= 0 || !(st.tr[i].d >= 7.0) || st.tr[i].habitat || st.tr[i].crop) continue;
                    if (count == kill) {
                        merk = i;
                    }
                    ++count;
                }
                st.tr[merk].out = st.year;
                st.tr[merk].outtype = 3;
                baHarv += Math.PI * (st.tr[merk].d * 0.005 * (st.tr[merk].d * 0.005)) * (st.tr[merk].fac / st.size);
            }
        }
        if (degree == 0.0) {
            if (Double.parseDouble(rpArray[rpArray.length - 1]) == 0.0) {
                this.harvestRemainingTrees(st, true, -1, 1.3);
            } else {
                st.status = 1;
                st.trule.standTypeAtStatus1 = -1;
            }
        }
    }

    public void harvestRemainingTrees(Stand st, boolean overstoryOnly, int protect_spec, double min_height) {
        int i;
        double hx = min_height;
        double prot_height = 0.0;
        for (i = 0; i < st.nspecies; ++i) {
            if (st.sp[i].code == 999) continue;
            if (overstoryOnly) {
                hx = st.sp[i].hbon * 0.6;
            }
            prot_height = st.sp[i].hbon * 0.2;
            break;
        }
        for (i = 0; i < st.ntrees; ++i) {
            if (!overstoryOnly && st.tr[i].code == 999) {
                st.tr[i].out = st.year;
                st.tr[i].outtype = 3;
            }
            if (st.tr[i].out >= 1 || !(st.tr[i].h >= hx) || st.tr[i].habitat) continue;
            if (this.getDegreeOfCover(0, st, true) < st.trule.minimumCoverage) break;
            if (protect_spec > 0 && st.tr[i].code == protect_spec && st.tr[i].h < prot_height) continue;
            st.tr[i].out = st.year;
            st.tr[i].outtype = 3;
        }
        st.status = 1;
        st.trule.standTypeAtStatus1 = -1;
    }

    private double reduceBaOut(Stand st, double maxBa) {
        boolean reduce;
        if (maxBa == 0.0 || st.sp[0] == null) {
            return 0.0;
        }
        double maxBasalAreaOut = st.bha - maxBa;
        double baFac = st.bha / maxBa;
        String[] heightStartReducingA = st.sp[0].spDef.moderateThinning.split(";");
        double heightStartReducing = Double.POSITIVE_INFINITY;
        if (heightStartReducingA.length > st.trule.getIndexModerateThinning()) {
            heightStartReducing = Double.parseDouble(heightStartReducingA[st.trule.getIndexModerateThinning()]);
        }
        boolean bl = reduce = st.sp[0].h100 >= heightStartReducing;
        if (baFac > st.trule.degreeOfStokingToLimitThinning && reduce) {
            maxBasalAreaOut *= st.trule.degreeOfStokingToLimitThinning / baFac;
        }
        return maxBasalAreaOut;
    }

    public double getMaxStandBasalArea(Stand st, boolean withModerateThinningFactor) {
        double maxBA = 0.0;
        for (int i = 0; i < st.nspecies; ++i) {
            Tree atree = new Tree();
            atree.sp = st.sp[i];
            atree.st = st;
            atree.d = st.sp[i].d100;
            atree.h = st.sp[i].h100;
            atree.si = st.sp[i].hbon;
            atree.age = (int)Math.round(st.sp[i].h100age);
            atree.cw = atree.calculateCw();
            atree.code = st.sp[i].code;
            if (withModerateThinningFactor) {
                maxBA += atree.calculateMaxBasalArea() * atree.getModerateThinningFactor() * (st.sp[i].percCSA / 100.0);
                continue;
            }
            maxBA += atree.calculateMaxBasalArea() * (st.sp[i].percCSA / 100.0);
        }
        return maxBA;
    }

    public double getMaxSpeciesBasalArea(Stand st, Species sp, boolean withModerateThinningFactor) {
        Tree atree = new Tree();
        atree.sp = sp;
        atree.st = st;
        if (sp.h100 > 10.0) {
            atree.d = sp.d100;
            atree.h = sp.h100;
        } else {
            atree.d = sp.dg;
            atree.h = sp.hg;
        }
        atree.age = (int)Math.round(sp.h100age);
        atree.cw = atree.calculateCw();
        atree.code = sp.code;
        double maxBA = withModerateThinningFactor ? atree.calculateMaxBasalArea() * atree.getModerateThinningFactor() * (sp.trule.targetCrownPercent / 100.0) : atree.calculateMaxBasalArea() * (sp.trule.targetCrownPercent / 100.0);
        return maxBA;
    }

    public void thinCropTreeCompetition(Stand st) {
        this.vmaxthinning = st.size * st.trule.maxThinningVolume - this.thinned;
        if (st.size * st.trule.maxOutVolume - this.vout < this.vmaxthinning) {
            this.vmaxthinning = st.size * st.trule.maxOutVolume - this.vout;
        }
        if (this.vmaxthinning > 0.0) {
            double intensity = 2.0 - st.trule.thinningIntensity;
            if (intensity == 0.0) {
                intensity = 1.0;
            }
            double maxStandBasalArea = this.getMaxStandBasalArea(st, true);
            maxStandBasalArea = st.trule.thinningIntensity == 0.0 ? (maxStandBasalArea *= 100.0) : (maxStandBasalArea *= 2.0 - st.trule.thinningIntensity);
            double maxBasalAreaOut = this.reduceBaOut(st, maxStandBasalArea);
            boolean doNotEndThinning = true;
            if (maxBasalAreaOut <= 0.0) {
                doNotEndThinning = false;
            } else {
                do {
                    for (int i = 0; i < st.ntrees; ++i) {
                        if (st.tr[i].out >= 0 || !st.tr[i].crop) continue;
                        st.tr[i].updateCompetition();
                    }
                    int indexOfCroptree = -9;
                    double maxCompetition = -99999.9;
                    for (int i = 0; i < st.ntrees; ++i) {
                        if (st.tr[i].out >= 0 || !st.tr[i].crop) continue;
                        double maxBasalArea = st.tr[i].calculateMaxBasalArea() * st.tr[i].getModerateThinningFactor();
                        maxBasalArea = st.trule.thinningIntensity == 0.0 ? (maxBasalArea *= 100.0) : (maxBasalArea *= 2.0 - st.trule.thinningIntensity);
                        double maxN = maxBasalArea / (Math.PI * (st.tr[i].d * 0.005 * (st.tr[i].d * 0.005)));
                        double maxC66 = maxN * Math.PI * (st.tr[i].cw * 0.5 * (st.tr[i].cw * 0.5)) / 10000.0;
                        double c66Ratio = st.tr[i].c66xy / maxC66;
                        if (!(c66Ratio > maxCompetition)) continue;
                        indexOfCroptree = i;
                        maxCompetition = c66Ratio;
                    }
                    if (indexOfCroptree < 0) {
                        doNotEndThinning = false;
                        continue;
                    }
                    double dist = 9999.0;
                    int merk = -9;
                    double h66 = st.tr[indexOfCroptree].cb;
                    for (int i = 0; i < st.tr[indexOfCroptree].nNeighbor; ++i) {
                        if (!(st.tr[st.tr[indexOfCroptree].neighbor[i]].d > 7.0) || st.tr[st.tr[indexOfCroptree].neighbor[i]].out >= 0 || !st.trule.cutCompetingCropTrees && st.tr[st.tr[indexOfCroptree].neighbor[i]].crop || st.tr[st.tr[indexOfCroptree].neighbor[i]].habitat) continue;
                        double radius = st.tr[st.tr[indexOfCroptree].neighbor[i]].calculateCwAtHeight(h66) * 0.5;
                        double distXS = (st.tr[indexOfCroptree].x - st.tr[st.tr[indexOfCroptree].neighbor[i]].x) * (st.tr[indexOfCroptree].x - st.tr[st.tr[indexOfCroptree].neighbor[i]].x);
                        double distYS = (st.tr[indexOfCroptree].y - st.tr[st.tr[indexOfCroptree].neighbor[i]].y) * (st.tr[indexOfCroptree].y - st.tr[st.tr[indexOfCroptree].neighbor[i]].y);
                        double ent = Math.sqrt(distXS + distYS);
                        if (!(ent - radius < st.tr[indexOfCroptree].cw * (0.75 / intensity)) || !(dist > ent - radius)) continue;
                        merk = st.tr[indexOfCroptree].neighbor[i];
                        dist = ent - radius;
                    }
                    if (merk == -9) {
                        doNotEndThinning = false;
                        continue;
                    }
                    st.tr[merk].out = st.year;
                    st.tr[merk].outtype = 2;
                    this.thinned += st.tr[merk].fac * st.tr[merk].v;
                    if (!((maxBasalAreaOut -= st.tr[merk].fac * Math.PI * (st.tr[merk].d * 0.005 * (st.tr[merk].d * 0.005)) / st.size) <= 0.0)) continue;
                    doNotEndThinning = false;
                } while (this.thinned < this.vmaxthinning && doNotEndThinning);
            }
        }
    }

    public void thinCropTreeCompetition2(Stand st) {
        this.vmaxthinning = st.size * st.trule.maxThinningVolume - this.thinned;
        if (st.size * st.trule.maxOutVolume - this.vout < this.vmaxthinning) {
            this.vmaxthinning = st.size * st.trule.maxOutVolume - this.vout;
        }
        if (this.vmaxthinning > 0.0) {
            double intensity = 2.0 - st.trule.thinningIntensity;
            if (intensity == 0.0) {
                intensity = 1.0;
            }
            double maxStandBasalArea = this.getMaxStandBasalArea(st, true);
            maxStandBasalArea = st.trule.thinningIntensity == 0.0 ? (maxStandBasalArea *= 100.0) : (maxStandBasalArea *= 2.0 - st.trule.thinningIntensity);
            for (int iik = 0; iik < st.nspecies; ++iik) {
                double baIst = 0.0;
                for (int jjk = 0; jjk < st.ntrees; ++jjk) {
                    if (st.sp[iik].code != st.tr[jjk].code || st.tr[jjk].out >= 0 || !(st.tr[jjk].d >= 7.0)) continue;
                    baIst += Math.PI * (st.tr[jjk].d * 0.005 * (st.tr[jjk].d * 0.005)) * st.tr[jjk].fac;
                }
                double maxBasalAreaOut = (baIst /= st.size) - this.getMaxSpeciesBasalArea(st, st.sp[iik], true);
                boolean doNotEndThinning = true;
                if (maxBasalAreaOut <= 0.0) {
                    doNotEndThinning = false;
                    continue;
                }
                do {
                    for (int i = 0; i < st.ntrees; ++i) {
                        if (st.tr[i].out >= 0 || !st.tr[i].crop) continue;
                        st.tr[i].updateCompetition();
                    }
                    int indexOfCroptree = -9;
                    double maxCompetition = -99999.9;
                    for (int i = 0; i < st.ntrees; ++i) {
                        if (st.tr[i].out >= 0 || !st.tr[i].crop) continue;
                        double maxBasalArea = st.tr[i].calculateMaxBasalArea() * st.tr[i].getModerateThinningFactor();
                        maxBasalArea = st.trule.thinningIntensity == 0.0 ? (maxBasalArea *= 100.0) : (maxBasalArea *= 2.0 - st.trule.thinningIntensity);
                        double maxN = maxBasalArea / (Math.PI * (st.tr[i].d * 0.005 * (st.tr[i].d * 0.005)));
                        double maxC66 = maxN * Math.PI * (st.tr[i].cw * 0.5 * (st.tr[i].cw * 0.5)) / 10000.0;
                        double c66Ratio = st.tr[i].c66xy / maxC66;
                        if (!(c66Ratio > maxCompetition)) continue;
                        indexOfCroptree = i;
                        maxCompetition = c66Ratio;
                    }
                    if (indexOfCroptree < 0) {
                        doNotEndThinning = false;
                        continue;
                    }
                    double flprozent = 0.0;
                    double flpromax = -99.9;
                    int merk = -9;
                    double h66 = st.tr[indexOfCroptree].h - 0.667 * (st.tr[indexOfCroptree].h - st.tr[indexOfCroptree].cb);
                    double r1 = st.tr[indexOfCroptree].cw * 0.5;
                    for (int i = 0; i < st.tr[indexOfCroptree].nNeighbor; ++i) {
                        if (!(st.tr[st.tr[indexOfCroptree].neighbor[i]].d > 7.0) || st.tr[st.tr[indexOfCroptree].neighbor[i]].out >= 0 || !st.trule.cutCompetingCropTrees && st.tr[st.tr[indexOfCroptree].neighbor[i]].crop || st.tr[st.tr[indexOfCroptree].neighbor[i]].habitat || st.tr[st.tr[indexOfCroptree].neighbor[i]].code != st.sp[iik].code) continue;
                        double radius = st.tr[st.tr[indexOfCroptree].neighbor[i]].calculateCwAtHeight(h66) * 0.5;
                        if (radius > 0.0) {
                            double distXS = (st.tr[indexOfCroptree].x - st.tr[st.tr[indexOfCroptree].neighbor[i]].x) * (st.tr[indexOfCroptree].x - st.tr[st.tr[indexOfCroptree].neighbor[i]].x);
                            double distYS = (st.tr[indexOfCroptree].y - st.tr[st.tr[indexOfCroptree].neighbor[i]].y) * (st.tr[indexOfCroptree].y - st.tr[st.tr[indexOfCroptree].neighbor[i]].y);
                            double ent = Math.sqrt(distXS + distYS);
                            flprozent = this.overlap(r1, radius, ent) / (Math.PI * (r1 * r1));
                        }
                        if (!(flpromax < flprozent)) continue;
                        merk = st.tr[indexOfCroptree].neighbor[i];
                        flpromax = flprozent;
                    }
                    if (merk == -9) {
                        doNotEndThinning = false;
                        continue;
                    }
                    st.tr[merk].out = st.year;
                    st.tr[merk].outtype = 2;
                    this.thinned += st.tr[merk].fac * st.tr[merk].v;
                    if (!((maxBasalAreaOut -= st.tr[merk].fac * Math.PI * (st.tr[merk].d * 0.005 * (st.tr[merk].d * 0.005)) / st.size) <= 0.0)) continue;
                    doNotEndThinning = false;
                } while (this.thinned < this.vmaxthinning && doNotEndThinning);
            }
        }
    }

    public void thinByQD(Stand st) {
        for (int i = 0; i < st.ntrees; ++i) {
            if (st.tr[i].out >= 0 || !st.tr[i].crop) continue;
            for (int j = 0; j < st.ntrees; ++j) {
                if (!(st.tr[j].d > 7.0) || st.tr[j].out >= 0 || st.tr[j].crop || st.tr[j].habitat) continue;
                double distXS = (st.tr[i].x - st.tr[j].x) * (st.tr[i].x - st.tr[j].x);
                double distYS = (st.tr[i].y - st.tr[j].y) * (st.tr[i].y - st.tr[j].y);
                double ent = Math.sqrt(distXS + distYS);
                if (st.tr[i].h > st.tr[i].si * 0.8 && ent < 0.9 * (st.tr[i].cw + st.tr[j].cw) * 0.5 && st.tr[j].h * 1.1 > st.tr[i].cb) {
                    st.tr[j].out = st.year;
                    st.tr[j].outtype = 2;
                }
                if (!(st.tr[i].h > st.tr[i].si * 0.3) || !(st.tr[i].h < st.tr[i].si * 0.8) || !(ent < 0.2 + (st.tr[i].cw + st.tr[j].cw) * 0.5)) continue;
                st.tr[j].out = st.year;
                st.tr[j].outtype = 2;
            }
        }
    }

    public void removethinCropTreeCompetition(Stand st, int species, double volout) {
        int i;
        double intensity = 3.0;
        if (intensity == 0.0) {
            intensity = 1.0;
        }
        double volRem = 0.0;
        boolean doNotEndThinning = true;
        if (volRem >= volout) {
            doNotEndThinning = false;
        } else {
            do {
                for (i = 0; i < st.ntrees; ++i) {
                    if (st.tr[i].out >= 0 || !st.tr[i].crop) continue;
                    st.tr[i].updateCompetition();
                }
                int indexOfCroptree = -9;
                double maxCompetition = -99999.9;
                for (int i2 = 0; i2 < st.ntrees; ++i2) {
                    if (st.tr[i2].out >= 0 || !st.tr[i2].crop) continue;
                    double maxBasalArea = st.tr[i2].calculateMaxBasalArea() * st.tr[i2].getModerateThinningFactor();
                    maxBasalArea = st.trule.thinningIntensity == 0.0 ? (maxBasalArea *= 100.0) : (maxBasalArea *= 2.0 - st.trule.thinningIntensity);
                    double maxN = maxBasalArea / (Math.PI * (st.tr[i2].d * 0.005 * (st.tr[i2].d * 0.005)));
                    double maxC66 = maxN * Math.PI * (st.tr[i2].cw * 0.5 * (st.tr[i2].cw * 0.5)) / 10000.0;
                    double c66Ratio = st.tr[i2].c66xy / maxC66;
                    if (!(c66Ratio > maxCompetition)) continue;
                    indexOfCroptree = i2;
                    maxCompetition = c66Ratio;
                }
                if (indexOfCroptree < 0) {
                    doNotEndThinning = false;
                    continue;
                }
                double dist = 9999.0;
                int merk = -9;
                double h66 = st.tr[indexOfCroptree].cb;
                for (int i3 = 0; i3 < st.tr[indexOfCroptree].nNeighbor; ++i3) {
                    if (!(st.tr[st.tr[indexOfCroptree].neighbor[i3]].d > 7.0) || st.tr[st.tr[indexOfCroptree].neighbor[i3]].code != species || st.tr[st.tr[indexOfCroptree].neighbor[i3]].out >= 0 || !st.trule.cutCompetingCropTrees && st.tr[st.tr[indexOfCroptree].neighbor[i3]].crop || st.tr[i3].habitat) continue;
                    double distXS = (st.tr[indexOfCroptree].x - st.tr[st.tr[indexOfCroptree].neighbor[i3]].x) * (st.tr[indexOfCroptree].x - st.tr[st.tr[indexOfCroptree].neighbor[i3]].x);
                    double distYS = (st.tr[indexOfCroptree].y - st.tr[st.tr[indexOfCroptree].neighbor[i3]].y) * (st.tr[indexOfCroptree].y - st.tr[st.tr[indexOfCroptree].neighbor[i3]].y);
                    double radius = st.tr[st.tr[indexOfCroptree].neighbor[i3]].calculateCwAtHeight(h66) * 0.5;
                    double ent = Math.sqrt(distXS + distYS);
                    if (!(ent - radius < st.tr[indexOfCroptree].cw * (0.75 / intensity)) || !(dist > ent - radius)) continue;
                    merk = st.tr[indexOfCroptree].neighbor[i3];
                    dist = ent - radius;
                }
                if (merk == -9) {
                    doNotEndThinning = false;
                    continue;
                }
                st.tr[merk].out = st.year;
                st.tr[merk].outtype = 2;
                if (!((volRem -= st.tr[merk].fac * st.tr[merk].v / st.size) >= volout)) continue;
                doNotEndThinning = false;
            } while (volRem <= volout && doNotEndThinning);
        }
        if (volRem <= volout) {
            for (i = 0; i < st.ntrees; ++i) {
                if (st.tr[i].out >= 0 || st.tr[i].crop || st.tr[i].code != species) continue;
                st.tr[i].out = st.year;
                st.tr[i].outtype = 2;
                if ((volRem -= st.tr[i].fac * st.tr[i].v / st.size) >= volout) break;
            }
        }
        if (volRem <= volout) {
            for (i = 0; i < st.ntrees; ++i) {
                if (st.tr[i].out >= 0 || !st.tr[i].crop || st.tr[i].code != species) continue;
                st.tr[i].out = st.year;
                st.tr[i].outtype = 2;
                if ((volRem -= st.tr[i].fac * st.tr[i].v / st.size) >= volout) break;
            }
        }
    }

    public void thinTempCropTreeCompetition(Stand st) {
        this.vmaxthinning = st.size * st.trule.maxThinningVolume - this.thinned;
        if (st.size * st.trule.maxOutVolume - this.vout < this.vmaxthinning) {
            this.vmaxthinning = st.size * st.trule.maxOutVolume - this.vout;
        }
        if (this.vmaxthinning > 0.0) {
            double maxStandBasalArea = this.getMaxStandBasalArea(st, true);
            maxStandBasalArea = st.trule.thinningIntensity == 0.0 ? (maxStandBasalArea *= 100.0) : (maxStandBasalArea *= 2.0 - st.trule.thinningIntensity);
            double maxBasalAreaOut = this.reduceBaOut(st, maxStandBasalArea);
            double intensity = st.trule.thinningIntensity;
            if (intensity == 0.0) {
                intensity = 1.0;
            }
            boolean doNotEndThinning = true;
            if (maxBasalAreaOut <= 0.0) {
                doNotEndThinning = false;
            } else {
                do {
                    for (int i = 0; i < st.ntrees; ++i) {
                        if (st.tr[i].out >= 0 || !st.tr[i].tempcrop) continue;
                        st.tr[i].updateCompetition();
                    }
                    int indexOfCroptree = -9;
                    double maxCompetition = -99999.9;
                    for (int i = 0; i < st.ntrees; ++i) {
                        if (st.tr[i].out >= 0 || !st.tr[i].tempcrop) continue;
                        double maxBasalArea = st.tr[i].calculateMaxBasalArea() * st.tr[i].getModerateThinningFactor();
                        maxBasalArea = st.trule.thinningIntensity == 0.0 ? (maxBasalArea *= 100.0) : (maxBasalArea *= 2.0 - st.trule.thinningIntensity);
                        double maxN = maxBasalArea / (Math.PI * (st.tr[i].d * 0.005 * (st.tr[i].d * 0.005)));
                        double maxC66 = maxN * Math.PI * (st.tr[i].cw * 0.5 * (st.tr[i].cw * 0.5)) / 10000.0;
                        double c66Ratio = st.tr[i].c66xy / maxC66;
                        if (!(c66Ratio > maxCompetition)) continue;
                        indexOfCroptree = i;
                        maxCompetition = c66Ratio;
                    }
                    if (indexOfCroptree < 0) {
                        doNotEndThinning = false;
                        continue;
                    }
                    double dist = 9999.0;
                    int merk = -9;
                    double h66 = st.tr[indexOfCroptree].cb;
                    for (int i = 0; i < st.tr[indexOfCroptree].nNeighbor; ++i) {
                        if (!(st.tr[st.tr[indexOfCroptree].neighbor[i]].d < 7.0) || st.tr[st.tr[indexOfCroptree].neighbor[i]].out >= 0 || !st.trule.cutCompetingCropTrees && st.tr[st.tr[indexOfCroptree].neighbor[i]].tempcrop || st.tr[st.tr[indexOfCroptree].neighbor[i]].habitat) continue;
                        double radius = st.tr[st.tr[indexOfCroptree].neighbor[i]].calculateCwAtHeight(h66) * 0.5;
                        double distXS = (st.tr[indexOfCroptree].x - st.tr[st.tr[indexOfCroptree].neighbor[i]].x) * (st.tr[indexOfCroptree].x - st.tr[st.tr[indexOfCroptree].neighbor[i]].x);
                        double distYS = (st.tr[indexOfCroptree].y - st.tr[st.tr[indexOfCroptree].neighbor[i]].y) * (st.tr[indexOfCroptree].y - st.tr[st.tr[indexOfCroptree].neighbor[i]].y);
                        double ent = Math.sqrt(distXS + distYS);
                        if (!(ent - radius < st.tr[indexOfCroptree].cw * (0.75 / intensity)) || !(dist > ent - radius)) continue;
                        merk = st.tr[indexOfCroptree].neighbor[i];
                        dist = ent - radius;
                    }
                    if (merk == -9) {
                        doNotEndThinning = false;
                        continue;
                    }
                    st.tr[merk].out = st.year;
                    st.tr[merk].outtype = 2;
                    this.thinned += st.tr[merk].fac * st.tr[merk].v;
                    if (!((maxBasalAreaOut -= st.tr[merk].fac * Math.PI * (st.tr[merk].d * 0.005 * (st.tr[merk].d * 0.005)) / st.size) <= 0.0)) continue;
                    doNotEndThinning = false;
                } while (this.thinned < this.vmaxthinning && doNotEndThinning);
            }
        }
    }

    public void thinCompetitionFromAbove(Stand st) {
        this.vmaxthinning = st.size * st.trule.maxThinningVolume - this.thinned;
        if (st.size * st.trule.maxOutVolume - this.vout < this.vmaxthinning) {
            this.vmaxthinning = st.size * st.trule.maxOutVolume - this.vout;
        }
        if (this.vmaxthinning > 0.0) {
            st.bha = 0.0;
            for (int i = 0; i < st.ntrees; ++i) {
                if (st.tr[i].out != -1) continue;
                st.bha += Math.PI * (st.tr[i].d * 0.005 * (st.tr[i].d * 0.005)) * st.tr[i].fac;
            }
            st.bha /= st.size;
            double maxStandBasalArea = this.getMaxStandBasalArea(st, true);
            maxStandBasalArea = st.trule.thinningIntensity == 0.0 ? (maxStandBasalArea *= 100.0) : (maxStandBasalArea *= 2.0 - st.trule.thinningIntensity);
            double maxBasalAreaOut = this.reduceBaOut(st, maxStandBasalArea);
            boolean doNotEndThinning = true;
            if (maxBasalAreaOut <= 0.0) {
                doNotEndThinning = false;
            } else {
                do {
                    int indextree = -9;
                    double maxOverlap = -99999.9;
                    for (int i = 0; i < st.ntrees; ++i) {
                        if (!(st.tr[i].d > 7.0) || st.tr[i].out >= 0 || st.tr[i].crop || st.tr[i].tempcrop || st.tr[i].habitat) continue;
                        double ovlp = 0.0;
                        for (int j = 0; j < st.tr[i].nNeighbor; ++j) {
                            double ri = st.tr[i].cw * 0.5;
                            double rj = st.tr[st.tr[i].neighbor[j]].cw * 0.5;
                            double distXS = (st.tr[i].x - st.tr[st.tr[i].neighbor[j]].x) * (st.tr[i].x - st.tr[st.tr[i].neighbor[j]].x);
                            double distYS = (st.tr[i].y - st.tr[st.tr[i].neighbor[j]].y) * (st.tr[i].y - st.tr[st.tr[i].neighbor[j]].y);
                            double distance = Math.sqrt(distXS + distYS);
                            if (!(ri + rj > distance) || !(ri > rj)) continue;
                            ovlp += this.overlap(rj, ri, distance);
                        }
                        if (!(ovlp > maxOverlap)) continue;
                        maxOverlap = ovlp;
                        indextree = i;
                    }
                    if (indextree == -9) {
                        doNotEndThinning = false;
                        continue;
                    }
                    st.tr[indextree].out = st.year;
                    st.tr[indextree].outtype = 2;
                    this.thinned += st.tr[indextree].fac * st.tr[indextree].v;
                    if (!((maxBasalAreaOut -= st.tr[indextree].fac * Math.PI * (st.tr[indextree].d * 0.005 * (st.tr[indextree].d * 0.005)) / st.size) <= 0.0)) continue;
                    doNotEndThinning = false;
                } while (this.thinned < this.vmaxthinning && doNotEndThinning);
            }
        }
    }

    public void thinCompetitionFromAbove2(Stand st) {
        double baIst;
        int iik;
        this.vmaxthinning = st.size * st.trule.maxThinningVolume - this.thinned;
        if (st.size * st.trule.maxOutVolume - this.vout < this.vmaxthinning) {
            this.vmaxthinning = st.size * st.trule.maxOutVolume - this.vout;
        }
        if (this.vmaxthinning > 0.0) {
            st.bha = 0.0;
            for (int i = 0; i < st.ntrees; ++i) {
                if (st.tr[i].out != -1) continue;
                st.bha += Math.PI * (st.tr[i].d * 0.005 * (st.tr[i].d * 0.005)) * st.tr[i].fac;
            }
            st.bha /= st.size;
            for (iik = 0; iik < st.nspecies; ++iik) {
                baIst = 0.0;
                for (int jjk = 0; jjk < st.ntrees; ++jjk) {
                    if (st.sp[iik].code != st.tr[jjk].code || st.tr[jjk].out >= 0 || !(st.tr[jjk].d >= 7.0)) continue;
                    baIst += Math.PI * (st.tr[jjk].d * 0.005 * (st.tr[jjk].d * 0.005)) * st.tr[jjk].fac;
                }
                double maxBasalAreaOut = (baIst /= st.size) - this.getMaxSpeciesBasalArea(st, st.sp[iik], true);
                boolean doNotEndThinning = true;
                if (maxBasalAreaOut <= 0.0) {
                    doNotEndThinning = false;
                    continue;
                }
                do {
                    int indextree = -9;
                    double maxOverlap = -99999.9;
                    for (int i = 0; i < st.ntrees; ++i) {
                        if (!(st.tr[i].d > 7.0) || st.tr[i].out >= 0 || st.tr[i].crop || st.tr[i].tempcrop || st.tr[i].habitat || st.tr[i].code != st.sp[iik].code) continue;
                        double ovlp = 0.0;
                        double ri = st.tr[i].cw * 0.5;
                        double distance = 0.0;
                        double rj = 0.0;
                        for (int j = 0; j < st.ntrees; ++j) {
                            if (i != j && st.tr[j].out < 0) {
                                double distXS = (st.tr[i].x - st.tr[j].x) * (st.tr[i].x - st.tr[j].x);
                                double distYS = (st.tr[i].y - st.tr[j].y) * (st.tr[i].y - st.tr[j].y);
                                distance = Math.sqrt(distXS + distYS);
                                rj = st.tr[j].cw * 0.5;
                            }
                            if (!(ri + rj > distance) || !(ri > rj)) continue;
                            ovlp += this.overlap(rj, ri, distance);
                        }
                        if (!(ovlp > maxOverlap)) continue;
                        maxOverlap = ovlp;
                        indextree = i;
                    }
                    if (indextree == -9) {
                        doNotEndThinning = false;
                        continue;
                    }
                    st.tr[indextree].out = st.year;
                    st.tr[indextree].outtype = 2;
                    this.thinned += st.tr[indextree].fac * st.tr[indextree].v;
                    if (!((maxBasalAreaOut -= st.tr[indextree].fac * Math.PI * (st.tr[indextree].d * 0.005 * (st.tr[indextree].d * 0.005)) / st.size) <= 0.0)) continue;
                    doNotEndThinning = false;
                } while (this.thinned < this.vmaxthinning && doNotEndThinning);
            }
        }
        for (iik = 0; iik < st.nspecies; ++iik) {
            baIst = 0.0;
            for (int jjk = 0; jjk < st.ntrees; ++jjk) {
                if (st.sp[iik].code != st.tr[jjk].code || st.tr[jjk].out >= 0 || !(st.tr[jjk].d >= 7.0)) continue;
                baIst += Math.PI * (st.tr[jjk].d * 0.005 * (st.tr[jjk].d * 0.005)) * st.tr[jjk].fac;
            }
            if (!((baIst /= st.size) / this.getMaxSpeciesBasalArea(st, st.sp[iik], true) < 0.8)) continue;
            double hbon = 25.0;
            boolean suchboni = true;
            for (int mm = 0; suchboni || mm < st.ntrees; ++mm) {
                if (st.sp[iik].code != st.tr[mm].code) continue;
                hbon = st.tr[mm].si;
                suchboni = false;
            }
            this.plantGap(st.sp[iik].code, hbon, 15.0, st);
        }
    }

    public void thinFromBelow(Stand st) {
        this.vmaxthinning = st.size * st.trule.maxThinningVolume - this.thinned;
        if (st.size * st.trule.maxOutVolume - this.vout < this.vmaxthinning) {
            this.vmaxthinning = st.size * st.trule.maxOutVolume - this.vout;
        }
        if (this.vmaxthinning > 0.0) {
            double maxG = this.getMaxStandBasalArea(st, true);
            maxG = st.trule.thinningIntensity == 0.0 ? (maxG *= 100.0) : (maxG *= 2.0 - st.trule.thinningIntensity);
            double baToTakeOut = this.reduceBaOut(st, maxG);
            double baout = 0.0;
            boolean doNotEndThinning = true;
            do {
                double dmin = 99999.9;
                int merk = -9;
                for (int i = 0; i < st.ntrees; ++i) {
                    if (st.tr[i].out >= 0 || !(dmin > st.tr[i].d) || st.tr[i].habitat) continue;
                    dmin = st.tr[i].d;
                    merk = i;
                }
                if (merk > -1 && baout < baToTakeOut) {
                    st.tr[merk].out = st.year;
                    st.tr[merk].outtype = 2;
                    this.thinned += st.tr[merk].fac * st.tr[merk].v;
                    baout += st.tr[merk].fac * Math.PI * (st.tr[merk].d * 0.005 * (st.tr[merk].d * 0.005)) / st.size;
                } else {
                    doNotEndThinning = false;
                }
                if (!(baout >= baToTakeOut)) continue;
                doNotEndThinning = false;
            } while (this.thinned < this.vmaxthinning && doNotEndThinning);
        }
    }

    public double getTotalOutVolume(Stand st) {
        double outvolume = 0.0;
        for (int i = 0; i < st.ntrees; ++i) {
            if (st.tr[i].out != st.year) continue;
            outvolume += st.tr[i].fac * st.tr[i].v;
        }
        return outvolume / st.size;
    }

    public double getTreatmentOutVolume(Stand st) {
        double volume = 0.0;
        for (int i = 0; i < st.ntrees; ++i) {
            if (st.tr[i].out != st.year || st.tr[i].outtype <= 1) continue;
            volume += st.tr[i].fac * st.tr[i].v;
        }
        return volume / st.size;
    }

    public double getHarvestedOutVolume(Stand st) {
        double volume = 0.0;
        for (int i = 0; i < st.ntrees; ++i) {
            if (st.tr[i].out != st.year || st.tr[i].outtype != 3) continue;
            volume += st.tr[i].fac * st.tr[i].v;
        }
        return volume / st.size;
    }

    public double getThinnedOutVolume(Stand st) {
        double volume = 0.0;
        for (int i = 0; i < st.ntrees; ++i) {
            if (st.tr[i].out != st.year || st.tr[i].outtype != 2) continue;
            volume += st.tr[i].fac * st.tr[i].v;
        }
        return volume / st.size;
    }

    public double getNCropTrees(Stand st) {
        double nCT = 0.0;
        for (int i = 0; i < st.ntrees; ++i) {
            if (!st.tr[i].crop || st.tr[i].out != -1) continue;
            nCT += 1.0;
        }
        return nCT;
    }

    public void checkMinHarvestVolume(Stand st) {
        if (this.getHarvestedOutVolume(st) < st.trule.minHarvestVolume) {
            for (int i = 0; i < st.ntrees; ++i) {
                if (st.tr[i].out != st.year || st.tr[i].outtype != 3 || st.tr[i].outBySkidtrail) continue;
                st.tr[i].out = -1;
                st.tr[i].outtype = 0;
            }
        }
    }

    public void checkMinThinningVolume(Stand st) {
        if (this.getThinnedOutVolume(st) < st.trule.minThinningVolume) {
            for (int i = 0; i < st.ntrees; ++i) {
                if (st.tr[i].out != st.year || st.tr[i].outtype != 2 || st.tr[i].outBySkidtrail) continue;
                st.tr[i].out = -1;
                st.tr[i].outtype = 0;
            }
        }
    }

    public void checkMinTreatmentOutVolume(Stand st) {
        if (this.getTreatmentOutVolume(st) < st.trule.minOutVolume * st.size) {
            for (int i = 0; i < st.ntrees; ++i) {
                if (st.tr[i].out != st.year || st.tr[i].outtype <= 1 || st.tr[i].outBySkidtrail) continue;
                st.tr[i].out = -1;
                st.tr[i].outtype = 0;
            }
        }
    }

    public void setStartHarvestingYears(Stand st) {
        st.trule.harvestingYears = 0;
    }

    public void setHarvestingYearsAddStep(Stand st) {
        st.trule.harvestingYears += st.trule.treatmentStep;
    }

    public double overlap(double r1, double r2, double e) {
        double x;
        double f = 0.0;
        if (r1 > r2) {
            x = r1;
            r1 = r2;
            r2 = x;
        }
        if (e - (r1 + r2) >= 0.0) {
            f = 0.0;
        }
        if (e - (r1 + r2) < 0.0) {
            if (e + r1 <= r2) {
                f = Math.PI * r1 * r1;
            } else {
                x = (e * e + r1 * r1 - r2 * r2) / (2.0 * e);
                double y = Math.sqrt(r1 * r1 - x * x);
                f = r1 * r1 * Math.acos((e * e + r1 * r1 - r2 * r2) / (2.0 * e * r1)) + r2 * r2 * Math.acos((e * e + r2 * r2 - r1 * r1) / (2.0 * e * r2)) - e * y;
            }
        }
        return f;
    }

    public void createSkidtrails(Stand st) {
        if (st.sp[0].trule.minCropTreeHeight * 0.8 < st.sp[0].h100) {
            double xmin = Double.POSITIVE_INFINITY;
            double xmax = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < st.ncpnt; ++i) {
                if (st.cpnt[i].x < xmin) {
                    xmin = st.cpnt[i].x;
                }
                if (!(st.cpnt[i].x > xmax)) continue;
                xmax = st.cpnt[i].x;
            }
            xmin -= st.trule.skidtrailDistance * 0.5;
            do {
                double x2 = (xmin += st.trule.skidtrailDistance) + st.trule.skidtrailWidth;
                for (int i = 0; i < st.ntrees; ++i) {
                    if (st.tr[i].out >= 0 || !(st.tr[i].x > xmin) || !(st.tr[i].x < x2)) continue;
                    st.tr[i].out = st.year;
                    st.tr[i].outBySkidtrail = true;
                    st.tr[i].outtype = st.tr[i].d < st.tr[i].sp.spDef.targetDiameter ? 2 : 3;
                }
            } while (xmin < xmax);
        }
    }

    public void markTreesAsHabitatTreesByDiameter(Stand st) {
        for (int i = 0; i < st.ntrees; ++i) {
            if (st.tr[i].out >= 0 || !(st.tr[i].d >= (double)st.trule.treeProtectedfromBHD) || st.tr[i].habitat) continue;
            st.tr[i].habitat = true;
        }
    }

    public int numberOfCropTrees(Species sp, double diameter, double percentage) {
        Tree atree = new Tree();
        atree.code = sp.code;
        atree.sp = sp;
        atree.d = diameter;
        atree.h = sp.hg;
        double dist_ct = atree.calculateCw();
        return (int)(10000.0 / (Math.PI * (dist_ct * dist_ct) / 4.0) * percentage / 100.0);
    }

    public void removeTargetTreesBySpecies(Stand st, int species, double volume) {
        this.vmaxharvest = st.size * volume;
        this.resetCropTrees(st);
        for (int i = 0; i < st.nspecies; ++i) {
            if (species == st.sp[i].code) {
                st.sp[i].trule.numberCropTreesWanted = 1000;
                st.sp[i].trule.targetCrownPercent = 99.9;
                st.sp[i].trule.targetDiameter = 7.0;
                st.sp[i].trule.minCropTreeHeight = 8.0;
                continue;
            }
            st.sp[i].trule.numberCropTreesWanted = 0;
            st.sp[i].trule.targetCrownPercent = 0.1;
            st.sp[i].trule.targetDiameter = 200.0;
            st.sp[i].trule.minCropTreeHeight = 12.0;
        }
        this.selectNCropTrees(st);
        if (this.vmaxharvest > 0.0) {
            for (int i = 0; i < st.ntrees - 1; ++i) {
                for (int j = i + 1; j < st.ntrees; ++j) {
                    if (!(st.tr[i].sp.trule.targetDiameter - st.tr[i].d > st.tr[j].sp.trule.targetDiameter - st.tr[j].d)) continue;
                    Tree trtemp = st.tr[i];
                    st.tr[i] = st.tr[j];
                    st.tr[j] = trtemp;
                }
            }
            for (int i = 0; i < st.ntrees; ++i) {
                if (st.tr[i].out >= 1 || !st.tr[i].crop) continue;
                for (int j = 0; j < st.ntrees; ++j) {
                    if (st.tr[j].out >= 0 || !st.tr[j].crop || st.tr[i].no.equals(st.tr[j].no)) continue;
                    double distXS = (st.tr[i].x - st.tr[j].x) * (st.tr[i].x - st.tr[j].x);
                    double distYS = (st.tr[i].y - st.tr[j].y) * (st.tr[i].y - st.tr[j].y);
                    double dist_trees = Math.sqrt(distXS + distYS);
                    double h66_i = st.tr[i].cb + (st.tr[i].h - st.tr[i].cb) / 3.0;
                    double dist_min = h66_i < st.tr[j].h ? (st.tr[i].calculateCwAtHeight(h66_i) + st.tr[j].calculateCwAtHeight(h66_i)) / 2.0 : 0.0;
                    if (!(this.harvested < this.vmaxharvest) || !(dist_trees < dist_min) || !(st.tr[j].sp.trule.targetDiameter - st.tr[j].d <= st.tr[i].sp.trule.targetDiameter - st.tr[i].d)) continue;
                    st.tr[j].out = st.year;
                    st.tr[j].outtype = 3;
                    this.vout += st.tr[j].fac * st.tr[j].v;
                    this.harvested += st.tr[j].fac * st.tr[j].v;
                }
            }
        }
    }

    public double getDegreeOfCover(int code, Stand st, boolean overstoryOnly) {
        double ks = 0.0;
        double hx = 0.0;
        if (overstoryOnly) {
            for (int i = 0; i < st.nspecies; ++i) {
                if (st.sp[i].code == 999) continue;
                hx = st.sp[i].hbon * 0.4;
                break;
            }
        }
        for (int j = 0; j < st.ntrees; ++j) {
            if (code != st.tr[j].code && code != 0 || st.tr[j].out >= 0 || !(st.tr[j].h > hx) || st.tr[j].code >= 900) continue;
            ks += st.tr[j].fac * Math.PI * (st.tr[j].cw * 0.5 * (st.tr[j].cw * 0.5));
        }
        double degree = ks / (10000.0 * st.size);
        return degree;
    }

    public void startPlanting(Stand st) {
        String[] psa;
        String ps = st.trule.plantingString;
        if (ps == null) {
            return;
        }
        if (ps.length() == 0) {
            return;
        }
        for (String psa1 : psa = ps.split(";")) {
            String[] sp_perc = psa1.split("\\[");
            int art = Integer.parseInt(sp_perc[0]);
            double ha = Double.parseDouble(sp_perc[1].substring(0, sp_perc[1].length() - 1).trim());
            double siteStd = 25.0;
            if (art > 200 && art < 400) {
                siteStd = 28.0;
            }
            if (art > 200 && art < 300) {
                siteStd = 28.0;
            }
            if (art > 500 && art < 600) {
                siteStd = 31.0;
            }
            if (art > 600 && art < 700) {
                siteStd = 40.0;
            }
            if (art > 700 && art < 800) {
                siteStd = 25.0;
            }
            if (art > 800 && art < 900) {
                siteStd = 31.0;
            }
            double site = -1.0;
            for (int j = 0; j < st.ntrees; ++j) {
                if (art != st.tr[j].code || !(site < st.tr[j].si)) continue;
                site = st.tr[j].si;
            }
            if (site < 0.0) {
                site = siteStd;
            }
            double spcov = this.getDegreeOfCover(art, st, false);
            Tree atree = new Tree(art, "atree", 20, -1, 0, 7.0, 8.0, 2.0, 0.0, -99.0, 1.0, 0.0, 0.0, 0.0, false, false, false, 3, 0.0, "");
            try {
                atree.sp = st.addspecies(atree);
            }
            catch (SpeciesNotDefinedException ex) {
                LOGGER.log(Level.SEVERE, "treegross", ex);
            }
            double cbx = atree.calculateCw();
            double gx = Math.PI * (cbx * 0.5 * (cbx * 0.5));
            int npl = 0;
            if (spcov < ha) {
                npl = (int)Math.round(10000.0 * (ha - spcov) / gx);
            }
            if (npl > 3000) {
                npl = 3000;
            }
            npl = (int)Math.round((double)npl * st.size);
            double ra = st.random.nextUniform();
            for (int j = 0; j < npl; ++j) {
                try {
                    if (st.addTreeFromPlanting(art, "p" + st.ntrees + "_" + st.year, 5, -1, 0.25, 0.5 * ra, 0.1, cbx, site, -9.0, -9.0, 0.0, 0, 0, 0)) continue;
                    break;
                }
                catch (SpeciesNotDefinedException e) {
                    LOGGER.log(Level.SEVERE, "treegross", e);
                }
            }
            for (int i = 0; i < st.ntrees; ++i) {
                st.tr[i].setMissingData();
            }
            GenerateXY xy = new GenerateXY();
            xy.zufall(st);
        }
    }

    public int plantGap(int code, double siteindex, double gapsize, Stand st) {
        int n = 0;
        double radius = 0.0;
        if (gapsize > 0.0) {
            radius = Math.sqrt(gapsize / Math.PI);
        }
        double xmin = 999999.0;
        double xmax = 0.0;
        double ymin = 999999.0;
        double ymax = 0.0;
        for (int i = 0; i < st.ncpnt; ++i) {
            if (st.cpnt[i].x < xmin) {
                xmin = st.cpnt[i].x;
            }
            if (st.cpnt[i].y < ymin) {
                ymin = st.cpnt[i].y;
            }
            if (st.cpnt[i].x > xmax) {
                xmax = st.cpnt[i].x;
            }
            if (!(st.cpnt[i].y > ymax)) continue;
            ymax = st.cpnt[i].y;
        }
        int nx = (int)Math.round((xmax - xmin) / (0.5 * radius));
        int ny = (int)Math.round((ymax - ymin) / (0.5 * radius));
        GenerateXY genxy = new GenerateXY();
        for (int i = 0; i < nx; ++i) {
            double xpos = (double)(i + 1) * 0.5 * radius;
            for (int j = 0; j < ny; ++j) {
                double ypos = (double)(j + 1) * 0.5 * radius;
                double fl = 0.0;
                for (int k = 0; k < st.ntrees; ++k) {
                    if (st.tr[k].out >= 0) continue;
                    double r2 = st.tr[k].cw * 0.5;
                    double distXS = (xpos - st.tr[k].x) * (xpos - st.tr[k].x);
                    double distYS = (ypos - st.tr[k].y) * (ypos - st.tr[k].y);
                    double dist = Math.sqrt(distXS + distYS);
                    fl += this.overlap(radius, r2, dist);
                }
                if (!(fl < 0.1 * gapsize)) continue;
                try {
                    double xra = 0.5 - st.random.nextNormal() * 0.5 * radius;
                    double yra = 0.5 - st.random.nextNormal() * 0.5 * radius;
                    if (genxy.pnpoly(xpos + xra, ypos + yra, st) == 0) {
                        xra = 0.0;
                        yra = 0.0;
                    }
                    st.addTreeFromPlanting(code, "p" + st.ntrees + "_" + st.year, 5, -1, 0.25, 1.0, 0.1, 2.52, siteindex, xpos + xra, ypos + yra, 0.0, 0, 0, 0);
                    continue;
                }
                catch (SpeciesNotDefinedException ex) {
                    LOGGER.log(Level.SEVERE, "treegross", ex);
                }
            }
        }
        return n;
    }
}

