/*
    (c) 2002 - 2022 Juergen Nagel, Jan Hansen
    Northwest German Forest Research Station (https://www.nw-fva.de), 
    Grätzelstr. 2, 37079 Göttingen, Germany
    E-Mail: Jan.Hansen@nw-fva.de
 
    This file is part of the TreeGrOSS libraray.

    TreeGrOSS is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    TreeGrOSS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with TreeGrOSS. If not, see http://www.gnu.org/licenses/.
*/

package treegross.base;

/**
 * This class is the plugin adapter for the regional competition model. The
 * regional model needs to be based on the stand and tree classes.
 *
 * - Version 7.1 2-AUG-2007
 */
public interface PlugInCompetition {
// Interfaces

    /**
     * Interface to get the current competition index c66 of a tree.
     *
     * @param t Tree object
     * @return the c66
     */
    public double getc66(Tree t);

    /**
     * Interface to get the current competition index c66c of a tree. c66c is
     * the release index. It is c66 before and after thinning.
     *
     * @param t Tree object
     * @return c66c (c=change)
     */
    public double getc66c(Tree t);

    /**
     * Interface to replace the distance dependent competition indeces c66 and
     * c66c of a tree. by the current value.
     *
     * @param t Tree object
     * @param influenceZoneRadius double
     */
    public void replaceC66xyAndC66cxy(Tree t, double influenceZoneRadius);
    
    /**
     * Interface to replace the distance undependent competition indeces c66 and
     * c66c of a tree. by the current value.
     * should lead to the same results as getc66c and get c66
     * @param t Tree object    
     */
    public void replaceC66AndC66c(Tree t);

}
