/*
    (c) 2002 - 2022 Juergen Nagel, Jan Hansen
    Northwest German Forest Research Station (https://www.nw-fva.de), 
    Grätzelstr. 2, 37079 Göttingen, Germany
    E-Mail: Jan.Hansen@nw-fva.de
 
    This file is part of the TreeGrOSS libraray.

    TreeGrOSS is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    TreeGrOSS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with TreeGrOSS. If not, see http://www.gnu.org/licenses/.
*/

package treegross.functions;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

/**
 *
 * @author sprauer
 */
public class InvLogit extends PostfixMathCommand {

    public InvLogit() {
        numberOfParameters = 1;
    }

    @Override
    @SuppressWarnings("unchecked") 
    public void run(Stack inStack) throws ParseException {
        // check the stack
        checkStack(inStack);

        // get the parameter from the stack
        Object param = inStack.pop();

        // check whether the argument is of the right type
        if (param instanceof Number) {
            // calculate the result
            double r = Math.exp((double) param) / (1 + Math.exp((double) param));
            // push the result on the inStack
            inStack.push(r);            
        } else {
            throw new ParseException("Invalid parameter type");
        }
    }

}
