/*
    (c) 2002 - 2022 Juergen Nagel, Jan Hansen
    Northwest German Forest Research Station (https://www.nw-fva.de), 
    Grätzelstr. 2, 37079 Göttingen, Germany
    E-Mail: Jan.Hansen@nw-fva.de
 
    This file is part of the TreeGrOSS libraray.

    TreeGrOSS is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    TreeGrOSS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with TreeGrOSS. If not, see http://www.gnu.org/licenses/.
*/

package treegross.functions;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author jhansen
 */
public class TGClassFunction implements TGFunction {

    private PlugInFunctionClass fc;
    private String function;
    private final static Logger LOGGER = Logger.getLogger(TGClassFunction.class.getName());

    @Override
    public void init(String xmlText) {
        // remove CLASS:
        function = xmlText;
        int m = function.indexOf("CLASS:");
        if (m > -1) {
            function = function.substring(m + 6);
        }
        // so können die Plugins nur im Package treegross.plugin plaziert werden
        String modelPlugIn = "treegross.plugin." + function;
        try {
            fc = (PlugInFunctionClass) Class.forName(modelPlugIn).getDeclaredConstructor().newInstance();
        } catch (ClassNotFoundException | IllegalAccessException | InstantiationException | IllegalArgumentException | InvocationTargetException | NoSuchMethodException | SecurityException e) {
            LOGGER.log(Level.SEVERE, "treegross, function class loading: ", e);
        }
    }

    @Override
    public int getType() {
        return TGFunction.CLASS_FUCNTION;
    }

    public PlugInFunctionClass getFunctionClass() {
        return fc;
    }

    @Override
    public String getFunctionText() {
        return function;
    }

    @Override
    public TGFunction clone() {
        TGClassFunction clone = new TGClassFunction();
        clone.init(function);
        return clone;
    }

    @Override
    public String toString() {
        return "CLASS:" + function;
    }
}
