/*
    (c) 2002 - 2022 Juergen Nagel, Jan Hansen
    Northwest German Forest Research Station (https://www.nw-fva.de), 
    Grätzelstr. 2, 37079 Göttingen, Germany
    E-Mail: Jan.Hansen@nw-fva.de
 
    This file is part of the TreeGrOSS libraray.

    TreeGrOSS is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    TreeGrOSS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with TreeGrOSS. If not, see http://www.gnu.org/licenses/.
*/

package treegross.meta;

import java.io.File;
import java.util.Arrays;

/**
 *
 * @author jhansen
 */
public class VersionInfo {

    public static String getVersion() {
        return "treegross 22.03 build 28.03.2022";
    }

    public static void main(String[] args) {
        System.out.println("This is the tree growth open source software libraray by nw-fva.de: " + VersionInfo.getVersion());
        String sep = File.pathSeparator;
        String[] split = System.getProperties().get("java.class.path").toString().split(sep);
        if (split.length > 0) {
            System.out.println("class path:");
            Arrays.sort(split);
            for (String l : split) {
                System.out.println(l);
            }
        }
    }
}
